/*
 * Decompiled with CFR 0.152.
 */
package jAudioFeatureExtractor;

import java.awt.Component;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class SortingTableModelDecorator
implements TableModelListener,
TableModel {
    private int[] indeci;
    private TableModel base;

    public SortingTableModelDecorator(TableModel base) {
        this.base = base;
        base.addTableModelListener(this);
        this.resetIndeci();
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        this.resetIndeci();
    }

    @Override
    public int getRowCount() {
        return this.base.getRowCount();
    }

    @Override
    public int getColumnCount() {
        return this.base.getColumnCount();
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.base.getColumnName(columnIndex);
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return this.base.getColumnClass(columnIndex);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this.base.isCellEditable(this.indeci[rowIndex], columnIndex);
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.base.getValueAt(this.indeci[rowIndex], columnIndex);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        this.base.setValueAt(aValue, this.indeci[rowIndex], columnIndex);
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        this.base.addTableModelListener(l);
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.base.removeTableModelListener(l);
    }

    public void sort(int index) {
        int i;
        Vector<Comparable> vectorColumn;
        Vector<Integer> vectorIndeci = new Vector<Integer>();
        if (index == 2) {
            vectorColumn = new Vector<Comparable>();
            i = 0;
            while (i < this.base.getRowCount()) {
                this.base.getValueAt(i, index);
                if (this.base.getValueAt(i, index).getClass().equals(String.class)) {
                    vectorColumn.add(Integer.valueOf(0));
                } else {
                    vectorColumn.add((Integer)this.base.getValueAt(i, index));
                }
                vectorIndeci.add(i);
                ++i;
            }
            this.intQuickSort(vectorColumn, vectorIndeci);
        } else {
            vectorColumn = new Vector();
            i = 0;
            while (i < this.base.getRowCount()) {
                vectorColumn.add((Comparable)this.base.getValueAt(i, index));
                vectorIndeci.add(i);
                ++i;
            }
            this.quickSort(vectorColumn, vectorIndeci);
        }
        Integer[] tmp = vectorIndeci.toArray(new Integer[0]);
        this.indeci = new int[tmp.length];
        i = 0;
        while (i < tmp.length) {
            this.indeci[i] = tmp[i];
            ++i;
        }
    }

    public void resetIndeci() {
        this.indeci = new int[this.base.getRowCount()];
        int i = 0;
        while (i < this.indeci.length) {
            this.indeci[i] = i;
            ++i;
        }
    }

    private void quickSort(Vector<Comparable> vectorColumn, Vector<Integer> vectorIndeci) {
        Vector<Comparable> greaterO = new Vector<Comparable>();
        Vector<Comparable> lesserO = new Vector<Comparable>();
        Vector<Integer> greaterI = new Vector<Integer>();
        Vector<Integer> lesserI = new Vector<Integer>();
        Comparable splitO = vectorColumn.get(0);
        int splitI = vectorIndeci.get(0);
        int i = 1;
        while (i < vectorColumn.size()) {
            int compare = vectorColumn.get(i).compareTo(splitO);
            if (compare <= 0) {
                lesserO.add(lesserO.size(), vectorColumn.get(i));
                lesserI.add(lesserI.size(), vectorIndeci.get(i));
            } else {
                greaterO.add(greaterO.size(), vectorColumn.get(i));
                greaterI.add(greaterI.size(), vectorIndeci.get(i));
            }
            ++i;
        }
        if (lesserO.size() > 0) {
            this.quickSort(lesserO, lesserI);
        }
        if (greaterO.size() > 0) {
            this.quickSort(greaterO, greaterI);
        }
        vectorColumn.clear();
        vectorIndeci.clear();
        i = 0;
        while (i < lesserO.size()) {
            vectorColumn.add(lesserO.get(i));
            vectorIndeci.add(lesserI.get(i));
            ++i;
        }
        vectorColumn.add(splitO);
        vectorIndeci.add(splitI);
        i = 0;
        while (i < greaterO.size()) {
            vectorColumn.add(greaterO.get(i));
            vectorIndeci.add(greaterI.get(i));
            ++i;
        }
    }

    private void intQuickSort(Vector<Integer> vectorColumn, Vector<Integer> vectorIndeci) {
        Vector<Integer> greaterO = new Vector<Integer>();
        Vector<Integer> lesserO = new Vector<Integer>();
        Vector<Integer> greaterI = new Vector<Integer>();
        Vector<Integer> lesserI = new Vector<Integer>();
        int splitO = vectorColumn.get(0);
        int splitI = vectorIndeci.get(0);
        int i = 1;
        while (i < vectorColumn.size()) {
            int compare = vectorColumn.get(i) - splitO;
            if (compare <= 0) {
                lesserO.add(lesserO.size(), vectorColumn.get(i));
                lesserI.add(lesserI.size(), vectorIndeci.get(i));
            } else {
                greaterO.add(greaterO.size(), vectorColumn.get(i));
                greaterI.add(greaterI.size(), vectorIndeci.get(i));
            }
            ++i;
        }
        if (lesserO.size() > 0) {
            this.intQuickSort(lesserO, lesserI);
        }
        if (greaterO.size() > 0) {
            this.intQuickSort(greaterO, greaterI);
        }
        vectorColumn.clear();
        vectorIndeci.clear();
        i = 0;
        while (i < lesserO.size()) {
            vectorColumn.add(lesserO.get(i));
            vectorIndeci.add(lesserI.get(i));
            ++i;
        }
        vectorColumn.add(splitO);
        vectorIndeci.add(splitI);
        i = 0;
        while (i < greaterO.size()) {
            vectorColumn.add(greaterO.get(i));
            vectorIndeci.add(greaterI.get(i));
            ++i;
        }
    }

    private int getRealPrefferedHeaderWidth(JTable t, int col) {
        TableColumn tc = t.getColumn(t.getColumnName(col));
        TableCellRenderer tcr = tc.getHeaderRenderer();
        if (tcr == null) {
            tcr = t.getTableHeader().getDefaultRenderer();
        }
        Component c = tcr.getTableCellRendererComponent(t, tc.getHeaderValue(), false, false, 0, 0);
        return c.getPreferredSize().width;
    }

    public int getRealPrefferedWidth(JTable t, int col) {
        int h = this.getRealPrefferedHeaderWidth(t, col);
        int b = this.getRealPrefferedBodyWidth(t, col);
        return Math.max(h, b);
    }

    private int getRealPrefferedBodyWidth(JTable t, int col) {
        int minWidth = 0;
        boolean thisRowSize = false;
        int i = 0;
        while (i < this.getRowCount()) {
            int ret = 0;
            TableCellRenderer r = t.getCellRenderer(i, col);
            Component c = r.getTableCellRendererComponent(t, t.getValueAt(i, col), false, false, i, col);
            ret = c.getPreferredSize().width;
            if (ret > minWidth) {
                minWidth = ret;
            }
            ++i;
        }
        return minWidth;
    }
}

