/*
 * Decompiled with CFR 0.152.
 */
package jAudioFeatureExtractor;

import jAudioFeatureExtractor.ACE.XMLParsers.FileFilterXML;
import jAudioFeatureExtractor.Controller;
import jAudioFeatureExtractor.DataTypes.RecordingInfo;
import jAudioFeatureExtractor.GeneralTools.GeneralMethods;
import jAudioFeatureExtractor.GeneralTools.StringMethods;
import jAudioFeatureExtractor.MIDIFrame;
import jAudioFeatureExtractor.OuterFrame;
import jAudioFeatureExtractor.RecordingFrame;
import jAudioFeatureExtractor.RecordingsTableModel;
import jAudioFeatureExtractor.SynthesisFrame;
import jAudioFeatureExtractor.jAudioTools.AudioMethods;
import jAudioFeatureExtractor.jAudioTools.AudioMethodsPlayback;
import jAudioFeatureExtractor.jAudioTools.AudioSamples;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;

public class RecordingSelectorPanel
extends JPanel
implements ActionListener {
    static final long serialVersionUID = 1L;
    public OuterFrame outer_frame;
    private JPanel recordings_panel;
    private JScrollPane recordings_scroll_pane;
    private JTable recordings_table;
    JButton values_save_path_button;
    JButton definitions_save_path_button;
    private JButton add_recordings_button;
    private JButton delete_recordings_button;
    private JButton view_recording_information_button;
    private JButton play_recording_directly_button;
    private JButton play_recording_samples_button;
    private JButton use_MIDI_file_button;
    private JFileChooser save_file_chooser;
    private JFileChooser load_recording_chooser;
    private JFileChooser load_feature_vector_file_chooser;
    private RecordingFrame recording_frame;
    private SynthesisFrame synthesis_frame;
    private MIDIFrame midi_frame;
    JTextArea values_save_path_text_field;
    JTextArea definitions_save_path_text_field;
    private Controller controller;

    public RecordingSelectorPanel(OuterFrame outer_frame, Controller c) {
        this.outer_frame = outer_frame;
        this.controller = c;
        Color blue = new Color(0.75f, 0.85f, 1.0f);
        this.controller.dm_.recordingInfo = null;
        this.controller.dm_.playback_thread = null;
        this.save_file_chooser = null;
        this.load_recording_chooser = null;
        this.recording_frame = null;
        this.synthesis_frame = null;
        this.midi_frame = null;
        int horizontal_gap = 6;
        int vertical_gap = 11;
        this.setLayout(new BorderLayout(horizontal_gap, vertical_gap));
        this.add((Component)new JLabel("RECORDINGS:"), "North");
        this.recordings_panel = null;
        this.setUpRecordingListTable();
        JPanel button_panel = new JPanel(new GridLayout(4, 2, horizontal_gap, vertical_gap));
        button_panel.setBackground(blue);
        this.add_recordings_button = new JButton("Add Recordings");
        this.add_recordings_button.addActionListener(this.controller.addRecordingsAction);
        button_panel.add(this.add_recordings_button);
        this.delete_recordings_button = new JButton("Delete Recordings");
        this.delete_recordings_button.addActionListener(this.controller.removeRecordingsAction);
        button_panel.add(this.delete_recordings_button);
        this.values_save_path_button = new JButton("Feature Values Save Path:");
        button_panel.add(this.values_save_path_button);
        this.values_save_path_button.addActionListener(this);
        this.values_save_path_text_field = new JTextArea("feature_values_1.xml", 1, 20);
        button_panel.add(this.values_save_path_text_field);
        this.definitions_save_path_button = new JButton("Feature Definitions Save Path:");
        button_panel.add(this.definitions_save_path_button);
        this.definitions_save_path_button.addActionListener(this);
        this.definitions_save_path_text_field = new JTextArea("feature_definitions_1.xml", 1, 20);
        button_panel.add(this.definitions_save_path_text_field);
        button_panel.add(new JLabel(""));
        this.add((Component)button_panel, "South");
        this.addTableMouseListener();
        this.controller.removeRecordingsAction.setModel(this.controller, this.recordings_table);
        this.controller.playSamplesAction.setTable(this.recordings_table);
        this.controller.playNowAction.setTable(this.recordings_table);
        this.controller.editRecordingsAction.setTable(this.recordings_table, outer_frame);
        this.controller.viewFileInfoAction.setTable(this.recordings_table);
        this.controller.addBatchAction.setFilePath(this.values_save_path_text_field, this.definitions_save_path_text_field);
        this.controller.viewBatchAction.setRecordingFields(this.definitions_save_path_text_field, this.values_save_path_text_field);
    }

    public void addRecordings(File[] files_to_add) {
        RecordingInfo[] recording_info = new RecordingInfo[files_to_add.length];
        int i = 0;
        while (i < files_to_add.length) {
            recording_info[i] = null;
            if (files_to_add[i].exists()) {
                try {
                    AudioSamples audio_samples = null;
                    if (this.controller.validate.isSelected()) {
                        audio_samples = new AudioSamples(files_to_add[i], files_to_add[i].getPath(), false);
                    }
                    if (this.controller.storeSamples.isSelected()) {
                        if (audio_samples == null) {
                            audio_samples = new AudioSamples(files_to_add[i], files_to_add[i].getPath(), false);
                        }
                    } else {
                        audio_samples = null;
                    }
                    recording_info[i] = new RecordingInfo(files_to_add[i].getName(), files_to_add[i].getPath(), audio_samples, false);
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(null, e.getMessage(), "ERROR", 0);
                }
            } else {
                JOptionPane.showMessageDialog(null, "The selected file " + files_to_add[i].getName() + " does not exist.", "ERROR", 0);
            }
            ++i;
        }
        int number_old_recordings = 0;
        if (this.controller.dm_.recordingInfo != null) {
            number_old_recordings = this.controller.dm_.recordingInfo.length;
        }
        int number_new_recordings = 0;
        number_new_recordings = recording_info.length;
        Object[] temp_recording_list = new RecordingInfo[number_old_recordings + number_new_recordings];
        int i2 = 0;
        while (i2 < number_old_recordings) {
            temp_recording_list[i2] = this.controller.dm_.recordingInfo[i2];
            ++i2;
        }
        i2 = 0;
        while (i2 < number_new_recordings) {
            temp_recording_list[i2 + number_old_recordings] = recording_info[i2];
            ++i2;
        }
        i2 = 0;
        while (i2 < temp_recording_list.length - 1) {
            if (temp_recording_list[i2] != null) {
                String current_path = ((RecordingInfo)temp_recording_list[i2]).file_path;
                int j = i2 + 1;
                while (j < temp_recording_list.length) {
                    if (temp_recording_list[j] != null && current_path.equals(((RecordingInfo)temp_recording_list[j]).file_path)) {
                        temp_recording_list[j] = null;
                    }
                    ++j;
                }
            }
            ++i2;
        }
        Object[] results = GeneralMethods.removeNullEntriesFromArray(temp_recording_list);
        if (results != null) {
            this.controller.dm_.recordingInfo = new RecordingInfo[results.length];
            int i3 = 0;
            while (i3 < results.length) {
                this.controller.dm_.recordingInfo[i3] = (RecordingInfo)results[i3];
                ++i3;
            }
        }
        this.controller.rtm_.fillTable(this.controller.dm_.recordingInfo);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource().equals(this.delete_recordings_button)) {
            this.deleteRecordings();
        } else if (event.getSource().equals(this.view_recording_information_button)) {
            this.viewRecordingInformation();
        } else if (event.getSource().equals(this.values_save_path_button)) {
            this.browseFeatureValuesSavePath();
        } else if (event.getSource().equals(this.definitions_save_path_button)) {
            this.browseFeatureDefinitionsSavePath();
        }
    }

    private void deleteRecordings() {
        int[] selected_rows = this.recordings_table.getSelectedRows();
        int i = 0;
        while (i < selected_rows.length) {
            this.controller.dm_.recordingInfo[selected_rows[i]] = null;
            ++i;
        }
        Object[] results = GeneralMethods.removeNullEntriesFromArray(this.controller.dm_.recordingInfo);
        if (results != null) {
            this.controller.dm_.recordingInfo = new RecordingInfo[results.length];
            int i2 = 0;
            while (i2 < results.length) {
                this.controller.dm_.recordingInfo[i2] = (RecordingInfo)results[i2];
                ++i2;
            }
            this.controller.rtm_.fillTable(this.controller.dm_.recordingInfo);
        } else {
            this.controller.dm_.recordingInfo = null;
            this.controller.rtm_.clearTable();
        }
    }

    public void addTableMouseListener() {
        this.recordings_table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                if (event.getClickCount() == 2) {
                    int[] row_clicked = new int[]{RecordingSelectorPanel.this.recordings_table.rowAtPoint(event.getPoint())};
                    RecordingSelectorPanel.this.viewRecordingInformation();
                    System.out.println("Clicked");
                }
            }
        });
    }

    private void viewRecordingInformation() {
        int[] selected_rows = this.recordings_table.getSelectedRows();
        int i = 0;
        while (i < selected_rows.length) {
            try {
                File file = new File(this.controller.dm_.recordingInfo[selected_rows[i]].file_path);
                String data = AudioMethods.getAudioFileFormatData(file);
                JOptionPane.showMessageDialog(null, data, "FILE INFORMATION", 1);
            }
            catch (Exception e) {
                String message = "Could not display file information for file " + this.controller.dm_.recordingInfo[selected_rows[i]].file_path + "\n" + e.getMessage();
                JOptionPane.showMessageDialog(null, message, "ERROR", 0);
            }
            ++i;
        }
    }

    private void playRecordingDirectly() {
        try {
            int selected_row = this.recordings_table.getSelectedRow();
            if (selected_row < 0) {
                throw new Exception("No file selcected for playback.");
            }
            File play_file = new File(this.controller.dm_.recordingInfo[selected_row].file_path);
            try {
                AudioInputStream audio_input_stream = AudioSystem.getAudioInputStream(play_file);
                audio_input_stream = AudioMethods.convertUnsupportedFormat(audio_input_stream);
                SourceDataLine source_data_line = AudioMethods.getSourceDataLine(audio_input_stream.getFormat(), null);
                this.stopPlayback();
                this.controller.dm_.playback_thread = AudioMethodsPlayback.playAudioInputStreamInterruptible(audio_input_stream, source_data_line);
            }
            catch (UnsupportedAudioFileException ex) {
                throw new Exception("File " + play_file.getName() + " has an unsupported audio format.");
            }
            catch (Exception ex) {
                throw new Exception("File " + play_file.getName() + " is not playable.\n" + ex.getMessage());
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(null, ex.getMessage(), "ERROR", 0);
        }
    }

    private void playRecordingSamples() {
        try {
            int selected_row = this.recordings_table.getSelectedRow();
            if (selected_row < 0) {
                throw new Exception("No file selcected for playback.");
            }
            RecordingInfo selected_audio = this.controller.dm_.recordingInfo[selected_row];
            try {
                AudioInputStream audio_input_stream = null;
                if (selected_audio.samples != null) {
                    audio_input_stream = selected_audio.samples.getAudioInputStreamChannelSegregated();
                } else {
                    File load_file = new File(selected_audio.file_path);
                    AudioSamples samples = new AudioSamples(load_file, load_file.getPath(), false);
                    if (this.controller.storeSamples.isSelected()) {
                        selected_audio.samples = samples;
                    }
                    audio_input_stream = samples.getAudioInputStreamChannelSegregated();
                }
                SourceDataLine source_data_line = AudioMethods.getSourceDataLine(audio_input_stream.getFormat(), null);
                this.stopPlayback();
                this.controller.dm_.playback_thread = AudioMethodsPlayback.playAudioInputStreamInterruptible(audio_input_stream, source_data_line);
            }
            catch (UnsupportedAudioFileException ex) {
                throw new Exception("File " + selected_audio.file_path + " has an unsupported audio format.");
            }
            catch (Exception ex) {
                throw new Exception("File " + selected_audio.file_path + " is not playable.\n" + ex.getMessage());
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(null, ex.getMessage(), "ERROR", 0);
        }
    }

    private void stopPlayback() {
        if (this.controller.dm_.playback_thread != null) {
            this.controller.dm_.playback_thread.stopPlaying();
        }
        this.controller.dm_.playback_thread = null;
    }

    private void recordNewRecording() {
        if (this.recording_frame == null) {
            this.recording_frame = new RecordingFrame(this.controller);
        } else {
            this.recording_frame.setVisible(true);
        }
    }

    private void setUpRecordingListTable() {
        if (this.recordings_table != null) {
            this.remove(this.recordings_table);
        }
        Object[] column_names = new Object[]{new String("Name"), new String("Path")};
        int number_recordings = 0;
        if (this.controller.dm_.recordingInfo != null) {
            number_recordings = this.controller.dm_.recordingInfo.length;
        }
        this.controller.rtm_ = new RecordingsTableModel(column_names, number_recordings);
        this.controller.rtm_.fillTable(this.controller.dm_.recordingInfo);
        this.recordings_table = new JTable(this.controller.rtm_);
        this.recordings_scroll_pane = new JScrollPane(this.recordings_table);
        this.recordings_panel = new JPanel(new GridLayout(1, 1));
        this.recordings_panel.add(this.recordings_scroll_pane);
        this.add((Component)this.recordings_panel, "Center");
        this.controller.rtm_.fireTableDataChanged();
        this.repaint();
        this.outer_frame.repaint();
    }

    private void browseFeatureValuesSavePath() {
        String path = this.chooseSavePath();
        if (path != null) {
            this.values_save_path_text_field.setText(path);
        }
    }

    private void browseFeatureDefinitionsSavePath() {
        String path = this.chooseSavePath();
        if (path != null) {
            this.definitions_save_path_text_field.setText(path);
        }
    }

    private String chooseSavePath() {
        if (this.save_file_chooser == null) {
            this.save_file_chooser = new JFileChooser();
            this.save_file_chooser.setCurrentDirectory(new File("."));
            this.save_file_chooser.setFileFilter(new FileFilterXML());
        }
        String path = null;
        int dialog_result = this.save_file_chooser.showSaveDialog(this);
        if (dialog_result == 0) {
            int overwrite;
            File to_save_to = this.save_file_chooser.getSelectedFile();
            path = to_save_to.getPath();
            String ext = StringMethods.getExtension(path);
            if (ext == null) {
                path = String.valueOf(path) + ".xml";
                to_save_to = new File(path);
            } else if (!ext.equals(".xml")) {
                path = String.valueOf(StringMethods.removeExtension(path)) + ".xml";
                to_save_to = new File(path);
            }
            if (to_save_to.exists() && (overwrite = JOptionPane.showConfirmDialog(null, "This file already exists.\nDo you wish to overwrite it?", "WARNING", 0)) != 0) {
                path = null;
            }
        }
        return path;
    }
}

