/*
 * Decompiled with CFR 0.152.
 */
package jAudioFeatureExtractor;

import jAudioFeatureExtractor.Controller;
import jAudioFeatureExtractor.jMIDITools.FileFilterMIDI;
import jAudioFeatureExtractor.jMIDITools.MIDIMethodsPlayback;
import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;

public class MIDIFrame
extends JFrame
implements ActionListener {
    static final long serialVersionUID = 1L;
    private Controller controller;
    private Sequence midi_sequence;
    private Sequencer midi_sequencer;
    private JFileChooser load_file_chooser;
    private JTextArea midi_file_name_text_area;
    private JButton load_midi_file_button;
    private JButton play_midi_button;
    private JButton stop_playing_midi_button;
    private JButton done_button;

    public MIDIFrame() {
        this.setTitle("Load and Play MIDI Files");
        Color blue = new Color(0.75f, 0.85f, 1.0f);
        this.getContentPane().setBackground(blue);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                MIDIFrame.this.done();
            }
        });
        this.midi_sequence = null;
        this.midi_sequencer = null;
        this.load_file_chooser = null;
        this.midi_file_name_text_area = new JTextArea();
        this.midi_file_name_text_area.setEditable(false);
        this.midi_file_name_text_area.setLineWrap(false);
        this.midi_file_name_text_area.setRows(1);
        this.load_midi_file_button = new JButton("Load MID File");
        this.load_midi_file_button.addActionListener(this);
        this.play_midi_button = new JButton("Play MIDI");
        this.play_midi_button.addActionListener(this);
        this.stop_playing_midi_button = new JButton("Stop Playback");
        this.stop_playing_midi_button.addActionListener(this);
        this.done_button = new JButton("Done");
        this.done_button.addActionListener(this);
        int horizontal_gap = 6;
        int vertical_gap = 11;
        this.setLayout(new GridLayout(6, 2, horizontal_gap, vertical_gap));
        this.add(this.load_midi_file_button);
        this.add(new JLabel(""));
        this.add(new JLabel("Currently Loaded File Name:"));
        this.add(this.midi_file_name_text_area);
        this.add(new JLabel(""));
        this.add(new JLabel(""));
        this.add(this.play_midi_button);
        this.add(this.stop_playing_midi_button);
        this.add(new JLabel(""));
        this.add(new JLabel(""));
        this.add(new JLabel(""));
        this.add(this.done_button);
        this.pack();
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource().equals(this.load_midi_file_button)) {
            this.loadMIDIFile();
        } else if (event.getSource().equals(this.play_midi_button)) {
            this.playMIDI();
        } else if (event.getSource().equals(this.stop_playing_midi_button)) {
            this.stopMIDIPlayback();
        } else if (event.getSource().equals(this.done_button)) {
            this.done();
        }
    }

    private void loadMIDIFile() {
        if (this.load_file_chooser == null) {
            this.load_file_chooser = new JFileChooser();
            this.load_file_chooser.setCurrentDirectory(new File("."));
            this.load_file_chooser.setFileFilter(new FileFilterMIDI());
        }
        File midi_file = null;
        int dialog_result = this.load_file_chooser.showOpenDialog(this);
        if (dialog_result == 0) {
            midi_file = this.load_file_chooser.getSelectedFile();
            if (midi_file.exists()) {
                try {
                    this.midi_sequence = MidiSystem.getSequence(midi_file);
                    this.midi_file_name_text_area.setText(midi_file.getName());
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(null, e.getMessage(), "ERROR", 0);
                }
            } else {
                JOptionPane.showMessageDialog(null, "The selected file does not exist.", "ERROR", 0);
            }
        }
    }

    private void playMIDI() {
        try {
            if (this.midi_sequencer != null) {
                this.stopMIDIPlayback();
            }
            if (this.midi_sequence == null) {
                throw new Exception("No MIDI file has been loaded yet.");
            }
            this.midi_sequencer = MIDIMethodsPlayback.playMIDISequence(this.midi_sequence);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, e.getMessage(), "ERROR", 0);
        }
    }

    private void stopMIDIPlayback() {
        if (this.midi_sequencer != null) {
            this.midi_sequencer.stop();
            this.midi_sequencer = null;
        }
    }

    private void done() {
        this.stopMIDIPlayback();
        this.setVisible(false);
    }
}

