/*
 * Decompiled with CFR 0.152.
 */
package jAudioFeatureExtractor;

import jAudioFeatureExtractor.Controller;
import jAudioFeatureExtractor.ErrorGUI;
import jAudioFeatureExtractor.OuterFrame;
import jAudioFeatureExtractor.ProgressFrame;
import jAudioFeatureExtractor.Updater;
import java.io.File;
import java.io.FileOutputStream;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class ExtractionThread
extends Thread
implements Updater {
    Runnable suspendGUI;
    Runnable resumeGUI;
    ErrorGUI errorGUI;
    UpdateGUI updateGUI;
    Controller controller;
    OuterFrame outerFrame;
    boolean perFile;
    boolean perWindow;
    String valuesSavePath;
    String definitionSavePath;
    int windowSize;
    double windowOverlap;
    boolean hasRun = false;
    ProgressFrame progressFrame;

    public ExtractionThread(Controller c, OuterFrame of) {
        this.controller = c;
        this.outerFrame = of;
        this.suspendGUI = new Runnable(){

            @Override
            public void run() {
                ExtractionThread.this.outerFrame.setEnabled(false);
            }
        };
        this.resumeGUI = new Runnable(){

            @Override
            public void run() {
                ExtractionThread.this.outerFrame.setEnabled(true);
                ExtractionThread.this.progressFrame.setVisible(false);
                JOptionPane.showMessageDialog(null, "Features successfully extracted and saved.", "DONE", 1);
            }
        };
        this.updateGUI = new UpdateGUI();
        c.dm_.setUpdater(this);
        this.progressFrame = new ProgressFrame();
        this.errorGUI = new ErrorGUI(this.progressFrame);
    }

    public void setup(boolean perFile, boolean perWindow, String valuesSavePath, String definitionSavePath, int windowSize, double windowOverlap) {
        this.perFile = perFile;
        this.perWindow = perWindow;
        this.valuesSavePath = valuesSavePath;
        this.definitionSavePath = definitionSavePath;
        this.windowSize = windowSize;
        this.windowOverlap = windowOverlap;
    }

    @Override
    public void run() {
        try {
            SwingUtilities.invokeAndWait(this.suspendGUI);
            this.controller.dm_.validateFile(this.definitionSavePath, this.valuesSavePath);
            File feature_values_save_file = new File(this.valuesSavePath);
            File feature_definitions_save_file = new File(this.definitionSavePath);
            FileOutputStream values_to = new FileOutputStream(feature_values_save_file);
            FileOutputStream definitions_to = new FileOutputStream(feature_definitions_save_file);
            this.controller.dm_.featureKey = definitions_to;
            this.controller.dm_.featureValue = values_to;
            this.controller.dm_.extract(this.windowSize, this.windowOverlap, this.controller.samplingRateAction.getSamplingRate(), this.controller.normalise.isSelected(), this.perWindow, this.perFile, this.controller.dm_.recordingInfo, this.controller.outputTypeAction.getSelected());
            SwingUtilities.invokeLater(this.resumeGUI);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.errorGUI.e = e;
            SwingUtilities.invokeLater(this.errorGUI);
            SwingUtilities.invokeLater(this.resumeGUI);
        }
        this.hasRun = true;
    }

    @Override
    public void announceUpdate(int fileNumber, int fileDone) {
        this.updateGUI.setPos(fileNumber, fileDone);
        SwingUtilities.invokeLater(this.updateGUI);
    }

    @Override
    public void announceUpdate(int fileDone) {
        this.updateGUI.setPos(fileDone);
        SwingUtilities.invokeLater(this.updateGUI);
    }

    @Override
    public void setNumberOfFiles(int files) {
        this.updateGUI.setLengths(files);
    }

    @Override
    public void setFileLength(int window) {
        this.updateGUI.setMaxWindows(window);
    }

    public boolean hasRun() {
        return this.hasRun();
    }

    class UpdateGUI
    implements Runnable {
        int numberOfFiles;
        int file;
        int thisFileLength = 0;
        int pos;

        UpdateGUI() {
        }

        public void setLengths(int file) {
            this.numberOfFiles = file;
        }

        public void setMaxWindows(int maxWin) {
            this.thisFileLength = maxWin;
        }

        public void setPos(int file, int pos) {
            this.file = file;
            this.pos = pos;
        }

        public void setPos(int pos) {
            this.pos = pos;
        }

        @Override
        public void run() {
            ExtractionThread.this.progressFrame.setVisible(true);
            ExtractionThread.this.progressFrame.fileProgressBar.setMaximum(this.thisFileLength);
            ExtractionThread.this.progressFrame.overallProgressBar.setMaximum(this.numberOfFiles);
            ExtractionThread.this.progressFrame.fileProgressBar.setValue(this.pos);
            ExtractionThread.this.progressFrame.overallProgressBar.setValue(this.file);
        }
    }
}

