/*
 * Decompiled with CFR 0.152.
 */
package jAudioFeatureExtractor.AudioFeatures;

import jAudioFeatureExtractor.ACE.DataTypes.FeatureDefinition;
import jAudioFeatureExtractor.AudioFeatures.FeatureExtractor;

public class SpectralFlux
extends FeatureExtractor {
    public SpectralFlux() {
        String name = "Spectral Flux";
        String description = "A measure of the amount of spectral change in a signal. Found by calculating the change in the magnitude spectrum from frame to frame.";
        boolean is_sequential = true;
        int dimensions = 1;
        this.definition = new FeatureDefinition(name, description, is_sequential, dimensions);
        this.dependencies = new String[2];
        this.dependencies[0] = "Magnitude Spectrum";
        this.dependencies[1] = "Magnitude Spectrum";
        this.offsets = new int[2];
        this.offsets[0] = 0;
        this.offsets[1] = -1;
    }

    @Override
    public double[] extractFeature(double[] samples, double sampling_rate, double[][] other_feature_values) throws Exception {
        double[] this_magnitude_spectrum = other_feature_values[0];
        double[] previous_magnitude_spectrum = other_feature_values[1];
        double sum = 0.0;
        int bin = 0;
        while (bin < this_magnitude_spectrum.length) {
            double difference = this_magnitude_spectrum[bin] - previous_magnitude_spectrum[bin];
            double differences_squared = difference * difference;
            sum += differences_squared;
            ++bin;
        }
        double[] result = new double[]{sum};
        return result;
    }

    @Override
    public Object clone() {
        return new SpectralFlux();
    }
}

