/*
 * Decompiled with CFR 0.152.
 */
package jAudioFeatureExtractor.AudioFeatures;

import jAudioFeatureExtractor.ACE.DataTypes.FeatureDefinition;
import jAudioFeatureExtractor.AudioFeatures.FeatureExtractor;

public class HarmonicSpectralFlux
extends FeatureExtractor {
    public HarmonicSpectralFlux() {
        String name = new String("Partial Based Spectral Flux");
        String description = new String("Cacluate the correlation bettween adjacent frames based peaks instead of spectral bins.  Peak tracking is primitive - whe the number of bins changes, the bottom bins are matched sequentially and the extra unmatched bins are ignored.");
        this.definition = new FeatureDefinition(name, description, true, 1);
        this.dependencies = new String[]{"Peak Detection", "Peak Detection"};
        int[] nArray = new int[2];
        nArray[1] = -1;
        this.offsets = nArray;
    }

    @Override
    public double[] extractFeature(double[] samples, double sampling_rate, double[][] other_feature_values) {
        double[] result = new double[1];
        double[] old = other_feature_values[1];
        double[] now = other_feature_values[0];
        double y2 = 0.0;
        double x2 = 0.0;
        double xy = 0.0;
        double y = 0.0;
        double x = 0.0;
        int peakCount = Math.min(old.length, now.length);
        int i = 0;
        while (i < peakCount) {
            x += old[i];
            y += now[i];
            xy += old[i] * now[i];
            x2 = old[i] * old[i];
            y2 = now[i] * now[i];
            ++i;
        }
        double top = xy - x * y / (double)peakCount;
        double bottom = Math.sqrt(Math.abs((x2 - x * x / (double)peakCount) * (y2 - y * y / (double)peakCount)));
        result[0] = top / bottom;
        return result;
    }

    @Override
    public Object clone() {
        return new HarmonicSpectralFlux();
    }
}

