/*
 * Decompiled with CFR 0.152.
 */
package jAudioFeatureExtractor.AudioFeatures;

import jAudioFeatureExtractor.ACE.DataTypes.FeatureDefinition;
import jAudioFeatureExtractor.AudioFeatures.FeatureExtractor;
import jAudioFeatureExtractor.GeneralTools.Statistics;

public class FFTBinFrequencies
extends FeatureExtractor {
    public FFTBinFrequencies() {
        String name = "FFT Bin Frequency Labels";
        String description = "The bin label, in Hz, of each power spectrum or magnitude spectrum bin. Not useful as a feature in itself, but useful for calculating other features from the magnitude spectrum and power spectrum.";
        boolean is_sequential = true;
        int dimensions = 0;
        this.definition = new FeatureDefinition(name, description, is_sequential, dimensions);
        this.dependencies = null;
        this.offsets = null;
    }

    @Override
    public double[] extractFeature(double[] samples, double sampling_rate, double[][] other_feature_values) throws Exception {
        int fft_size;
        int number_bins = fft_size = Statistics.ensureIsPowerOfN(samples.length, 2);
        double bin_width = sampling_rate / (double)number_bins;
        double offset = bin_width / 2.0;
        int number_unfolded_bins = fft_size / 2;
        double[] labels = new double[number_unfolded_bins];
        int bin = 0;
        while (bin < labels.length) {
            labels[bin] = (double)bin * bin_width + offset;
            ++bin;
        }
        return labels;
    }

    @Override
    public Object clone() {
        return new FFTBinFrequencies();
    }
}

