/*
 * Decompiled with CFR 0.152.
 */
package jAudioFeatureExtractor.AudioFeatures;

import jAudioFeatureExtractor.ACE.DataTypes.FeatureDefinition;
import jAudioFeatureExtractor.AudioFeatures.ConstantQ;
import jAudioFeatureExtractor.AudioFeatures.FeatureExtractor;

public class ConstantQMFCC
extends FeatureExtractor {
    int numCepstra = 13;

    public ConstantQMFCC() {
        String name = "ConstantQ derived MFCCs";
        String description = "MFCCs directly caluclated from ConstantQ exponential bins";
        boolean is_sequential = true;
        int dimensions = 0;
        String[] attributes = new String[]{"Number of cepstra to return"};
        this.definition = new FeatureDefinition(name, description, is_sequential, dimensions, attributes);
        this.dependencies = new String[]{"Log of ConstantQ"};
        this.offsets = new int[1];
    }

    @Override
    public double[] extractFeature(double[] samples, double sampling_rate, double[][] other_feature_values) throws Exception {
        return this.cepCoefficients(other_feature_values[0]);
    }

    @Override
    public Object clone() {
        return new ConstantQ();
    }

    @Override
    public String getElement(int index) throws Exception {
        switch (index) {
            case 0: {
                return Integer.toString(this.numCepstra);
            }
        }
        throw new Exception("INTERNAL ERROR: invalid index " + index + " passed to LPC:getElement()");
    }

    @Override
    public void setElement(int index, String value) throws Exception {
        switch (index) {
            case 0: {
                try {
                    int val = Integer.parseInt(value);
                    if ((double)val <= 0.0) {
                        throw new Exception("Alpha must be a positive value");
                    }
                    this.numCepstra = val;
                    break;
                }
                catch (NumberFormatException e) {
                    throw new Exception("Lambda value must be a double");
                }
            }
            default: {
                throw new Exception("INTERNAL ERROR: invalid index passed to ConstantQ:setElement");
            }
        }
    }

    public double[] cepCoefficients(double[] f) {
        double[] cepc = new double[this.numCepstra];
        int i = 0;
        while (i < cepc.length) {
            int j = 1;
            while (j <= f.length) {
                int n = i;
                cepc[n] = cepc[n] + f[j - 1] * Math.cos(Math.PI * (double)i / (double)f.length * ((double)j - 0.5));
                ++j;
            }
            ++i;
        }
        return cepc;
    }
}

