/*
 * Decompiled with CFR 0.152.
 */
package jAudioFeatureExtractor.AudioFeatures;

import jAudioFeatureExtractor.ACE.DataTypes.FeatureDefinition;
import jAudioFeatureExtractor.AudioFeatures.FeatureExtractor;
import jAudioFeatureExtractor.jAudioTools.DSPMethods;

public class BeatHistogramLabels
extends FeatureExtractor {
    private int binNumber = 256;

    public BeatHistogramLabels() {
        String name = "Beat Histogram Bin Labels";
        String description = "The bin label, in beats per minute, of each beat histogram bin. Not useful as a feature in itself, but useful for calculating other features from the beat histogram.";
        boolean is_sequential = true;
        int dimensions = 0;
        this.definition = new FeatureDefinition(name, description, is_sequential, dimensions);
        this.dependencies = new String[1];
        this.dependencies[0] = "Beat Histogram";
        this.offsets = new int[1];
        this.offsets[0] = 0;
    }

    @Override
    public double[] extractFeature(double[] samples, double sampling_rate, double[][] other_feature_values) throws Exception {
        double[] beat_histogram = other_feature_values[0];
        if (beat_histogram != null) {
            double effective_sampling_rate = sampling_rate / (double)this.binNumber;
            int min_lag = (int)(0.286 * effective_sampling_rate);
            int max_lag = (int)(3.0 * effective_sampling_rate);
            double[] labels = DSPMethods.getAutoCorrelationLabels(effective_sampling_rate, min_lag, max_lag);
            int i = 0;
            while (i < labels.length) {
                int n = i++;
                labels[n] = labels[n] * 60.0;
            }
            return labels;
        }
        return null;
    }

    public void setBinNumber(int n) throws Exception {
        if (n < 2) {
            throw new Exception("There must be at least 2 bins in Beat Histogram Labels");
        }
        this.binNumber = n;
    }

    @Override
    public String getElement(int index) throws Exception {
        if (index != 0) {
            throw new Exception("INTERNAL ERROR: invalid index " + index + " sent to BeatHistogramLabels:getElement");
        }
        return Integer.toString(this.binNumber);
    }

    @Override
    public void setElement(int index, String value) throws Exception {
        if (index != 0) {
            throw new Exception("INTERNAL ERROR: invalid index " + index + " sent to BeatHistogramLabels:setElement");
        }
        try {
            int type = Integer.parseInt(value);
            this.setBinNumber(type);
        }
        catch (Exception e) {
            throw new Exception("Length of Area Method of Moments must be an integer");
        }
    }

    @Override
    public Object clone() {
        return new BeatHistogramLabels();
    }
}

