/*
 * Decompiled with CFR 0.152.
 */
package jAudioFeatureExtractor.Aggregators;

import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.DenseDoubleMatrix2D;
import cern.colt.matrix.linalg.Algebra;
import jAudioFeatureExtractor.ACE.DataTypes.AggregatorDefinition;
import jAudioFeatureExtractor.ACE.DataTypes.FeatureDefinition;
import jAudioFeatureExtractor.Aggregators.Aggregator;

public class AreaPolynomialApproximation
extends Aggregator {
    int xDim = 20;
    int yDim = 5;
    int windowLength = 1;
    int featureLength = 1;
    DenseDoubleMatrix2D terms;
    DenseDoubleMatrix2D z;
    String[] featureNames = null;
    int[] featureNameIndecis = null;

    public AreaPolynomialApproximation() {
        this.metadata = new AggregatorDefinition("2D Polynomial Approximation of a signal", "Calculates the coeefecients of a polynomial that approximates the signal", false, null);
    }

    @Override
    public void aggregate(double[][][] values) {
        this.result = null;
        int offset = super.calculateOffset(values, this.featureNameIndecis);
        int[][] featureIndecis = super.collapseFeatures(values, this.featureNameIndecis);
        this.result[0] = 0.0;
        this.windowLength = this.featureNameIndecis.length - offset;
        this.featureLength = featureIndecis[0].length;
        int i = offset;
        while (i < values.length) {
            int j = 0;
            while (j < featureIndecis.length) {
                this.result[0] = this.result[0] + values[i][featureIndecis[j][0]][featureIndecis[j][1]];
                ++j;
            }
            ++i;
        }
        this.terms = new DenseDoubleMatrix2D(this.xDim * this.yDim, this.windowLength * this.featureLength);
        this.z = new DenseDoubleMatrix2D(1, this.featureLength);
        this.calcTerms(this.terms);
        this.result = new Algebra().solve(this.terms, this.z).viewRow(0).toArray();
    }

    @Override
    public Object clone() {
        AreaPolynomialApproximation ret = new AreaPolynomialApproximation();
        if (this.featureNames != null) {
            ret.featureNames = (String[])this.featureNames.clone();
        }
        if (this.featureNameIndecis != null) {
            ret.featureNameIndecis = (int[])this.featureNameIndecis.clone();
        }
        return ret;
    }

    @Override
    public FeatureDefinition getFeatureDefinition() {
        return this.definition;
    }

    @Override
    public String[] getFeaturesToApply() {
        return this.featureNames;
    }

    @Override
    public void init(int[] featureIndecis) throws Exception {
        if (featureIndecis.length != this.featureNames.length) {
            throw new Exception("INTERNAL ERROR (Agggregator.AreaPolynomialApproximation): number of feature indeci does not match number of features");
        }
        this.featureNameIndecis = featureIndecis;
    }

    @Override
    public String[] getParamaters() {
        return new String[]{Integer.toString(this.xDim), Integer.toString(this.yDim)};
    }

    private void calcTerms(DoubleMatrix2D terms) {
        terms.assign(0.0);
        int x = 0;
        while (x < this.windowLength) {
            int y = 0;
            while (y < this.featureLength) {
                int i = 0;
                while (i < this.xDim) {
                    int j = 0;
                    while (j < this.yDim) {
                        terms.set(this.yDim * i + j, this.featureLength * x + y, Math.pow(x, i) * Math.pow(y, j));
                        ++j;
                    }
                    ++i;
                }
                ++y;
            }
            ++x;
        }
    }

    @Override
    public void setParameters(String[] featureNames, String[] params) throws Exception {
        if (params.length != 2) {
            this.xDim = 20;
            this.yDim = 5;
        } else {
            int val;
            try {
                val = Integer.parseInt(params[0]);
                if (val < 1) {
                    throw new Exception("Number of x terms in Area Polynomial Approximation must be positive");
                }
                this.xDim = val;
            }
            catch (Exception e) {
                throw new Exception("Number of x terms in Area Polynomial Approximation must be an integer");
            }
            try {
                val = Integer.parseInt(params[1]);
                if (val < 1) {
                    throw new Exception("Number of y terms in Area Polynomial Approximation must be positive");
                }
                this.yDim = val;
            }
            catch (Exception e) {
                throw new Exception("Number of y terms of Area Polynomial Approximation must be an integer");
            }
        }
        this.featureNames = featureNames;
        String names = featureNames[0];
        int i = 1;
        while (i < featureNames.length) {
            names = String.valueOf(names) + " " + featureNames[i];
            ++i;
        }
        this.definition = new FeatureDefinition("2D Polynomial Approximation: " + names, "2D moments constructed from features " + names + ".", true, 0);
    }
}

