/*
 * Decompiled with CFR 0.152.
 */
package jAudioFeatureExtractor.Aggregators;

import jAudioFeatureExtractor.ACE.DataTypes.FeatureDefinition;
import jAudioFeatureExtractor.Aggregators.Aggregator;
import jAudioFeatureExtractor.AudioFeatures.FeatureExtractor;
import java.io.DataOutputStream;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Vector;

public class AggregatorContainer {
    Vector<Aggregator> aggregatorTemplate = new Vector();
    Vector<Aggregator> aggregatorList = new Vector();
    Vector<FeatureExtractor> featureList = new Vector();
    Vector<Integer> featureIndecis2FeatureListMapping = new Vector();

    public int getNumberOfAggregators() {
        return this.aggregatorTemplate.size();
    }

    public void add(Aggregator[] aggs) throws Exception {
        int i = 0;
        while (i < aggs.length) {
            this.aggregatorTemplate.add(aggs[i]);
            ++i;
        }
        if (this.featureList.size() > 0) {
            this.buildAggregatorList();
        }
    }

    public void add(FeatureExtractor[] feature) throws Exception {
        boolean[] toggle = new boolean[feature.length];
        Arrays.fill(toggle, true);
        this.add(feature, toggle);
    }

    public void add(FeatureExtractor[] feature, boolean[] toggle) throws Exception {
        this.featureList.clear();
        int i = 0;
        while (i < feature.length) {
            if (toggle[i]) {
                this.featureList.add(feature[i]);
                this.featureIndecis2FeatureListMapping.add(i);
            }
            ++i;
        }
        if (this.aggregatorTemplate.size() > 0) {
            this.buildAggregatorList();
        }
    }

    public FeatureDefinition[] getFeatureDefinitions() {
        FeatureDefinition[] ret = new FeatureDefinition[this.aggregatorList.size()];
        int i = 0;
        while (i < this.aggregatorList.size()) {
            ret[i] = this.aggregatorList.get(i).getFeatureDefinition();
            ++i;
        }
        return ret;
    }

    public void aggregate(double[][][] values) throws Exception {
        int i = 0;
        while (i < this.aggregatorList.size()) {
            this.aggregatorList.get(i).aggregate(values);
            ++i;
        }
    }

    public void outputACEFeatureKeyEntries(DataOutputStream output) throws Exception {
        int i = 0;
        while (i < this.aggregatorList.size()) {
            this.aggregatorList.get(i).outputACEFeatureKeyEntries(output);
            ++i;
        }
    }

    public void outputACEValueEntries(DataOutputStream output) throws Exception {
        int i = 0;
        while (i < this.aggregatorList.size()) {
            this.aggregatorList.get(i).outputACEValueEntries(output);
            ++i;
        }
    }

    public void outputARFFHeaderEntries(DataOutputStream output) throws Exception {
        int i = 0;
        while (i < this.aggregatorList.size()) {
            this.aggregatorList.get(i).outputARFFHeaderEntries(output);
            ++i;
        }
        output.writeBytes("@DATA" + System.getProperty("line.separator"));
    }

    public void outputARFFValueEntries(DataOutputStream output) throws Exception {
        int i = 0;
        while (i < this.aggregatorList.size()) {
            this.aggregatorList.get(i).outputARFFValueEntries(output);
            if (i < this.aggregatorList.size() - 1) {
                output.writeBytes(",");
            }
            ++i;
        }
        output.writeBytes(Aggregator.LINE_SEP);
    }

    void buildAggregatorList() throws Exception {
        this.aggregatorList.clear();
        int i = 0;
        while (i < this.aggregatorTemplate.size()) {
            String[] list = this.aggregatorTemplate.get(i).getFeaturesToApply();
            if (list == null) {
                int j = 0;
                while (j < this.featureList.size()) {
                    Aggregator entry = (Aggregator)this.aggregatorTemplate.get(i).clone();
                    entry.setSource(this.featureList.get(j));
                    entry.init(new int[]{this.featureIndecis2FeatureListMapping.get(j)});
                    this.aggregatorList.add(entry);
                    ++j;
                }
            } else {
                boolean good = false;
                int[] indeci = new int[list.length];
                int j = 0;
                while (j < list.length) {
                    good = false;
                    int k = 0;
                    while (k < this.featureList.size()) {
                        if (this.featureList.get((int)k).getFeatureDefinition().name.equals(list[j])) {
                            good = true;
                            indeci[j] = this.featureIndecis2FeatureListMapping.get(k);
                            break;
                        }
                        ++k;
                    }
                    if (!good) break;
                    ++j;
                }
                if (good) {
                    this.aggregatorTemplate.get(i).init(indeci);
                    this.aggregatorList.add(this.aggregatorTemplate.get(i));
                }
            }
            ++i;
        }
    }

    public double[][] getResults() {
        LinkedList<double[]> ret = new LinkedList<double[]>();
        int i = 0;
        while (i < this.aggregatorList.size()) {
            ret.add(this.aggregatorList.get(i).getResults());
            ++i;
        }
        return (double[][])ret.toArray((T[])new double[0][]);
    }
}

