/*
 * Decompiled with CFR 0.152.
 */
package jAudioFeatureExtractor.ACE.XMLParsers;

import jAudioFeatureExtractor.ACE.XMLParsers.FeatureListHandler;
import jAudioFeatureExtractor.ACE.XMLParsers.ParseBatchJobHandler;
import jAudioFeatureExtractor.ACE.XMLParsers.ParseClassificationsFileHandler;
import jAudioFeatureExtractor.ACE.XMLParsers.ParseDataSetFileHandler;
import jAudioFeatureExtractor.ACE.XMLParsers.ParseFeatureDefinitionsFileHandler;
import jAudioFeatureExtractor.ACE.XMLParsers.ParseFileHandler;
import jAudioFeatureExtractor.ACE.XMLParsers.ParseSaveSettings;
import jAudioFeatureExtractor.ACE.XMLParsers.ParseTaxonomyFileHandler;
import java.io.File;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLDocumentParser {
    public static Object parseXMLDocument(String file_path, String document_type) throws Exception {
        ParseFileHandler handler;
        File test_file = new File(file_path);
        if (!test_file.exists()) {
            throw new Exception("The specified path " + file_path + " does not refer to an existing file.");
        }
        if (test_file.isDirectory()) {
            throw new Exception("The specified path " + file_path + " refers to a directory, not to a file.");
        }
        SAXParser reader = SAXParserFactory.newInstance().newSAXParser();
        if (document_type.equals("feature_vector_file")) {
            handler = new ParseDataSetFileHandler();
        } else if (document_type.equals("feature_key_file")) {
            handler = new ParseFeatureDefinitionsFileHandler();
        } else if (document_type.equals("taxonomy_file")) {
            handler = new ParseTaxonomyFileHandler();
        } else if (document_type.equals("classifications_file")) {
            handler = new ParseClassificationsFileHandler();
        } else if (document_type.equals("save_settings")) {
            handler = new ParseSaveSettings();
        } else if (document_type.equals("batchFile")) {
            handler = new ParseBatchJobHandler();
        } else if (document_type.equals("feature_list")) {
            handler = new FeatureListHandler();
        } else {
            throw new Exception(new String("Invalid type of XML file specified. The XML file type " + document_type + " is not known."));
        }
        try {
            reader.parse(file_path, (DefaultHandler)handler);
        }
        catch (SAXParseException e) {
            throw new Exception("The " + file_path + " file is not a valid XML file.\n\nDetails of the problem: " + e.getMessage() + "\n\nThis error is likely in the region of line " + e.getLineNumber() + ".");
        }
        catch (SAXException e) {
            throw new Exception("The " + file_path + " file must be of type " + document_type + ". " + e.getMessage());
        }
        catch (Exception e) {
            throw new Exception("The " + file_path + " file is not formatted properly.\n\nDetails of the problem: " + e.getMessage());
        }
        return handler.parsed_file_contents;
    }
}

