/*
 * Decompiled with CFR 0.152.
 */
package jAudioFeatureExtractor.ACE.DataTypes;

import jAudioFeatureExtractor.ACE.DataTypes.DataSet;
import jAudioFeatureExtractor.ACE.XMLParsers.XMLDocumentParser;
import jAudioFeatureExtractor.GeneralTools.Statistics;
import jAudioFeatureExtractor.GeneralTools.StringMethods;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.Serializable;
import java.util.LinkedList;

public class SegmentedClassification
implements Serializable {
    public String identifier = null;
    public String[] classifications = null;
    public String[] misc_info_info = null;
    public String[] misc_info_key = null;
    public String role = null;
    public SegmentedClassification[] sub_classifications = null;
    public double start = Double.NaN;
    public double stop = Double.NaN;
    private static final long serialVersionUID = 4L;

    public String getClassificationDescription(int depth) {
        String indent = new String("");
        int i = 0;
        while (i < depth) {
            indent = String.valueOf(indent) + "   ";
            ++i;
        }
        String id_string = new String("");
        if (this.identifier != null) {
            id_string = "DATASET " + this.identifier + ": ";
            id_string = this.sub_classifications != null ? String.valueOf(id_string) + this.sub_classifications.length + " sub-sections " : String.valueOf(id_string) + "0 sub-sections ";
            id_string = this.classifications != null ? String.valueOf(id_string) + this.classifications.length + " overall classes\n" : String.valueOf(id_string) + "0 overall classes\n";
            if (this.misc_info_info != null) {
                int i2 = 0;
                while (i2 < this.misc_info_info.length) {
                    id_string = String.valueOf(id_string) + this.misc_info_key[i2] + ": " + this.misc_info_info[i2] + "\n";
                    ++i2;
                }
            }
            if (this.role != null) {
                id_string = String.valueOf(id_string) + "Role: " + this.role + "\n";
            }
            id_string = String.valueOf(id_string) + "\n";
        } else {
            id_string = String.valueOf(id_string) + indent + "START: " + this.start + "     STOP: " + this.stop + "\n\n";
        }
        String classifications_string = new String("");
        if (this.classifications != null) {
            int i3 = 0;
            while (i3 < this.classifications.length) {
                classifications_string = String.valueOf(classifications_string) + indent + indent + "Class: " + this.classifications[i3] + "\n";
                ++i3;
            }
            classifications_string = String.valueOf(classifications_string) + "\n";
        }
        String sub_section_string = new String("");
        if (this.sub_classifications != null) {
            int set = 0;
            while (set < this.sub_classifications.length) {
                sub_section_string = String.valueOf(sub_section_string) + this.sub_classifications[set].getClassificationDescription(depth + 1);
                ++set;
            }
        }
        return String.valueOf(id_string) + classifications_string + sub_section_string;
    }

    public static String getClassificationDescriptions(SegmentedClassification[] seg_classes) {
        String combined_classificationss = new String();
        int i = 0;
        while (i < seg_classes.length) {
            combined_classificationss = String.valueOf(combined_classificationss) + seg_classes[i].getClassificationDescription(0);
            ++i;
        }
        return combined_classificationss;
    }

    public static int getNumberOverallInstancesBelongingToClass(SegmentedClassification[] model_classifications, String class_of_interest) {
        int count = 0;
        int inst = 0;
        while (inst < model_classifications.length) {
            String[] classes = model_classifications[inst].classifications;
            if (classes != null) {
                int clas = 0;
                while (clas < classes.length) {
                    if (classes[clas].equals(class_of_interest)) {
                        clas = classes.length;
                        ++count;
                    }
                    ++clas;
                }
            }
            ++inst;
        }
        return count;
    }

    public static int getNumberSectionsInInstancesBelongingToClass(SegmentedClassification[] model_classifications, String class_of_interest) {
        int count = 0;
        int inst = 0;
        while (inst < model_classifications.length) {
            SegmentedClassification[] sub_sections = model_classifications[inst].sub_classifications;
            if (sub_sections != null) {
                count += SegmentedClassification.getNumberOverallInstancesBelongingToClass(sub_sections, class_of_interest);
            }
            ++inst;
        }
        return count;
    }

    public static String[] getLeafClasses(SegmentedClassification[] seg_classes) {
        LinkedList<String> classes_including_doubles = new LinkedList<String>();
        int set = 0;
        while (set < seg_classes.length) {
            if (seg_classes[set].classifications != null) {
                int cla = 0;
                while (cla < seg_classes[set].classifications.length) {
                    classes_including_doubles.add(seg_classes[set].classifications[cla]);
                    ++cla;
                }
            }
            if (seg_classes[set].sub_classifications != null) {
                int sub = 0;
                while (sub < seg_classes[set].sub_classifications.length) {
                    int cla = 0;
                    while (cla < seg_classes[set].sub_classifications[sub].classifications.length) {
                        classes_including_doubles.add(seg_classes[set].sub_classifications[sub].classifications[cla]);
                        ++cla;
                    }
                    ++sub;
                }
            }
            ++set;
        }
        Object[] obj = classes_including_doubles.toArray();
        String[] unshortened = new String[obj.length];
        int i = 0;
        while (i < unshortened.length) {
            unshortened[i] = (String)obj[i];
            ++i;
        }
        String[] shortened = StringMethods.removeDoubles(unshortened);
        return shortened;
    }

    public static boolean verifyUniquenessOfIdentifiers(SegmentedClassification[] seg_classes) {
        boolean unique = true;
        int i = 0;
        while (i < seg_classes.length - 1) {
            int j = i + 1;
            while (j < seg_classes.length) {
                if (seg_classes[i].identifier.equals(seg_classes[j].identifier)) {
                    unique = false;
                    i = seg_classes.length;
                    j = seg_classes.length;
                }
                ++j;
            }
            ++i;
        }
        return unique;
    }

    public static String[][] getOverallLabelsOfDataSets(DataSet[] data_sets, SegmentedClassification[] set_classifications) throws Exception {
        if (!SegmentedClassification.verifyUniquenessOfIdentifiers(set_classifications)) {
            throw new Exception("Given classifications contain multiple references\nto instances with the same identifier.");
        }
        String[][] data_set_overall_labels = new String[data_sets.length][];
        int set = 0;
        while (set < data_sets.length) {
            data_set_overall_labels[set] = null;
            int clas = 0;
            while (clas < set_classifications.length) {
                if (data_sets[set].identifier.equals(set_classifications[clas].identifier)) {
                    data_set_overall_labels[set] = set_classifications[clas].classifications;
                    clas = set_classifications.length;
                }
                ++clas;
            }
            ++set;
        }
        return data_set_overall_labels;
    }

    public static String[][][] getSubSectionLabelsOfDataSets(DataSet[] data_sets, SegmentedClassification[] set_classifications) throws Exception {
        if (!SegmentedClassification.verifyUniquenessOfIdentifiers(set_classifications)) {
            throw new Exception("Given classifications contain multiple references\nto instances with the same identifier.");
        }
        String[][][] labels = new String[data_sets.length][][];
        int set = 0;
        while (set < data_sets.length) {
            labels[set] = null;
            int clas = 0;
            while (clas < set_classifications.length) {
                if (data_sets[set].identifier.equals(set_classifications[clas].identifier)) {
                    DataSet[] data_sub_set = data_sets[set].sub_sets;
                    SegmentedClassification[] classification_sections = set_classifications[clas].sub_classifications;
                    if (data_sub_set != null && classification_sections != null) {
                        labels[set] = new String[data_sub_set.length][];
                        double[] data_low_bound = new double[data_sub_set.length];
                        double[] data_high_bound = new double[data_sub_set.length];
                        int sub = 0;
                        while (sub < data_sub_set.length) {
                            data_low_bound[sub] = data_sub_set[sub].start;
                            data_high_bound[sub] = data_sub_set[sub].stop;
                            ++sub;
                        }
                        double[] classifications_low_bound = new double[classification_sections.length];
                        double[] classifications_high_bound = new double[classification_sections.length];
                        int cl_sub = 0;
                        while (cl_sub < classification_sections.length) {
                            classifications_low_bound[cl_sub] = classification_sections[cl_sub].start;
                            classifications_high_bound[cl_sub] = classification_sections[cl_sub].stop;
                            ++cl_sub;
                        }
                        int sub2 = 0;
                        while (sub2 < data_sub_set.length) {
                            labels[set][sub2] = null;
                            double[] fraction_in = new double[classification_sections.length];
                            double data_set_length = data_high_bound[sub2] - data_low_bound[sub2];
                            int cl_sub2 = 0;
                            while (cl_sub2 < classification_sections.length) {
                                fraction_in[cl_sub2] = data_high_bound[sub2] < classifications_low_bound[cl_sub2] || data_low_bound[sub2] > classifications_high_bound[cl_sub2] ? 0.0 : (data_low_bound[sub2] >= classifications_low_bound[cl_sub2] && data_high_bound[sub2] <= classifications_high_bound[cl_sub2] ? 1.0 : (data_low_bound[sub2] <= classifications_low_bound[cl_sub2] && data_high_bound[sub2] >= classifications_high_bound[cl_sub2] ? (classifications_high_bound[cl_sub2] - classifications_low_bound[cl_sub2]) / data_set_length : (data_low_bound[sub2] <= classifications_low_bound[cl_sub2] && data_high_bound[sub2] >= classifications_low_bound[cl_sub2] && data_high_bound[sub2] <= classifications_high_bound[cl_sub2] ? (data_high_bound[sub2] - classifications_low_bound[cl_sub2]) / data_set_length : (data_low_bound[sub2] >= classifications_low_bound[cl_sub2] && data_high_bound[sub2] >= classifications_high_bound[cl_sub2] && data_low_bound[sub2] <= classifications_high_bound[cl_sub2] ? (classifications_high_bound[cl_sub2] - data_low_bound[sub2]) / data_set_length : 0.0))));
                                ++cl_sub2;
                            }
                            int best_cl_sub = Statistics.getIndexOfLargest(fraction_in);
                            labels[set][sub2] = classification_sections[best_cl_sub].classifications;
                            ++sub2;
                        }
                    }
                }
                ++clas;
            }
            ++set;
        }
        return labels;
    }

    public static String getSuccessRate(SegmentedClassification[] models, SegmentedClassification[] results) {
        double correct_count = 0.0;
        int total_count = 0;
        int number_false_positives = 0;
        int r = 0;
        while (r < results.length) {
            int m = 0;
            while (m < models.length) {
                if (models[m].identifier.equals(results[r].identifier)) {
                    String[] model_clas = models[m].classifications;
                    String[] result_clas = results[r].classifications;
                    if (model_clas != null && result_clas != null) {
                        double correct_number_classes = model_clas.length;
                        double found_number_classes = 0.0;
                        int r_clas = 0;
                        while (r_clas < result_clas.length) {
                            boolean found = false;
                            int m_clas = 0;
                            while (m_clas < model_clas.length) {
                                if (model_clas[m_clas].equals(result_clas[r_clas])) {
                                    found = true;
                                    found_number_classes += 1.0;
                                    m_clas = model_clas.length;
                                }
                                ++m_clas;
                            }
                            if (!found) {
                                ++number_false_positives;
                            }
                            ++r_clas;
                        }
                        double this_score = found_number_classes / correct_number_classes;
                        correct_count += this_score;
                        ++total_count;
                        m = models.length;
                    }
                }
                ++m;
            }
            ++r;
        }
        String overall_results = "";
        if (total_count != 0) {
            double success_rate = 100.0 * correct_count / (double)total_count;
            overall_results = "SUCCESS RATES FOR OVERALL CLASSIFICATIONS:\n" + success_rate + "%: " + correct_count + " / " + total_count + "\n" + number_false_positives + " false positives.\n\n";
        }
        correct_count = 0.0;
        total_count = 0;
        number_false_positives = 0;
        int r2 = 0;
        while (r2 < results.length) {
            int m = 0;
            while (m < models.length) {
                if (models[m].identifier.equals(results[r2].identifier)) {
                    SegmentedClassification[] mod_sec = models[m].sub_classifications;
                    SegmentedClassification[] res_sec = results[r2].sub_classifications;
                    if (mod_sec != null && res_sec != null) {
                        double[] mod_low_bound = new double[mod_sec.length];
                        double[] mod_high_bound = new double[mod_sec.length];
                        int i = 0;
                        while (i < mod_sec.length) {
                            mod_low_bound[i] = mod_sec[i].start;
                            mod_high_bound[i] = mod_sec[i].stop;
                            ++i;
                        }
                        double[] res_low_bound = new double[res_sec.length];
                        double[] res_high_bound = new double[res_sec.length];
                        int i2 = 0;
                        while (i2 < res_sec.length) {
                            res_low_bound[i2] = res_sec[i2].start;
                            res_high_bound[i2] = res_sec[i2].stop;
                            ++i2;
                        }
                        String[][] model_labels_of_results = new String[res_sec.length][];
                        int r_sec = 0;
                        while (r_sec < res_sec.length) {
                            model_labels_of_results[r_sec] = null;
                            double[] fraction_in = new double[mod_sec.length];
                            double result_length = res_high_bound[r_sec] - res_low_bound[r_sec];
                            int m_sec = 0;
                            while (m_sec < mod_sec.length) {
                                fraction_in[m_sec] = res_high_bound[r_sec] < mod_low_bound[m_sec] || res_low_bound[r_sec] > mod_high_bound[m_sec] ? 0.0 : (res_low_bound[r_sec] >= mod_low_bound[m_sec] && res_high_bound[r_sec] <= mod_high_bound[m_sec] ? 1.0 : (res_low_bound[r_sec] <= mod_low_bound[m_sec] && res_high_bound[r_sec] >= mod_high_bound[m_sec] ? (mod_high_bound[m_sec] - mod_low_bound[m_sec]) / result_length : (res_low_bound[r_sec] <= mod_low_bound[m_sec] && res_high_bound[r_sec] <= mod_high_bound[m_sec] && res_high_bound[r_sec] >= mod_low_bound[m_sec] ? (res_high_bound[r_sec] - mod_low_bound[m_sec]) / result_length : (res_low_bound[r_sec] >= mod_low_bound[m_sec] && res_high_bound[r_sec] >= mod_high_bound[m_sec] && res_low_bound[r_sec] <= mod_high_bound[m_sec] ? (mod_high_bound[m_sec] - res_low_bound[r_sec]) / result_length : 0.0))));
                                ++m_sec;
                            }
                            int best_m_sec = Statistics.getIndexOfLargest(fraction_in);
                            model_labels_of_results[r_sec] = mod_sec[best_m_sec].classifications;
                            ++r_sec;
                        }
                        r_sec = 0;
                        while (r_sec < res_sec.length) {
                            String[] result_clas = res_sec[r_sec].classifications;
                            String[] model_clas = model_labels_of_results[r_sec];
                            double correct_number_classes = model_clas.length;
                            double found_number_classes = 0.0;
                            int r_clas = 0;
                            while (r_clas < result_clas.length) {
                                boolean found = false;
                                int m_clas = 0;
                                while (m_clas < model_clas.length) {
                                    if (model_clas[m_clas].equals(result_clas[r_clas])) {
                                        found = true;
                                        found_number_classes += 1.0;
                                        m_clas = model_clas.length;
                                    }
                                    ++m_clas;
                                }
                                if (!found) {
                                    ++number_false_positives;
                                }
                                ++r_clas;
                            }
                            double this_score = found_number_classes / correct_number_classes;
                            correct_count += this_score;
                            ++total_count;
                            m = models.length;
                            ++r_sec;
                        }
                    }
                }
                ++m;
            }
            ++r2;
        }
        String section_results = "";
        if (total_count != 0) {
            double success_rate = 100.0 * correct_count / (double)total_count;
            section_results = "SUCCESS RATES FOR CLASSIFICATION OF SECTIONS:\n" + success_rate + "%: " + correct_count + " / " + total_count + "\n" + number_false_positives + " false positives.\n\n";
        }
        return "\n\n" + overall_results + section_results;
    }

    public static SegmentedClassification[] parseClassificationsFile(String data_set_file_path) throws Exception {
        Object[] results = (Object[])XMLDocumentParser.parseXMLDocument(data_set_file_path, "classifications_file");
        SegmentedClassification[] parse_results = new SegmentedClassification[results.length];
        int i = 0;
        while (i < parse_results.length) {
            parse_results[i] = (SegmentedClassification)results[i];
            ++i;
        }
        return parse_results;
    }

    public static void saveClassifications(SegmentedClassification[] seg_classifications, File to_save_to, String comments) throws Exception {
        try {
            FileOutputStream to = new FileOutputStream(to_save_to);
            DataOutputStream writer = new DataOutputStream(to);
            String pre_tree_part = new String("<?xml version=\"1.0\"?>\n<!DOCTYPE classifications_file [\n   <!ELEMENT classifications_file (comments, data_set+)>\n   <!ELEMENT comments (#PCDATA)>\n   <!ELEMENT data_set (data_set_id, misc_info*, role?, classification)>\n   <!ELEMENT data_set_id (#PCDATA)>\n   <!ELEMENT misc_info (#PCDATA)>\n   <!ATTLIST misc_info info_type CDATA \"\">\n   <!ELEMENT role (#PCDATA)>\n   <!ELEMENT classification (section*, class*)>\n   <!ELEMENT section (start, stop, class+)>\n   <!ELEMENT class (#PCDATA)>\n   <!ELEMENT start (#PCDATA)>\n   <!ELEMENT stop (#PCDATA)>\n]>\n\n<classifications_file>\n\n   <comments>" + comments + "</comments>\n\n");
            writer.writeBytes(pre_tree_part);
            int set = 0;
            while (set < seg_classifications.length) {
                writer.writeBytes("   <data_set>\n");
                writer.writeBytes("      <data_set_id>" + seg_classifications[set].identifier + "</data_set_id>\n");
                if (seg_classifications[set].misc_info_key != null) {
                    int met = 0;
                    while (met < seg_classifications[set].misc_info_key.length) {
                        writer.writeBytes("      <misc_info info_type=\"" + seg_classifications[set].misc_info_key[met] + "\">" + seg_classifications[set].misc_info_info[met] + "</misc_info>\n");
                        ++met;
                    }
                }
                if (seg_classifications[set].role != null) {
                    writer.writeBytes("      <role>" + seg_classifications[set].role + "</role>\n");
                }
                writer.writeBytes("      <classification>\n");
                if (seg_classifications[set].sub_classifications != null) {
                    SegmentedClassification[] sub_secs = seg_classifications[set].sub_classifications;
                    int sub = 0;
                    while (sub < sub_secs.length) {
                        writer.writeBytes("         <section>\n");
                        writer.writeBytes("            <start>" + sub_secs[sub].start + "</start>\n");
                        writer.writeBytes("            <stop>" + sub_secs[sub].stop + "</stop>\n");
                        int cla = 0;
                        while (cla < sub_secs[sub].classifications.length) {
                            writer.writeBytes("            <class>" + sub_secs[sub].classifications[cla] + "</class>\n");
                            ++cla;
                        }
                        writer.writeBytes("         </section>\n");
                        ++sub;
                    }
                }
                if (seg_classifications[set].classifications != null) {
                    int cla = 0;
                    while (cla < seg_classifications[set].classifications.length) {
                        writer.writeBytes("         <class>" + seg_classifications[set].classifications[cla] + "</class>\n");
                        ++cla;
                    }
                }
                writer.writeBytes("      </classification>\n");
                writer.writeBytes("   </data_set>\n\n");
                ++set;
            }
            writer.writeBytes("</classifications_file>");
            writer.close();
        }
        catch (Exception e) {
            throw new Exception("Unable to write file " + to_save_to.getName() + ".");
        }
    }
}

