/*
 * Decompiled with CFR 0.152.
 */
package jAudioFeatureExtractor.ACE.DataTypes;

import jAudioFeatureExtractor.ACE.XMLParsers.XMLDocumentParser;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.Serializable;
import java.util.Vector;

public class FeatureDefinition
implements Serializable {
    public String name;
    public String description;
    public boolean is_sequential;
    public int dimensions;
    private static final long serialVersionUID = 2L;
    public String[] attributes;

    public FeatureDefinition() {
        this.name = "Undefined Feature";
        this.description = new String("");
        this.is_sequential = false;
        this.dimensions = 1;
        this.attributes = new String[0];
    }

    public FeatureDefinition(String name, String description, boolean is_sequential, int dimensions) {
        this.name = name;
        this.description = description;
        this.is_sequential = is_sequential;
        this.dimensions = dimensions;
        this.attributes = new String[0];
    }

    public FeatureDefinition(String name, String description, boolean is_sequential, int dimensions, String[] attributes) {
        this.name = name;
        this.description = description;
        this.is_sequential = true;
        this.dimensions = dimensions;
        this.attributes = attributes;
    }

    public String getFeatureDescription() {
        String info = "NAME: " + this.name + "\n";
        info = String.valueOf(info) + "DESCRIPTION: " + this.description + "\n";
        info = String.valueOf(info) + "IS SEQUENTIAL: " + this.is_sequential + "\n";
        info = String.valueOf(info) + "DIMENSIONS: " + this.dimensions + "\n\n";
        return info;
    }

    public static String getFeatureDescriptions(FeatureDefinition[] definitions) {
        String combined_descriptions = new String();
        int i = 0;
        while (i < definitions.length) {
            combined_descriptions = String.valueOf(combined_descriptions) + definitions[i].getFeatureDescription();
            ++i;
        }
        return combined_descriptions;
    }

    public static FeatureDefinition[] parseFeatureDefinitionsFile(String feature_key_file_path) throws Exception {
        Object[] results = (Object[])XMLDocumentParser.parseXMLDocument(feature_key_file_path, "feature_key_file");
        FeatureDefinition[] parse_results = new FeatureDefinition[results.length];
        int i = 0;
        while (i < parse_results.length) {
            parse_results[i] = (FeatureDefinition)results[i];
            ++i;
        }
        String duplicates = FeatureDefinition.verifyFeatureNameUniqueness(parse_results);
        if (duplicates != null) {
            throw new Exception("Could not parse because there are multiple\noccurences of the following feature names:\n" + duplicates);
        }
        return parse_results;
    }

    public static void saveFeatureDefinitions(FeatureDefinition[] definitions, File to_save_to, String comments) throws Exception {
        String duplicates = FeatureDefinition.verifyFeatureNameUniqueness(definitions);
        if (duplicates != null) {
            throw new Exception("Could not save because there are multiple\noccurences of the following feature names:\n" + duplicates);
        }
        try {
            FileOutputStream to = new FileOutputStream(to_save_to);
            DataOutputStream writer = new DataOutputStream(to);
            String pre_tree_part = new String("<?xml version=\"1.0\"?>\n<!DOCTYPE feature_key_file [\n   <!ELEMENT feature_key_file (comments, feature+)>\n   <!ELEMENT comments (#PCDATA)>\n   <!ELEMENT feature (name, description?, is_sequential, parallel_dimensions)>\n   <!ELEMENT name (#PCDATA)>\n   <!ELEMENT description (#PCDATA)>\n   <!ELEMENT is_sequential (#PCDATA)>\n   <!ELEMENT parallel_dimensions (#PCDATA)>\n]>\n\n<feature_key_file>\n\n   <comments>" + comments + "</comments>\n\n");
            writer.writeBytes(pre_tree_part);
            int feat = 0;
            while (feat < definitions.length) {
                writer.writeBytes("   <feature>\n");
                writer.writeBytes("      <name>" + definitions[feat].name + "</name>\n");
                if (!definitions[feat].description.equals("")) {
                    writer.writeBytes("      <description>" + definitions[feat].description + "</description>\n");
                }
                writer.writeBytes("      <is_sequential>" + definitions[feat].is_sequential + "</is_sequential>\n");
                writer.writeBytes("      <parallel_dimensions>" + definitions[feat].dimensions + "</parallel_dimensions>\n");
                writer.writeBytes("   </feature>\n\n");
                ++feat;
            }
            writer.writeBytes("</feature_key_file>");
            writer.close();
        }
        catch (Exception e) {
            throw new Exception("Unable to write file " + to_save_to.getName() + ".");
        }
    }

    public static String verifyFeatureNameUniqueness(FeatureDefinition[] definitions) {
        boolean found_duplicate = false;
        Vector<String> duplicates = new Vector<String>();
        int i = 0;
        while (i < definitions.length - 1) {
            int j = i + 1;
            while (j < definitions.length) {
                if (definitions[i].name.equals(definitions[j].name)) {
                    found_duplicate = true;
                    duplicates.add(definitions[i].name);
                    j = definitions.length;
                }
                ++j;
            }
            ++i;
        }
        if (found_duplicate) {
            Object[] duplicated_names_obj = duplicates.toArray();
            String[] duplicated_names = new String[duplicated_names_obj.length];
            int i2 = 0;
            while (i2 < duplicated_names.length) {
                duplicated_names[i2] = (String)duplicated_names_obj[i2];
                ++i2;
            }
            String duplicates_formatted = new String();
            int i3 = 0;
            while (i3 < duplicated_names.length) {
                duplicates_formatted = String.valueOf(duplicates_formatted) + duplicated_names[i3];
                if (i3 < duplicated_names.length - 1) {
                    duplicates_formatted = String.valueOf(duplicates_formatted) + ", ";
                }
                ++i3;
            }
            return duplicates_formatted;
        }
        return null;
    }
}

