/*
 * Decompiled with CFR 0.152.
 */
package jAudioFeatureExtractor.ACE.DataTypes;

import jAudioFeatureExtractor.ACE.DataTypes.FeatureDefinition;
import jAudioFeatureExtractor.Aggregators.Aggregator;
import jAudioFeatureExtractor.DataModel;
import jAudioFeatureExtractor.DataTypes.RecordingInfo;
import java.io.File;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class Batch
implements Serializable {
    static final long serialVersionUID = 1L;
    String name;
    RecordingInfo[] recording = new RecordingInfo[0];
    int windowSize;
    double windowOverlap;
    double samplingRate;
    boolean normalise;
    boolean perWindow;
    boolean overall;
    String destinationFK = null;
    String destinationFV = null;
    int outputType;
    transient DataModel dm_;
    HashMap<String, Boolean> activated;
    HashMap<String, String[]> attributes;
    String[] aggregatorNames;
    String[][] aggregatorFeatures;
    String[][] aggregatorParameters;

    public void setDataModel(DataModel dm) {
        this.dm_ = dm;
    }

    public void execute() throws Exception {
        this.applyAttributes();
        this.dm_.extract(this.windowSize, this.windowOverlap, this.samplingRate, this.normalise, this.perWindow, this.overall, this.recording, this.outputType);
    }

    public void setRecordings(File[] files) throws Exception {
        this.recording = new RecordingInfo[files.length];
        int i = 0;
        while (i < files.length) {
            if (files[i].exists()) {
                try {
                    this.recording[i] = new RecordingInfo(files[i].getName(), files[i].getPath(), null, false);
                }
                catch (Exception e) {
                    this.recording = null;
                    throw e;
                }
            } else {
                this.recording = null;
                throw new Exception("The selected file " + files[i].getName() + " does not exist.");
            }
            ++i;
        }
    }

    public void setSettings(int windowSize, double windowOverlap, double samplingRate, boolean normalise, boolean perWindow, boolean overall, int outputType) {
        this.windowSize = windowSize;
        this.windowOverlap = windowOverlap;
        this.samplingRate = samplingRate;
        this.normalise = normalise;
        this.perWindow = perWindow;
        this.overall = overall;
        this.outputType = outputType;
    }

    public void setDestination(String FK, String FV) {
        this.destinationFK = FK;
        this.destinationFV = FV;
    }

    public void setFeatures(HashMap<String, Boolean> activated, HashMap<String, String[]> attributes) {
        this.activated = activated;
        this.attributes = attributes;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    private void applyAttributes() throws Exception {
        String[] tmp;
        int i = 0;
        while (i < this.dm_.features.length) {
            String name = this.dm_.features[i].getFeatureDefinition().name;
            if (this.attributes.containsKey(name)) {
                this.dm_.defaults[i] = this.activated.get(name);
                tmp = this.attributes.get(name);
                int j = 0;
                while (j < tmp.length) {
                    this.dm_.features[i].setElement(j, tmp[j]);
                    ++j;
                }
            } else {
                this.dm_.defaults[i] = false;
            }
            ++i;
        }
        LinkedList<String[]> aggregatorList = new LinkedList<String[]>();
        int i2 = 0;
        while (i2 < this.aggregatorNames.length) {
            tmp = (String[])this.dm_.aggregatorMap.get(this.aggregatorNames[i2]).clone();
            tmp.setParameters(this.aggregatorFeatures[i2], this.aggregatorParameters[i2]);
            aggregatorList.add(tmp);
            ++i2;
        }
        if (this.overall && aggregatorList.size() == 0) {
            throw new Exception("Attempting to get overall stats without specifying any aggregators to create it");
        }
        this.dm_.aggregators = aggregatorList.toArray(new Aggregator[0]);
    }

    public Aggregator[] getAggregator() throws Exception {
        LinkedList<Aggregator> aggregatorList = new LinkedList<Aggregator>();
        if (this.aggregatorNames != null) {
            int i = 0;
            while (i < this.aggregatorNames.length) {
                Aggregator tmp = (Aggregator)this.dm_.aggregatorMap.get(this.aggregatorNames[i]).clone();
                tmp.setParameters(this.aggregatorFeatures[i], this.aggregatorParameters[i]);
                aggregatorList.add(tmp);
                ++i;
            }
        }
        if (this.overall && aggregatorList.size() == 0) {
            throw new Exception("Attempting to get overall stats without specifying any aggregators to create it");
        }
        return aggregatorList.toArray(new Aggregator[0]);
    }

    public String outputXML() {
        StringBuffer ret = new StringBuffer();
        String sep = System.getProperty("line.separator");
        ret.append("\t<batch ID=\"").append(this.name).append("\">").append(sep);
        ret.append("\t\t<fileSet>").append(sep);
        int i = 0;
        while (i < this.recording.length) {
            ret.append("\t\t\t<file>").append(this.recording[i].file_path).append("</file>").append(sep);
            ++i;
        }
        ret.append("\t\t</fileSet>").append(sep);
        ret.append("\t\t<settings>").append(sep);
        ret.append("\t\t\t<windowSize>").append(this.windowSize).append("</windowSize>").append(sep);
        ret.append("\t\t\t<windowOverlap>").append(this.windowOverlap).append("</windowOverlap>").append(sep);
        ret.append("\t\t\t<samplingRate>").append(this.samplingRate).append("</samplingRate>").append(sep);
        ret.append("\t\t\t<normalise>").append(this.normalise).append("</normalise>").append(sep);
        ret.append("\t\t\t<perWindowStats>").append(this.perWindow).append("</perWindowStats>").append(sep);
        ret.append("\t\t\t<overallStats>").append(this.overall).append("</overallStats>").append(sep);
        if (this.outputType == 0) {
            ret.append("\t\t\t<outputType>ACE</outputType>").append(sep);
        } else {
            ret.append("\t\t\t<outputType>ARFF</outputType>").append(sep);
        }
        Set<Map.Entry<String, String[]>> s = this.attributes.entrySet();
        for (Map.Entry<String, String[]> i2 : s) {
            String name = i2.getKey();
            String[] att = i2.getValue();
            ret.append("\t\t\t<feature>").append(sep);
            ret.append("\t\t\t\t<name>").append(name).append("</name>").append(sep);
            ret.append("\t\t\t\t<active>").append(this.activated.get(name)).append("</active>").append(sep);
            int j = 0;
            while (j < att.length) {
                ret.append("\t\t\t\t<attribute>").append(att[j]).append("</attribute>").append(sep);
                ++j;
            }
            ret.append("\t\t\t</feature>").append(sep);
        }
        int i3 = 0;
        while (i3 < this.aggregatorNames.length) {
            ret.append("\t\t\t<aggregator>").append(sep);
            ret.append("\t\t\t\t<aggregatorName>").append(this.aggregatorNames[i3]).append("</aggregatorName>").append(sep);
            if (this.aggregatorFeatures[i3] != null) {
                int j = 0;
                while (j < this.aggregatorFeatures[i3].length) {
                    ret.append("\t\t\t\t<aggregatorFeature>").append(this.aggregatorFeatures[i3][j]).append("</aggregatorFeature>").append(sep);
                    ++j;
                }
            }
            if (this.aggregatorParameters[i3] != null) {
                int j = 0;
                while (j < this.aggregatorParameters[i3].length) {
                    ret.append("\t\t\t\t<aggregatorAttribute>").append(this.aggregatorParameters[i3][j]).append("</aggregatorAttribute>").append(sep);
                    ++j;
                }
            }
            ret.append("\t\t\t</aggregator>").append(sep);
            ++i3;
        }
        ret.append("\t\t</settings>").append(sep);
        ret.append("\t\t<destination>").append(this.destinationFK).append("</destination>").append(sep);
        ret.append("\t\t<destination>").append(this.destinationFV).append("</destination>").append(sep);
        ret.append("\t</batch>").append(sep);
        return ret.toString();
    }

    public void applySettings(RecordingInfo[][] recording, int[] windowSize, double[] windowOverlap, double[] samplingRate, boolean[] normalise, boolean[] perWindow, boolean[] overall, String[] destinationFK, String[] destinationFV, int[] outputType) {
        try {
            this.applyAttributes();
            this.dm_.featureDefinitions = new FeatureDefinition[this.dm_.features.length];
            int i = 0;
            while (i < this.dm_.featureDefinitions.length) {
                this.dm_.featureDefinitions[i] = this.dm_.features[i].getFeatureDefinition();
                ++i;
            }
            this.dm_.recordingInfo = this.recording;
        }
        catch (Exception e) {
            System.err.println("INTERNAL ERROR: " + e.getMessage());
            e.printStackTrace();
        }
        recording[0] = this.recording;
        windowSize[0] = this.windowSize;
        windowOverlap[0] = this.windowOverlap;
        samplingRate[0] = this.samplingRate;
        normalise[0] = this.normalise;
        perWindow[0] = this.perWindow;
        overall[0] = this.overall;
        destinationFK[0] = this.destinationFK;
        destinationFV[0] = this.destinationFV;
        outputType[0] = this.outputType;
    }

    public HashMap<String, String[]> getAttributes() {
        return this.attributes;
    }

    public HashMap<String, Boolean> getActivated() {
        return this.activated;
    }

    public void setAttributes(HashMap<String, String[]> attributes) {
        this.attributes = attributes;
    }

    public String getDestinationFK() {
        return this.destinationFK;
    }

    public void setDestinationFK(String destinationFK) {
        this.destinationFK = destinationFK;
    }

    public String getDestinationFV() {
        return this.destinationFV;
    }

    public void setDestinationFV(String destinationFV) {
        this.destinationFV = destinationFV;
    }

    public boolean isNormalise() {
        return this.normalise;
    }

    public void setNormalise(boolean normalise) {
        this.normalise = normalise;
    }

    public int getOutputType() {
        return this.outputType;
    }

    public void setOutputType(int outputType) {
        this.outputType = outputType;
    }

    public boolean isOverall() {
        return this.overall;
    }

    public void setOverall(boolean overall) {
        this.overall = overall;
    }

    public boolean isPerWindow() {
        return this.perWindow;
    }

    public void setPerWindow(boolean perWindow) {
        this.perWindow = perWindow;
    }

    public double getSamplingRate() {
        return this.samplingRate;
    }

    public void setSamplingRate(double samplingRate) {
        this.samplingRate = samplingRate;
    }

    public double getWindowOverlap() {
        return this.windowOverlap;
    }

    public void setWindowOverlap(double windowOverlap) {
        this.windowOverlap = windowOverlap;
    }

    public int getWindowSize() {
        return this.windowSize;
    }

    public void setWindowSize(int windowSize) {
        this.windowSize = windowSize;
    }

    public void setRecording(RecordingInfo[] recording) {
        this.recording = recording;
    }

    public RecordingInfo[] getRecording() {
        return this.recording;
    }

    public DataModel getDataModel() {
        return this.dm_;
    }

    public void setAggregators(String[] aggNames, String[][] aggFeatures, String[][] aggParam) {
        if (aggNames.length == aggFeatures.length && aggFeatures.length == aggParam.length) {
            this.aggregatorNames = aggNames;
            this.aggregatorFeatures = aggFeatures;
            this.aggregatorParameters = aggParam;
        } else {
            System.out.println("INTERNAL ERROR: Parameters are not of the same length - implying differing numbers of aggregators to define:" + aggNames.length + " " + aggFeatures.length + " " + aggParam.length);
        }
    }

    public String[] getAggregatorNames() {
        return this.aggregatorNames;
    }

    public String[][] getAggregatorFeatures() {
        return this.aggregatorFeatures;
    }

    public String[][] getAggregatorParameters() {
        return this.aggregatorParameters;
    }
}

