/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.random;

import cern.colt.PersistentObject;
import cern.colt.Timer;
import cern.colt.list.DoubleArrayList;
import cern.colt.list.IntArrayList;
import cern.jet.random.AbstractDistribution;
import cern.jet.random.Gamma;
import cern.jet.random.Poisson;
import cern.jet.random.engine.MersenneTwister;
import cern.jet.random.engine.RandomEngine;
import hep.aida.bin.DynamicBin1D;

public class Benchmark
extends PersistentObject {
    protected RandomEngine randomGenerator;

    protected Benchmark() {
        throw new RuntimeException("Non instantiable");
    }

    public static void demo1() {
        double mean = 5.0;
        double variance = 1.5;
        double alpha = mean * mean / variance;
        double lambda = 1.0 / (variance / mean);
        MersenneTwister engine = new MersenneTwister();
        Gamma dist = new Gamma(alpha, lambda, engine);
        int size = 100000;
        DoubleArrayList numbers = new DoubleArrayList(size);
        int i = 0;
        while (i < size) {
            numbers.add(((AbstractDistribution)dist).nextDouble());
            ++i;
        }
        DynamicBin1D bin = new DynamicBin1D();
        bin.addAllOf(numbers);
        System.out.println(bin);
    }

    public static void main(String[] args) {
        int size = Integer.parseInt(args[0]);
        boolean print = new Boolean(args[1]);
        double mean = new Double(args[2]);
        String generatorName = args[3];
        Benchmark.random(size, print, mean, generatorName);
    }

    public static void random(int size, boolean print, double mean, String generatorName) {
        RandomEngine gen;
        System.out.println("Generating " + size + " random numbers per distribution...\n");
        int largeVariance = 100;
        try {
            gen = (RandomEngine)Class.forName(generatorName).newInstance();
        }
        catch (Exception exc) {
            throw new InternalError(exc.getMessage());
        }
        Benchmark.randomInstance(size, print, new Poisson(mean, (RandomEngine)gen.clone()));
    }

    public static void randomInstance(int size, boolean print, AbstractDistribution dist) {
        System.out.print("\n" + dist + " ...");
        Timer timer = new Timer().start();
        int i = size;
        while (--i >= 0) {
            double rand = dist.nextDouble();
            if (!print) continue;
            if ((size - i - 1) % 8 == 0) {
                System.out.println();
            }
            System.out.print(String.valueOf((float)rand) + ", ");
        }
        timer.stop();
        System.out.println("\n" + timer);
    }

    public static void test(int size, AbstractDistribution distribution) {
        int j = 0;
        int i = size;
        while (--i >= 0) {
            System.out.print(" " + distribution.nextDouble());
            if (j % 8 == 7) {
                System.out.println();
            }
            ++j;
        }
        System.out.println("\n\nGood bye.\n");
    }

    public static void test2(int size, AbstractDistribution distribution) {
        DynamicBin1D bin = new DynamicBin1D();
        int j = 0;
        int i = size;
        while (--i >= 0) {
            bin.add(distribution.nextDouble());
            ++j;
        }
        System.out.println(bin);
        System.out.println("\n\nGood bye.\n");
    }

    public static void test2(int size, AbstractDistribution a, AbstractDistribution b) {
        DynamicBin1D binA = new DynamicBin1D();
        DynamicBin1D binB = new DynamicBin1D();
        int j = 0;
        int i = size;
        while (--i >= 0) {
            binA.add(a.nextDouble());
            binB.add(b.nextDouble());
            ++j;
        }
        System.out.println("\n\nBenchmarking frequencies...\n");
        IntArrayList freq = new IntArrayList();
        DoubleArrayList distinct = new DoubleArrayList();
        Timer timer = new Timer();
        timer.reset();
        timer.start();
        binA.frequencies(distinct, freq);
        timer.stop().display();
        System.out.println("\n\nGood bye.\n");
    }
}

