/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.impl;

import cern.colt.function.Double27Function;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.DoubleMatrix3D;
import cern.colt.matrix.impl.DenseDoubleMatrix2D;
import cern.colt.matrix.impl.SelectedDenseDoubleMatrix3D;

public class DenseDoubleMatrix3D
extends DoubleMatrix3D {
    protected double[] elements;

    public DenseDoubleMatrix3D(double[][][] values) {
        this(values.length, values.length == 0 ? 0 : values[0].length, values.length == 0 ? 0 : (values[0].length == 0 ? 0 : values[0][0].length));
        this.assign(values);
    }

    public DenseDoubleMatrix3D(int slices, int rows, int columns) {
        this.setUp(slices, rows, columns);
        this.elements = new double[slices * rows * columns];
    }

    protected DenseDoubleMatrix3D(int slices, int rows, int columns, double[] elements, int sliceZero, int rowZero, int columnZero, int sliceStride, int rowStride, int columnStride) {
        this.setUp(slices, rows, columns, sliceZero, rowZero, columnZero, sliceStride, rowStride, columnStride);
        this.elements = elements;
        this.isNoView = false;
    }

    @Override
    public DoubleMatrix3D assign(double[][][] values) {
        if (this.isNoView) {
            if (values.length != this.slices) {
                throw new IllegalArgumentException("Must have same number of slices: slices=" + values.length + "slices()=" + this.slices());
            }
            int i = this.slices * this.rows * this.columns - this.columns;
            int slice = this.slices;
            while (--slice >= 0) {
                double[][] currentSlice = values[slice];
                if (currentSlice.length != this.rows) {
                    throw new IllegalArgumentException("Must have same number of rows in every slice: rows=" + currentSlice.length + "rows()=" + this.rows());
                }
                int row = this.rows;
                while (--row >= 0) {
                    double[] currentRow = currentSlice[row];
                    if (currentRow.length != this.columns) {
                        throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + currentRow.length + "columns()=" + this.columns());
                    }
                    System.arraycopy(currentRow, 0, this.elements, i, this.columns);
                    i -= this.columns;
                }
            }
        } else {
            super.assign(values);
        }
        return this;
    }

    @Override
    public DoubleMatrix3D assign(DoubleMatrix3D source) {
        if (!(source instanceof DenseDoubleMatrix3D)) {
            return super.assign(source);
        }
        DenseDoubleMatrix3D other = (DenseDoubleMatrix3D)source;
        if (other == this) {
            return this;
        }
        this.checkShape(other);
        if (this.haveSharedCells(other)) {
            DoubleMatrix3D c = other.copy();
            if (!(c instanceof DenseDoubleMatrix3D)) {
                return super.assign(source);
            }
            other = (DenseDoubleMatrix3D)c;
        }
        if (this.isNoView && other.isNoView) {
            System.arraycopy(other.elements, 0, this.elements, 0, this.elements.length);
            return this;
        }
        return super.assign(other);
    }

    @Override
    public double getQuick(int slice, int row, int column) {
        return this.elements[this.sliceZero + slice * this.sliceStride + this.rowZero + row * this.rowStride + this.columnZero + column * this.columnStride];
    }

    @Override
    protected boolean haveSharedCellsRaw(DoubleMatrix3D other) {
        if (other instanceof SelectedDenseDoubleMatrix3D) {
            SelectedDenseDoubleMatrix3D otherMatrix = (SelectedDenseDoubleMatrix3D)other;
            return this.elements == otherMatrix.elements;
        }
        if (other instanceof DenseDoubleMatrix3D) {
            DenseDoubleMatrix3D otherMatrix = (DenseDoubleMatrix3D)other;
            return this.elements == otherMatrix.elements;
        }
        return false;
    }

    @Override
    protected int index(int slice, int row, int column) {
        return this.sliceZero + slice * this.sliceStride + this.rowZero + row * this.rowStride + this.columnZero + column * this.columnStride;
    }

    @Override
    public DoubleMatrix3D like(int slices, int rows, int columns) {
        return new DenseDoubleMatrix3D(slices, rows, columns);
    }

    @Override
    protected DoubleMatrix2D like2D(int rows, int columns, int rowZero, int columnZero, int rowStride, int columnStride) {
        return new DenseDoubleMatrix2D(rows, columns, this.elements, rowZero, columnZero, rowStride, columnStride);
    }

    @Override
    public void setQuick(int slice, int row, int column, double value) {
        this.elements[this.sliceZero + slice * this.sliceStride + this.rowZero + row * this.rowStride + this.columnZero + column * this.columnStride] = value;
    }

    @Override
    protected DoubleMatrix3D viewSelectionLike(int[] sliceOffsets, int[] rowOffsets, int[] columnOffsets) {
        return new SelectedDenseDoubleMatrix3D(this.elements, sliceOffsets, rowOffsets, columnOffsets, 0);
    }

    @Override
    public void zAssign27Neighbors(DoubleMatrix3D B, Double27Function function) {
        if (!(B instanceof DenseDoubleMatrix3D)) {
            super.zAssign27Neighbors(B, function);
            return;
        }
        if (function == null) {
            throw new NullPointerException("function must not be null.");
        }
        this.checkShape(B);
        int r = this.rows - 1;
        int c = this.columns - 1;
        if (this.rows < 3 || this.columns < 3 || this.slices < 3) {
            return;
        }
        DenseDoubleMatrix3D BB = (DenseDoubleMatrix3D)B;
        int A_ss = this.sliceStride;
        int A_rs = this.rowStride;
        int B_rs = BB.rowStride;
        int A_cs = this.columnStride;
        int B_cs = BB.columnStride;
        double[] elems = this.elements;
        double[] B_elems = BB.elements;
        if (elems == null || B_elems == null) {
            throw new InternalError();
        }
        int k = 1;
        while (k < this.slices - 1) {
            int A_index = this.index(k, 1, 1);
            int B_index = BB.index(k, 1, 1);
            int i = 1;
            while (i < r) {
                int A002 = A_index - A_ss - A_rs - A_cs;
                int A012 = A002 + A_rs;
                int A022 = A012 + A_rs;
                int A102 = A002 + A_ss;
                int A112 = A102 + A_rs;
                int A122 = A112 + A_rs;
                int A202 = A102 + A_ss;
                int A212 = A202 + A_rs;
                int A222 = A212 + A_rs;
                double a000 = elems[A002];
                double a001 = elems[A002 += A_cs];
                double a010 = elems[A012];
                double a011 = elems[A012 += A_cs];
                double a020 = elems[A022];
                double a021 = elems[A022 += A_cs];
                double a100 = elems[A102];
                double a101 = elems[A102 += A_cs];
                double a110 = elems[A112];
                double a111 = elems[A112 += A_cs];
                double a120 = elems[A122];
                double a121 = elems[A122 += A_cs];
                double a200 = elems[A202];
                double a201 = elems[A202 += A_cs];
                double a210 = elems[A212];
                double a211 = elems[A212 += A_cs];
                double a220 = elems[A222];
                double a221 = elems[A222 += A_cs];
                int B11 = B_index;
                int j = 1;
                while (j < c) {
                    double a002 = elems[A002 += A_cs];
                    double a012 = elems[A012 += A_cs];
                    double a022 = elems[A022 += A_cs];
                    double a102 = elems[A102 += A_cs];
                    double a112 = elems[A112 += A_cs];
                    double a122 = elems[A122 += A_cs];
                    double a202 = elems[A202 += A_cs];
                    double a212 = elems[A212 += A_cs];
                    double a222 = elems[A222 += A_cs];
                    B_elems[B11] = function.apply(a000, a001, a002, a010, a011, a012, a020, a021, a022, a100, a101, a102, a110, a111, a112, a120, a121, a122, a200, a201, a202, a210, a211, a212, a220, a221, a222);
                    B11 += B_cs;
                    a000 = a001;
                    a001 = a002;
                    a010 = a011;
                    a011 = a012;
                    a020 = a021;
                    a021 = a022;
                    a100 = a101;
                    a101 = a102;
                    a110 = a111;
                    a111 = a112;
                    a120 = a121;
                    a121 = a122;
                    a200 = a201;
                    a201 = a202;
                    a210 = a211;
                    a211 = a212;
                    a220 = a221;
                    a221 = a222;
                    ++j;
                }
                A_index += A_rs;
                B_index += B_rs;
                ++i;
            }
            ++k;
        }
    }
}

