/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.impl;

import cern.colt.PersistentObject;
import cern.colt.matrix.impl.AbstractMatrix1D;
import cern.colt.matrix.impl.AbstractMatrix2D;
import cern.colt.matrix.impl.AbstractMatrix3D;
import cern.colt.matrix.impl.Former;
import cern.colt.matrix.impl.FormerFactory;

public abstract class AbstractFormatter
extends PersistentObject {
    public static final String LEFT = "left";
    public static final String CENTER = "center";
    public static final String RIGHT = "right";
    public static final String DECIMAL = "decimal";
    public static final int DEFAULT_MIN_COLUMN_WIDTH = 1;
    public static final String DEFAULT_COLUMN_SEPARATOR = " ";
    public static final String DEFAULT_ROW_SEPARATOR = "\n";
    public static final String DEFAULT_SLICE_SEPARATOR = "\n\n";
    protected String alignment = "left";
    protected String format = "%G";
    protected int minColumnWidth = 1;
    protected String columnSeparator = " ";
    protected String rowSeparator = "\n";
    protected String sliceSeparator = "\n\n";
    protected boolean printShape = true;
    private static String[] blanksCache;
    protected static final FormerFactory factory;

    static {
        factory = new FormerFactory();
        AbstractFormatter.setupBlanksCache();
    }

    protected AbstractFormatter() {
    }

    protected void align(String[][] strings) {
        int rows = strings.length;
        int columns = 0;
        if (rows > 0) {
            columns = strings[0].length;
        }
        int[] maxColWidth = new int[columns];
        int[] maxColLead = null;
        boolean isDecimal = this.alignment.equals(DECIMAL);
        if (isDecimal) {
            maxColLead = new int[columns];
        }
        int column = 0;
        while (column < columns) {
            int maxWidth = this.minColumnWidth;
            int maxLead = Integer.MIN_VALUE;
            int row = 0;
            while (row < rows) {
                String s = strings[row][column];
                maxWidth = Math.max(maxWidth, s.length());
                if (isDecimal) {
                    maxLead = Math.max(maxLead, this.lead(s));
                }
                ++row;
            }
            maxColWidth[column] = maxWidth;
            if (isDecimal) {
                maxColLead[column] = maxLead;
            }
            ++column;
        }
        int row = 0;
        while (row < rows) {
            this.alignRow(strings[row], maxColWidth, maxColLead);
            ++row;
        }
    }

    protected int alignmentCode(String alignment) {
        if (alignment.equals(LEFT)) {
            return -1;
        }
        if (alignment.equals(CENTER)) {
            return 0;
        }
        if (alignment.equals(RIGHT)) {
            return 1;
        }
        if (alignment.equals(DECIMAL)) {
            return 2;
        }
        throw new IllegalArgumentException("unknown alignment: " + alignment);
    }

    protected void alignRow(String[] row, int[] maxColWidth, int[] maxColLead) {
        int align = this.alignmentCode(this.alignment);
        StringBuffer s = new StringBuffer();
        int columns = row.length;
        int column = 0;
        while (column < columns) {
            s.setLength(0);
            String c = row[column];
            if (this.alignment.equals(RIGHT)) {
                s.append(this.blanks(maxColWidth[column] - s.length()));
                s.append(c);
            } else if (this.alignment.equals(DECIMAL)) {
                s.append(this.blanks(maxColLead[column] - this.lead(c)));
                s.append(c);
                s.append(this.blanks(maxColWidth[column] - s.length()));
            } else if (this.alignment.equals(CENTER)) {
                s.append(this.blanks((maxColWidth[column] - c.length()) / 2));
                s.append(c);
                s.append(this.blanks(maxColWidth[column] - s.length()));
            } else if (this.alignment.equals(LEFT)) {
                s.append(c);
                s.append(this.blanks(maxColWidth[column] - s.length()));
            } else {
                throw new InternalError();
            }
            row[column] = s.toString();
            ++column;
        }
    }

    protected String blanks(int length) {
        if (length < 0) {
            length = 0;
        }
        if (length < blanksCache.length) {
            return blanksCache[length];
        }
        StringBuffer buf = new StringBuffer(length);
        int k = 0;
        while (k < length) {
            buf.append(' ');
            ++k;
        }
        return buf.toString();
    }

    public static void demo1() {
    }

    public static void demo2() {
    }

    public static void demo3(int size, Object value) {
    }

    protected abstract String form(AbstractMatrix1D var1, int var2, Former var3);

    protected abstract String[][] format(AbstractMatrix2D var1);

    protected String[] formatRow(AbstractMatrix1D vector) {
        Former formatter = null;
        formatter = factory.create(this.format);
        int s = vector.size();
        String[] strings = new String[s];
        int i = 0;
        while (i < s) {
            strings[i] = this.form(vector, i, formatter);
            ++i;
        }
        return strings;
    }

    protected int lead(String s) {
        return s.length();
    }

    protected String repeat(char character, int length) {
        if (character == ' ') {
            return this.blanks(length);
        }
        if (length < 0) {
            length = 0;
        }
        StringBuffer buf = new StringBuffer(length);
        int k = 0;
        while (k < length) {
            buf.append(character);
            ++k;
        }
        return buf.toString();
    }

    public void setAlignment(String alignment) {
        this.alignment = alignment;
    }

    public void setColumnSeparator(String columnSeparator) {
        this.columnSeparator = columnSeparator;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public void setMinColumnWidth(int minColumnWidth) {
        if (minColumnWidth < 0) {
            throw new IllegalArgumentException();
        }
        this.minColumnWidth = minColumnWidth;
    }

    public void setPrintShape(boolean printShape) {
        this.printShape = printShape;
    }

    public void setRowSeparator(String rowSeparator) {
        this.rowSeparator = rowSeparator;
    }

    public void setSliceSeparator(String sliceSeparator) {
        this.sliceSeparator = sliceSeparator;
    }

    protected static void setupBlanksCache() {
        int size = 40;
        blanksCache = new String[size];
        StringBuffer buf = new StringBuffer(size);
        int i = size;
        while (--i >= 0) {
            buf.append(' ');
        }
        String str = buf.toString();
        int i2 = size;
        while (--i2 >= 0) {
            AbstractFormatter.blanksCache[i2] = str.substring(0, i2);
        }
    }

    public static String shape(AbstractMatrix1D matrix) {
        return String.valueOf(matrix.size()) + " matrix";
    }

    public static String shape(AbstractMatrix2D matrix) {
        return String.valueOf(matrix.rows()) + " x " + matrix.columns() + " matrix";
    }

    public static String shape(AbstractMatrix3D matrix) {
        return String.valueOf(matrix.slices()) + " x " + matrix.rows() + " x " + matrix.columns() + " matrix";
    }

    protected String toString(String[][] strings) {
        int rows = strings.length;
        int columns = strings.length <= 0 ? 0 : strings[0].length;
        StringBuffer total = new StringBuffer();
        StringBuffer s = new StringBuffer();
        int row = 0;
        while (row < rows) {
            s.setLength(0);
            int column = 0;
            while (column < columns) {
                s.append(strings[row][column]);
                if (column < columns - 1) {
                    s.append(this.columnSeparator);
                }
                ++column;
            }
            total.append(s);
            if (row < rows - 1) {
                total.append(this.rowSeparator);
            }
            ++row;
        }
        return total.toString();
    }

    protected String toString(AbstractMatrix2D matrix) {
        String[][] strings = this.format(matrix);
        this.align(strings);
        StringBuffer total = new StringBuffer(this.toString(strings));
        if (this.printShape) {
            total.insert(0, String.valueOf(AbstractFormatter.shape(matrix)) + DEFAULT_ROW_SEPARATOR);
        }
        return total.toString();
    }
}

