/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.list;

import cern.colt.Arrays;
import cern.colt.Sorting;
import cern.colt.function.ShortComparator;
import cern.colt.function.ShortProcedure;
import cern.colt.list.AbstractList;
import cern.colt.list.ShortArrayList;
import cern.jet.random.Uniform;
import cern.jet.random.engine.DRand;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;

public abstract class AbstractShortList
extends AbstractList {
    protected int size;

    protected AbstractShortList() {
    }

    public void add(short element) {
        this.beforeInsert(this.size, element);
    }

    public void addAllOfFromTo(AbstractShortList other, int from, int to) {
        this.beforeInsertAllOfFromTo(this.size, other, from, to);
    }

    public void beforeInsert(int index, short element) {
        this.beforeInsertDummies(index, 1);
        this.set(index, element);
    }

    public void beforeInsertAllOfFromTo(int index, AbstractShortList other, int from, int to) {
        int length = to - from + 1;
        this.beforeInsertDummies(index, length);
        this.replaceFromToWithFrom(index, index + length - 1, other, from);
    }

    @Override
    protected void beforeInsertDummies(int index, int length) {
        if (index > this.size || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        if (length > 0) {
            this.ensureCapacity(this.size + length);
            this.setSizeRaw(this.size + length);
            this.replaceFromToWithFrom(index + length, this.size - 1, this, index);
        }
    }

    public int binarySearch(short key) {
        return this.binarySearchFromTo(key, 0, this.size - 1);
    }

    public int binarySearchFromTo(short key, int from, int to) {
        int low = from;
        int high = to;
        while (low <= high) {
            int mid = (low + high) / 2;
            short midVal = this.get(mid);
            if (midVal < key) {
                low = mid + 1;
                continue;
            }
            if (midVal > key) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    @Override
    public Object clone() {
        return this.partFromTo(0, this.size - 1);
    }

    public boolean contains(short elem) {
        return this.indexOfFromTo(elem, 0, this.size - 1) >= 0;
    }

    public void delete(short element) {
        int index = this.indexOfFromTo(element, 0, this.size - 1);
        if (index >= 0) {
            this.remove(index);
        }
    }

    public short[] elements() {
        short[] myElements = new short[this.size];
        int i = this.size;
        while (--i >= 0) {
            myElements[i] = this.getQuick(i);
        }
        return myElements;
    }

    public AbstractShortList elements(short[] elements) {
        this.clear();
        this.addAllOfFromTo(new ShortArrayList(elements), 0, elements.length - 1);
        return this;
    }

    public abstract void ensureCapacity(int var1);

    public boolean equals(Object otherObj) {
        if (!(otherObj instanceof AbstractShortList)) {
            return false;
        }
        if (this == otherObj) {
            return true;
        }
        if (otherObj == null) {
            // empty if block
        }
        AbstractShortList other = (AbstractShortList)otherObj;
        if (this.size() != other.size()) {
            return false;
        }
        int i = this.size();
        while (--i >= 0) {
            if (this.getQuick(i) == other.getQuick(i)) continue;
            return false;
        }
        return true;
    }

    public void fillFromToWith(int from, int to, short val) {
        AbstractShortList.checkRangeFromTo(from, to, this.size);
        int i = from;
        while (i <= to) {
            this.setQuick(i++, val);
        }
    }

    public boolean forEach(ShortProcedure procedure) {
        int i = 0;
        while (i < this.size) {
            if (procedure.apply(this.get(i++))) continue;
            return false;
        }
        return true;
    }

    public short get(int index) {
        if (index >= this.size || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        return this.getQuick(index);
    }

    protected abstract short getQuick(int var1);

    public int indexOf(short element) {
        return this.indexOfFromTo(element, 0, this.size - 1);
    }

    public int indexOfFromTo(short element, int from, int to) {
        AbstractShortList.checkRangeFromTo(from, to, this.size);
        int i = from;
        while (i <= to) {
            if (element == this.getQuick(i)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int lastIndexOf(short element) {
        return this.lastIndexOfFromTo(element, 0, this.size - 1);
    }

    public int lastIndexOfFromTo(short element, int from, int to) {
        AbstractShortList.checkRangeFromTo(from, to, this.size());
        int i = to;
        while (i >= from) {
            if (element == this.getQuick(i)) {
                return i;
            }
            --i;
        }
        return -1;
    }

    @Override
    public void mergeSortFromTo(int from, int to) {
        int mySize = this.size();
        AbstractShortList.checkRangeFromTo(from, to, mySize);
        short[] myElements = this.elements();
        Sorting.mergeSort(myElements, from, to + 1);
        this.elements(myElements);
        this.setSizeRaw(mySize);
    }

    public void mergeSortFromTo(int from, int to, ShortComparator c) {
        int mySize = this.size();
        AbstractShortList.checkRangeFromTo(from, to, mySize);
        short[] myElements = this.elements();
        Sorting.mergeSort(myElements, from, to + 1, c);
        this.elements(myElements);
        this.setSizeRaw(mySize);
    }

    public AbstractShortList partFromTo(int from, int to) {
        AbstractShortList.checkRangeFromTo(from, to, this.size);
        int length = to - from + 1;
        ShortArrayList part = new ShortArrayList(length);
        part.addAllOfFromTo(this, from, to);
        return part;
    }

    @Override
    public void quickSortFromTo(int from, int to) {
        int mySize = this.size();
        AbstractShortList.checkRangeFromTo(from, to, mySize);
        short[] myElements = this.elements();
        java.util.Arrays.sort(myElements, from, to + 1);
        this.elements(myElements);
        this.setSizeRaw(mySize);
    }

    public void quickSortFromTo(int from, int to, ShortComparator c) {
        int mySize = this.size();
        AbstractShortList.checkRangeFromTo(from, to, mySize);
        short[] myElements = this.elements();
        Sorting.quickSort(myElements, from, to + 1, c);
        this.elements(myElements);
        this.setSizeRaw(mySize);
    }

    public boolean removeAll(AbstractShortList other) {
        if (other.size() == 0) {
            return false;
        }
        int limit = other.size() - 1;
        int j = 0;
        int i = 0;
        while (i < this.size) {
            if (other.indexOfFromTo(this.getQuick(i), 0, limit) < 0) {
                this.setQuick(j++, this.getQuick(i));
            }
            ++i;
        }
        boolean modified = j != this.size;
        this.setSize(j);
        return modified;
    }

    @Override
    public void removeFromTo(int from, int to) {
        int width;
        AbstractShortList.checkRangeFromTo(from, to, this.size);
        int numMoved = this.size - to - 1;
        if (numMoved > 0) {
            this.replaceFromToWithFrom(from, from - 1 + numMoved, this, to + 1);
        }
        if ((width = to - from + 1) > 0) {
            this.setSizeRaw(this.size - width);
        }
    }

    public void replaceFromToWithFrom(int from, int to, AbstractShortList other, int otherFrom) {
        block4: {
            int length = to - from + 1;
            if (length <= 0) break block4;
            AbstractShortList.checkRangeFromTo(from, to, this.size());
            AbstractShortList.checkRangeFromTo(otherFrom, otherFrom + length - 1, other.size());
            if (from <= otherFrom) {
                while (--length >= 0) {
                    this.setQuick(from++, other.getQuick(otherFrom++));
                }
            } else {
                int otherTo = otherFrom + length - 1;
                while (--length >= 0) {
                    this.setQuick(to--, other.getQuick(otherTo--));
                }
            }
        }
    }

    public void replaceFromToWithFromTo(int from, int to, AbstractShortList other, int otherFrom, int otherTo) {
        int length;
        if (otherFrom > otherTo) {
            throw new IndexOutOfBoundsException("otherFrom: " + otherFrom + ", otherTo: " + otherTo);
        }
        if (this == other && to - from != otherTo - otherFrom) {
            this.replaceFromToWithFromTo(from, to, this.partFromTo(otherFrom, otherTo), 0, otherTo - otherFrom);
            return;
        }
        int diff = length = otherTo - otherFrom + 1;
        int theLast = from - 1;
        if (to >= from) {
            diff -= to - from + 1;
            theLast = to;
        }
        if (diff > 0) {
            this.beforeInsertDummies(theLast + 1, diff);
        } else if (diff < 0) {
            this.removeFromTo(theLast + diff, theLast - 1);
        }
        if (length > 0) {
            this.replaceFromToWithFrom(from, from + length - 1, other, otherFrom);
        }
    }

    @Override
    public void replaceFromWith(int from, Collection other) {
        AbstractShortList.checkRange(from, this.size());
        Iterator e = other.iterator();
        int index = from;
        int limit = Math.min(this.size() - from, other.size());
        int i = 0;
        while (i < limit) {
            this.set(index++, ((Number)e.next()).shortValue());
            ++i;
        }
    }

    public boolean retainAll(AbstractShortList other) {
        if (other.size() == 0) {
            if (this.size == 0) {
                return false;
            }
            this.setSize(0);
            return true;
        }
        int limit = other.size() - 1;
        int j = 0;
        int i = 0;
        while (i < this.size) {
            if (other.indexOfFromTo(this.getQuick(i), 0, limit) >= 0) {
                this.setQuick(j++, this.getQuick(i));
            }
            ++i;
        }
        boolean modified = j != this.size;
        this.setSize(j);
        return modified;
    }

    @Override
    public void reverse() {
        int limit = this.size() / 2;
        int j = this.size() - 1;
        int i = 0;
        while (i < limit) {
            short tmp = this.getQuick(i);
            this.setQuick(i++, this.getQuick(j));
            this.setQuick(j--, tmp);
        }
    }

    public void set(int index, short element) {
        if (index >= this.size || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        this.setQuick(index, element);
    }

    protected abstract void setQuick(int var1, short var2);

    protected void setSizeRaw(int newSize) {
        this.size = newSize;
    }

    @Override
    public void shuffleFromTo(int from, int to) {
        AbstractShortList.checkRangeFromTo(from, to, this.size());
        Uniform gen = new Uniform(new DRand(new Date()));
        int i = from;
        while (i < to) {
            int random = gen.nextIntFromTo(i, to);
            short tmpElement = this.getQuick(random);
            this.setQuick(random, this.getQuick(i));
            this.setQuick(i, tmpElement);
            ++i;
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    public AbstractShortList times(int times) {
        ShortArrayList newList = new ShortArrayList(times * this.size());
        int i = times;
        while (--i >= 0) {
            newList.addAllOfFromTo(this, 0, this.size() - 1);
        }
        return newList;
    }

    @Override
    public ArrayList toList() {
        int mySize = this.size();
        ArrayList<Short> list = new ArrayList<Short>(mySize);
        int i = 0;
        while (i < mySize) {
            list.add(new Short(this.get(i)));
            ++i;
        }
        return list;
    }

    @Override
    public String toString() {
        return Arrays.toString(this.partFromTo(0, this.size() - 1).elements());
    }
}

