/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.ph.snuggletex.internal.util;

import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import uk.ac.ed.ph.snuggletex.SerializationSpecifier;
import uk.ac.ed.ph.snuggletex.SnuggleRuntimeException;
import uk.ac.ed.ph.snuggletex.utilities.StylesheetManager;

public final class XMLUtilities {
    public static final String SAXON_TRANSFORMER_FACTORY_CLASS_NAME = "net.sf.saxon.TransformerFactoryImpl";

    public static TransformerFactory createJAXPTransformerFactory() {
        TransformerFactory transformerFactory = null;
        try {
            transformerFactory = TransformerFactory.newInstance();
        }
        catch (TransformerFactoryConfigurationError e) {
            throw new SnuggleRuntimeException(e);
        }
        XMLUtilities.requireFeature(transformerFactory, "http://javax.xml.transform.dom.DOMSource/feature");
        XMLUtilities.requireFeature(transformerFactory, "http://javax.xml.transform.dom.DOMResult/feature");
        return transformerFactory;
    }

    public static void requireFeature(TransformerFactory transformerFactory, String feature) {
        if (!transformerFactory.getFeature(feature)) {
            throw new SnuggleRuntimeException("TransformerFactory " + transformerFactory.getClass().getName() + " needs to support feature " + feature + " in order to be used with SnuggleTeX");
        }
    }

    public static boolean isSaxonAvailable() {
        try {
            Class.forName(SAXON_TRANSFORMER_FACTORY_CLASS_NAME);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static TransformerFactory createSaxonTransformerFactory() {
        TransformerFactory transformerFactory;
        try {
            transformerFactory = (TransformerFactory)Class.forName(SAXON_TRANSFORMER_FACTORY_CLASS_NAME).newInstance();
        }
        catch (Exception e) {
            throw new SnuggleRuntimeException("Failed to explicitly instantiate Saxon net.sf.saxon.TransformerFactoryImpl class - check your ClassPath!", e);
        }
        XMLUtilities.requireFeature(transformerFactory, "http://javax.xml.transform.dom.DOMSource/feature");
        XMLUtilities.requireFeature(transformerFactory, "http://javax.xml.transform.dom.DOMResult/feature");
        return transformerFactory;
    }

    public static boolean supportsXSLT20(TransformerFactory tranformerFactory) {
        return tranformerFactory.getClass().getName().startsWith("net.sf.saxon.");
    }

    public static boolean supportsXSLT20(Transformer tranformer) {
        return tranformer.getClass().getName().startsWith("net.sf.saxon.");
    }

    public static DocumentBuilder createNSAwareDocumentBuilder() {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        try {
            return documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new SnuggleRuntimeException("Could not create Namespace-aware DocumentBuilder", e);
        }
    }

    public static String extractTextElementValue(Element textElement) {
        String result;
        NodeList childNodes = textElement.getChildNodes();
        if (childNodes.getLength() == 1) {
            result = XMLUtilities.ensureExtractTextNodeValue(childNodes.item(0));
        } else {
            StringBuilder resultBuilder = new StringBuilder();
            int i = 0;
            while (i < childNodes.getLength()) {
                resultBuilder.append(XMLUtilities.ensureExtractTextNodeValue(childNodes.item(i)));
                ++i;
            }
            result = resultBuilder.toString();
        }
        return result;
    }

    private static String ensureExtractTextNodeValue(Node node) {
        if (node.getNodeType() == 3) {
            return node.getNodeValue();
        }
        throw new IllegalArgumentException("Node is not a text Node");
    }

    public static String serializeNode(Node node, SerializationSpecifier serializationOptions) {
        return XMLUtilities.serializeNode(new StylesheetManager(), node, serializationOptions);
    }

    public static String serializeNode(StylesheetManager stylesheetManager, Node node, SerializationSpecifier serializationOptions) {
        StringWriter resultWriter = new StringWriter();
        try {
            Transformer serializer = stylesheetManager.getSerializer(null, serializationOptions);
            serializer.transform(new DOMSource(node), new StreamResult(resultWriter));
        }
        catch (Exception e) {
            throw new SnuggleRuntimeException("Could not serialize DOM", e);
        }
        return resultWriter.toString();
    }

    public static String serializeNodeChildren(StylesheetManager stylesheetManager, Node node, SerializationSpecifier serializationOptions) {
        StringWriter resultWriter = new StringWriter();
        try {
            Transformer serializer = stylesheetManager.getSerializer("classpath:/uk/ac/ed/ph/snuggletex/extract-child-nodes.xsl", serializationOptions);
            serializer.transform(new DOMSource(node), new StreamResult(resultWriter));
        }
        catch (Exception e) {
            throw new SnuggleRuntimeException("Could not serialize DOM", e);
        }
        return resultWriter.toString();
    }

    public static boolean isXMLName(String string) {
        return string != null && string.matches("[a-zA-Z_:][a-zA-Z0-9_:.-]*");
    }

    public static boolean isXMLNCName(String string) {
        return string != null && string.matches("[a-zA-Z_][a-zA-Z0-9_.-]*");
    }
}

