/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.ph.snuggletex.internal.util;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.Arrays;
import uk.ac.ed.ph.snuggletex.internal.util.BeanToStringOptions;
import uk.ac.ed.ph.snuggletex.internal.util.PropertyOptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ObjectUtilities {
    public static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];

    public static String safeToString(Object object) {
        return object != null ? object.toString() : null;
    }

    public static boolean nullSafeEquals(Object o1, Object o2) {
        return o1 == o2 || o1 != null && o1.equals(o2);
    }

    public static boolean isNullOrEmpty(Object[] array) {
        return array == null || array.length == 0;
    }

    public static <E> E[] concat(E[] array1, E[] array2, Class<E> itemClass) {
        boolean array1Empty = ObjectUtilities.isNullOrEmpty(array1);
        boolean array2Empty = ObjectUtilities.isNullOrEmpty(array2);
        if (array1Empty && array2Empty) {
            return (Object[])Array.newInstance(itemClass, 0);
        }
        if (array1Empty) {
            return array2;
        }
        if (array2Empty) {
            return array1;
        }
        Object[] result = (Object[])Array.newInstance(itemClass, array1.length + array2.length);
        System.arraycopy(array1, 0, result, 0, array1.length);
        System.arraycopy(array2, 0, result, array1.length, array2.length);
        return result;
    }

    public static String beanToString(Object bean) {
        Class<?> beanClass = bean.getClass();
        StringBuilder result = new StringBuilder(beanClass.getName()).append("@").append(Integer.toHexString(bean.hashCode())).append("(");
        Method[] methods = beanClass.getMethods();
        boolean outputMade = false;
        Method[] methodArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            block13: {
                PropertyOptions propertyOption;
                String rawPropertyName;
                String methodName;
                Method method;
                block15: {
                    block14: {
                        method = methodArray[n2];
                        methodName = method.getName();
                        if (!methodName.startsWith("get") || method.getParameterTypes().length != 0 || methodName.equals("getClass") || methodName.length() <= "get".length()) break block14;
                        rawPropertyName = methodName.substring("get".length());
                        break block15;
                    }
                    if (!methodName.startsWith("is") || method.getParameterTypes().length != 0 || methodName.length() <= "is".length()) break block13;
                    rawPropertyName = methodName.substring("is".length());
                }
                BeanToStringOptions beanAnnotation = method.getAnnotation(BeanToStringOptions.class);
                PropertyOptions propertyOptions = propertyOption = beanAnnotation != null ? beanAnnotation.value() : null;
                if (propertyOption == null || propertyOption != PropertyOptions.IGNORE_PROPERTY) {
                    if (outputMade) {
                        result.append(",");
                    } else {
                        outputMade = true;
                    }
                    result.append(Character.toLowerCase(rawPropertyName.charAt(0)));
                    if (methodName.length() > 1) {
                        result.append(rawPropertyName.substring(1));
                    }
                    result.append("=");
                    Object value = null;
                    try {
                        value = method.invoke(bean, new Object[0]);
                    }
                    catch (Exception e) {
                        result.append("[Caused Exception ").append(e).append("]");
                        break block13;
                    }
                    if (propertyOption != null && propertyOption == PropertyOptions.HIDE_VALUE) {
                        result.append(value != null ? "[hidden]" : value);
                    } else if (value instanceof Object[]) {
                        result.append(Arrays.toString((Object[])value));
                    } else {
                        result.append(value);
                    }
                }
            }
            ++n2;
        }
        result.append(")");
        return result.toString();
    }
}

