/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.ph.snuggletex.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import uk.ac.ed.ph.snuggletex.InputError;
import uk.ac.ed.ph.snuggletex.SnuggleLogicException;
import uk.ac.ed.ph.snuggletex.definitions.BuiltinCommand;
import uk.ac.ed.ph.snuggletex.definitions.BuiltinEnvironment;
import uk.ac.ed.ph.snuggletex.definitions.CoreErrorCode;
import uk.ac.ed.ph.snuggletex.definitions.CorePackageDefinitions;
import uk.ac.ed.ph.snuggletex.definitions.LaTeXMode;
import uk.ac.ed.ph.snuggletex.definitions.TextFlowContext;
import uk.ac.ed.ph.snuggletex.internal.FrozenSlice;
import uk.ac.ed.ph.snuggletex.internal.SessionContext;
import uk.ac.ed.ph.snuggletex.internal.SnuggleParseException;
import uk.ac.ed.ph.snuggletex.semantics.Interpretation;
import uk.ac.ed.ph.snuggletex.semantics.InterpretationType;
import uk.ac.ed.ph.snuggletex.semantics.MathBracketInterpretation;
import uk.ac.ed.ph.snuggletex.semantics.MathIdentifierInterpretation;
import uk.ac.ed.ph.snuggletex.semantics.MathNumberInterpretation;
import uk.ac.ed.ph.snuggletex.semantics.MathOperatorInterpretation;
import uk.ac.ed.ph.snuggletex.tokens.ArgumentContainerToken;
import uk.ac.ed.ph.snuggletex.tokens.BraceContainerToken;
import uk.ac.ed.ph.snuggletex.tokens.CommandToken;
import uk.ac.ed.ph.snuggletex.tokens.EnvironmentToken;
import uk.ac.ed.ph.snuggletex.tokens.ErrorToken;
import uk.ac.ed.ph.snuggletex.tokens.FlowToken;
import uk.ac.ed.ph.snuggletex.tokens.SimpleToken;
import uk.ac.ed.ph.snuggletex.tokens.Token;
import uk.ac.ed.ph.snuggletex.tokens.TokenType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TokenFixer {
    private final SessionContext sessionContext;

    public TokenFixer(SessionContext sessionContext) {
        this.sessionContext = sessionContext;
    }

    public void fixTokenTree(ArgumentContainerToken token) throws SnuggleParseException {
        this.visitBranch(token);
    }

    private void visitBranch(Token rootToken) throws SnuggleParseException {
        switch (rootToken.getType()) {
            case ARGUMENT_CONTAINER: {
                this.visitContainerContent((ArgumentContainerToken)rootToken);
                break;
            }
            case COMMAND: {
                this.visitCommand((CommandToken)rootToken);
                break;
            }
            case ENVIRONMENT: {
                this.visitEnvironment((EnvironmentToken)rootToken);
                break;
            }
            case TEXT_MODE_TEXT: {
                break;
            }
            case BRACE_CONTAINER: {
                this.visitContainerContent(((BraceContainerToken)rootToken).getBraceContent());
                break;
            }
            case ERROR: 
            case TAB_CHARACTER: 
            case LR_MODE_NEW_PARAGRAPH: 
            case VERBATIM_MODE_TEXT: 
            case MATH_NUMBER: 
            case SINGLE_CHARACTER_MATH_IDENTIFIER: 
            case SINGLE_CHARACTER_MATH_SPECIAL: {
                break;
            }
            case NEW_PARAGRAPH: {
                throw new SnuggleLogicException("Unfixed " + (Object)((Object)rootToken.getType()) + " token: " + rootToken);
            }
            default: {
                throw new SnuggleLogicException("Unhandled type " + (Object)((Object)rootToken.getType()));
            }
        }
    }

    private void visitEnvironment(EnvironmentToken environmentToken) throws SnuggleParseException {
        BuiltinEnvironment environment = environmentToken.getEnvironment();
        if (environment == CorePackageDefinitions.ENV_ITEMIZE || environment == CorePackageDefinitions.ENV_ENUMERATE) {
            this.fixListEnvironmentContent(environmentToken);
        } else if (environment.hasInterpretation(InterpretationType.TABULAR)) {
            this.fixTabularEnvironmentContent(environmentToken);
        }
        if (environment != CorePackageDefinitions.ENV_BRACKETED) {
            ArgumentContainerToken[] arguments;
            ArgumentContainerToken optArgument = environmentToken.getOptionalArgument();
            if (optArgument != null) {
                this.visitContainerContent(optArgument);
            }
            if ((arguments = environmentToken.getArguments()) != null) {
                ArgumentContainerToken[] argumentContainerTokenArray = arguments;
                int n = arguments.length;
                int n2 = 0;
                while (n2 < n) {
                    ArgumentContainerToken argument = argumentContainerTokenArray[n2];
                    this.visitContainerContent(argument);
                    ++n2;
                }
            }
        }
        this.visitContainerContent(environmentToken.getContent());
    }

    private void visitCommand(CommandToken commandToken) throws SnuggleParseException {
        ArgumentContainerToken[] arguments;
        ArgumentContainerToken optArgument = commandToken.getOptionalArgument();
        if (optArgument != null) {
            this.visitContainerContent(optArgument);
        }
        if ((arguments = commandToken.getArguments()) != null) {
            ArgumentContainerToken[] argumentContainerTokenArray = arguments;
            int n = arguments.length;
            int n2 = 0;
            while (n2 < n) {
                ArgumentContainerToken argument = argumentContainerTokenArray[n2];
                this.visitContainerContent(argument);
                ++n2;
            }
        }
    }

    private void visitContainerContent(ArgumentContainerToken parent) throws SnuggleParseException {
        List<FlowToken> content = parent.getContents();
        switch (parent.getLatexMode()) {
            case PARAGRAPH: {
                this.visitSiblingsParagraphMode(parent, content);
                break;
            }
            case LR: {
                this.visitSiblingsLRMode(parent, content);
                break;
            }
            case MATH: {
                this.visitSiblingsMathMode(parent, content);
                break;
            }
            case VERBATIM: {
                break;
            }
            default: {
                throw new SnuggleLogicException("Unhandled mode " + (Object)((Object)parent.getLatexMode()));
            }
        }
    }

    private void visitSiblingsParagraphMode(Token parentToken, List<FlowToken> tokens) throws SnuggleParseException {
        this.groupStyleCommands(parentToken, tokens);
        this.stripRedundantWhitespaceTokens(tokens);
        this.inferParagraphs(tokens);
        for (FlowToken token : tokens) {
            this.visitBranch(token);
        }
    }

    private void groupStyleCommands(Token parentToken, List<FlowToken> tokens) {
        int i = 0;
        while (i < tokens.size()) {
            FlowToken token = tokens.get(i);
            if (token.getType() == TokenType.COMMAND && token.hasInterpretationType(InterpretationType.STYLE_DECLARATION) && ((CommandToken)token).getCommand().getArgumentCount() == 0) {
                CommandToken commandToken = (CommandToken)token;
                BuiltinCommand command = commandToken.getCommand();
                BuiltinEnvironment environment = this.sessionContext.getBuiltinEnvironmentByTeXName(command.getTeXName());
                if (environment == null) {
                    throw new SnuggleLogicException("No environment defined to replace old TeX command " + command);
                }
                if (i + 1 < tokens.size()) {
                    FlowToken lastToken = tokens.get(tokens.size() - 1);
                    ArgumentContainerToken contentToken = ArgumentContainerToken.createFromContiguousTokens(parentToken, token.getLatexMode(), tokens, i + 1, tokens.size());
                    FrozenSlice replacementSlice = token.getSlice().rightOuterSpan(lastToken.getSlice());
                    EnvironmentToken replacement = new EnvironmentToken(replacementSlice, token.getLatexMode(), environment, contentToken);
                    tokens.set(i, replacement);
                    tokens.subList(i + 1, tokens.size()).clear();
                    break;
                }
                ArgumentContainerToken contentToken = ArgumentContainerToken.createEmptyContainer(token, token.getLatexMode());
                EnvironmentToken replacement = new EnvironmentToken(token.getSlice(), token.getLatexMode(), environment, contentToken);
                tokens.set(i, replacement);
                break;
            }
            ++i;
        }
    }

    private void stripRedundantWhitespaceTokens(List<FlowToken> tokens) {
        int i = 0;
        while (i < tokens.size()) {
            FlowToken token = tokens.get(i);
            if (token.getType() == TokenType.TEXT_MODE_TEXT) {
                boolean blockAfter;
                if ((i == 0 || i == tokens.size() - 1) && token.getSlice().isWhitespace()) {
                    tokens.remove(i);
                    continue;
                }
                boolean blockBefore = i == 0 || tokens.get(i - 1).getTextFlowContext() == TextFlowContext.START_NEW_XHTML_BLOCK;
                boolean bl = blockAfter = i == tokens.size() - 1 || tokens.get(i + 1).getTextFlowContext() == TextFlowContext.START_NEW_XHTML_BLOCK;
                if (blockBefore && blockAfter && token.getSlice().isWhitespace()) {
                    tokens.remove(i);
                    continue;
                }
            }
            ++i;
        }
    }

    private void inferParagraphs(List<FlowToken> tokens) {
        ArrayList<FlowToken> paragraphBuilder = new ArrayList<FlowToken>();
        ArrayList<FlowToken> resultBuilder = new ArrayList<FlowToken>();
        int paragraphCount = 0;
        boolean hasParagraphs = false;
        int i = 0;
        while (i < tokens.size()) {
            FlowToken token = tokens.get(i);
            if (token.getType() == TokenType.NEW_PARAGRAPH || token.isCommand(CorePackageDefinitions.CMD_PAR)) {
                hasParagraphs = true;
                if (!paragraphBuilder.isEmpty()) {
                    resultBuilder.add(this.buildGroupedCommandToken(token, CorePackageDefinitions.CMD_PARAGRAPH, paragraphBuilder));
                    ++paragraphCount;
                }
            } else if (token.getTextFlowContext() == TextFlowContext.START_NEW_XHTML_BLOCK) {
                hasParagraphs = true;
                if (!paragraphBuilder.isEmpty()) {
                    CommandToken leftOver = this.buildGroupedCommandToken(tokens.get(0), CorePackageDefinitions.CMD_PARAGRAPH, paragraphBuilder);
                    resultBuilder.add(leftOver);
                    ++paragraphCount;
                }
                resultBuilder.add(token);
            } else if (token.getTextFlowContext() == TextFlowContext.IGNORE && paragraphBuilder.isEmpty()) {
                resultBuilder.add(token);
            } else {
                paragraphBuilder.add(token);
            }
            ++i;
        }
        if (!hasParagraphs) {
            return;
        }
        if (!paragraphBuilder.isEmpty()) {
            CommandToken leftOver = this.buildGroupedCommandToken(tokens.get(0), CorePackageDefinitions.CMD_PARAGRAPH, paragraphBuilder);
            resultBuilder.add(leftOver);
            ++paragraphCount;
        }
        tokens.clear();
        if (paragraphCount > 1) {
            tokens.addAll(resultBuilder);
        } else {
            for (FlowToken resultToken : resultBuilder) {
                if (resultToken.isCommand(CorePackageDefinitions.CMD_PARAGRAPH)) {
                    tokens.addAll(((CommandToken)resultToken).getArguments()[0].getContents());
                    continue;
                }
                tokens.add(resultToken);
            }
        }
    }

    private void visitSiblingsLRMode(Token parentToken, List<FlowToken> tokens) throws SnuggleParseException {
        this.groupStyleCommands(parentToken, tokens);
        this.stripBlocks(tokens);
        for (FlowToken token : tokens) {
            this.visitBranch(token);
        }
    }

    private void stripBlocks(List<FlowToken> tokens) throws SnuggleParseException {
        int i = 0;
        while (i < tokens.size()) {
            FlowToken token = tokens.get(i);
            if (token.getType() == TokenType.NEW_PARAGRAPH || token.isCommand(CorePackageDefinitions.CMD_PAR)) {
                tokens.set(i, new SimpleToken(token.getSlice(), TokenType.LR_MODE_NEW_PARAGRAPH, LaTeXMode.LR, TextFlowContext.ALLOW_INLINE, new Interpretation[0]));
            } else if (token.getType() != TokenType.ERROR && token.getTextFlowContext() == TextFlowContext.START_NEW_XHTML_BLOCK) {
                tokens.set(i, this.createError(token, CoreErrorCode.TFEG00, token.getSlice().extract().toString()));
            }
            ++i;
        }
    }

    private void fixListEnvironmentContent(EnvironmentToken environmentToken) throws SnuggleParseException {
        List<FlowToken> contents = environmentToken.getContent().getContents();
        ArrayList<FlowToken> itemBuilder = new ArrayList<FlowToken>();
        ArrayList<FlowToken> resultBuilder = new ArrayList<FlowToken>();
        boolean foundItem = false;
        int i = 0;
        int size = contents.size();
        while (i < size) {
            FlowToken token = contents.get(i);
            if (token.isCommand(CorePackageDefinitions.CMD_ITEM)) {
                if (foundItem) {
                    CommandToken itemBefore = this.buildGroupedCommandToken(environmentToken, CorePackageDefinitions.CMD_LIST_ITEM, itemBuilder);
                    resultBuilder.add(itemBefore);
                }
                foundItem = true;
            } else if (!foundItem) {
                if (!(token.getType() == TokenType.TEXT_MODE_TEXT && token.getSlice().isWhitespace() || token.getType() == TokenType.NEW_PARAGRAPH)) {
                    resultBuilder.add(this.createError(token, CoreErrorCode.TFEL00, new Object[0]));
                }
            } else {
                itemBuilder.add(token);
            }
            ++i;
        }
        if (foundItem) {
            resultBuilder.add(this.buildGroupedCommandToken(environmentToken, CorePackageDefinitions.CMD_LIST_ITEM, itemBuilder));
        }
        contents.clear();
        contents.addAll(resultBuilder);
    }

    private void fixTabularEnvironmentContent(EnvironmentToken environmentToken) throws SnuggleParseException {
        ArrayList<FlowToken> resultBuilder = new ArrayList<FlowToken>();
        ArrayList<CommandToken> rowBuilder = new ArrayList<CommandToken>();
        ArrayList<FlowToken> columnBuilder = new ArrayList<FlowToken>();
        List<FlowToken> contents = environmentToken.getContent().getContents();
        List<FlowToken> entries = contents;
        if (entries.size() > 0 && !entries.get(entries.size() - 1).isCommand(CorePackageDefinitions.CMD_CHAR_BACKSLASH)) {
            entries = new ArrayList<FlowToken>(entries);
            entries.add(null);
        }
        Token lastGoodToken = null;
        int i = 0;
        int size = entries.size();
        while (i < size) {
            block14: {
                FlowToken token;
                block13: {
                    block12: {
                        token = entries.get(i);
                        if (token != null && !token.isCommand(CorePackageDefinitions.CMD_CHAR_BACKSLASH)) break block12;
                        if (token == null && lastGoodToken != null && lastGoodToken.isCommand(CorePackageDefinitions.CMD_HLINE)) break;
                        rowBuilder.add(this.buildGroupedCommandToken(environmentToken, CorePackageDefinitions.CMD_TABLE_COLUMN, columnBuilder));
                        resultBuilder.add(this.buildGroupedCommandToken(environmentToken, CorePackageDefinitions.CMD_TABLE_ROW, rowBuilder));
                        break block13;
                    }
                    if (token.getType() == TokenType.TEXT_MODE_TEXT && token.getSlice().isWhitespace()) break block14;
                    if (token.getType() == TokenType.TAB_CHARACTER) {
                        rowBuilder.add(this.buildGroupedCommandToken(environmentToken, CorePackageDefinitions.CMD_TABLE_COLUMN, columnBuilder));
                    } else if (token.isCommand(CorePackageDefinitions.CMD_HLINE)) {
                        if (!columnBuilder.isEmpty()) {
                            resultBuilder.add(this.createError((FlowToken)columnBuilder.get(0), CoreErrorCode.TFETB0, new Object[0]));
                            columnBuilder.clear();
                        } else if (!rowBuilder.isEmpty()) {
                            resultBuilder.add(this.createError((FlowToken)rowBuilder.get(0), CoreErrorCode.TFETB0, new Object[0]));
                            rowBuilder.clear();
                        }
                        resultBuilder.add(token);
                    } else {
                        columnBuilder.add(token);
                    }
                }
                lastGoodToken = token;
            }
            ++i;
        }
        contents.clear();
        contents.addAll(resultBuilder);
    }

    private void visitSiblingsMathMode(ArgumentContainerToken parentToken, List<FlowToken> tokens) throws SnuggleParseException {
        BuiltinCommand command;
        if (tokens.isEmpty()) {
            return;
        }
        boolean isStructural = false;
        FlowToken firstToken = tokens.get(0);
        if (firstToken.getType() == TokenType.COMMAND && ((command = ((CommandToken)firstToken).getCommand()) == CorePackageDefinitions.CMD_TABLE_ROW || command == CorePackageDefinitions.CMD_TABLE_COLUMN)) {
            isStructural = true;
        }
        if (!isStructural) {
            this.fixLeadingNegativeNumber(tokens);
            this.groupStyleCommands(parentToken, tokens);
            this.fencePairedParentheses(parentToken, tokens);
            this.fixOverInstances(parentToken, tokens);
            this.inferParenthesisFences(parentToken, tokens);
            this.fixSubscriptAndSuperscripts(parentToken, tokens);
            this.fixPrimes(tokens);
        }
        for (FlowToken token : tokens) {
            this.visitBranch(token);
        }
    }

    private void fixLeadingNegativeNumber(List<FlowToken> tokens) {
        if (tokens.size() < 2) {
            return;
        }
        FlowToken firstToken = tokens.get(0);
        FlowToken secondToken = tokens.get(1);
        if (firstToken.hasInterpretationType(InterpretationType.MATH_OPERATOR) && ((MathOperatorInterpretation)firstToken.getInterpretation(InterpretationType.MATH_OPERATOR)).getMathMLOperatorContent() == "-" && secondToken.hasInterpretationType(InterpretationType.MATH_NUMBER)) {
            String negation = "-" + ((MathNumberInterpretation)secondToken.getInterpretation(InterpretationType.MATH_NUMBER)).getNumber();
            SimpleToken replacementToken = new SimpleToken(firstToken.getSlice().rightOuterSpan(secondToken.getSlice()), TokenType.MATH_NUMBER, firstToken.getLatexMode(), null, new Interpretation[]{new MathNumberInterpretation(negation)});
            tokens.remove(0);
            tokens.set(0, replacementToken);
        }
    }

    private void fixOverInstances(ArgumentContainerToken parentToken, List<FlowToken> tokens) throws SnuggleParseException {
        int overIndex = -1;
        int i = 0;
        while (i < tokens.size()) {
            FlowToken token = tokens.get(i);
            if (token.isCommand(CorePackageDefinitions.CMD_OVER)) {
                if (overIndex != -1) {
                    tokens.clear();
                    tokens.add(this.createError(token, CoreErrorCode.TFEM00, new Object[0]));
                    return;
                }
                overIndex = i;
            }
            ++i;
        }
        if (overIndex != -1) {
            ArrayList<FlowToken> beforeTokens = new ArrayList<FlowToken>(tokens.subList(0, overIndex));
            ArrayList<FlowToken> afterTokens = new ArrayList<FlowToken>(tokens.subList(overIndex + 1, tokens.size()));
            CommandToken replacement = new CommandToken(parentToken.getSlice(), LaTeXMode.MATH, CorePackageDefinitions.CMD_FRAC, null, new ArgumentContainerToken[]{ArgumentContainerToken.createFromContiguousTokens(parentToken, LaTeXMode.MATH, beforeTokens), ArgumentContainerToken.createFromContiguousTokens(parentToken, LaTeXMode.MATH, afterTokens)});
            tokens.clear();
            tokens.add(replacement);
        }
    }

    private void fixPrimes(List<FlowToken> tokens) {
        int i = 0;
        while (i < tokens.size() - 1) {
            FlowToken maybePrimeToken = tokens.get(i + 1);
            if (maybePrimeToken.hasInterpretationType(InterpretationType.MATH_IDENTIFIER) && ((MathIdentifierInterpretation)maybePrimeToken.getInterpretation(InterpretationType.MATH_IDENTIFIER)).getName().equals("'")) {
                FlowToken leftToken = tokens.get(i);
                FrozenSlice replacementSlice = leftToken.getSlice().rightOuterSpan(maybePrimeToken.getSlice());
                CommandToken replacementToken = new CommandToken(replacementSlice, LaTeXMode.MATH, CorePackageDefinitions.CMD_MSUP_OR_MOVER, null, new ArgumentContainerToken[]{ArgumentContainerToken.createFromSingleToken(LaTeXMode.MATH, leftToken), ArgumentContainerToken.createFromSingleToken(LaTeXMode.MATH, maybePrimeToken)});
                tokens.set(i, replacementToken);
                tokens.remove(i + 1);
            }
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void fixSubscriptAndSuperscripts(Token parentToken, List<FlowToken> tokens) throws SnuggleParseException {
        tokenOperator = null;
        i = 0;
        while (i < tokens.size()) {
            block10: {
                block11: {
                    size = tokens.size();
                    subOrSuperToken = tokens.get(i);
                    firstIsSuper = false;
                    isSubOrSuper = false;
                    if (subOrSuperToken.hasInterpretationType(new InterpretationType[]{InterpretationType.MATH_OPERATOR})) {
                        tokenOperator = ((MathOperatorInterpretation)subOrSuperToken.getInterpretation(InterpretationType.MATH_OPERATOR)).getMathMLOperatorContent();
                        v0 = isSubOrSuper = tokenOperator == "^" || tokenOperator == "_";
                    }
                    if (!isSubOrSuper) break block10;
                    if (i != size - 1) break block11;
                    tokens.set(i, this.createError(subOrSuperToken, CoreErrorCode.TFEM01, new Object[0]));
                    break block10;
                }
                if (i == 0) {
                    emptyBeforeContainer = ArgumentContainerToken.createEmptyContainer(parentToken, LaTeXMode.MATH);
                    t1 = new BraceContainerToken(emptyBeforeContainer.getSlice(), LaTeXMode.MATH, emptyBeforeContainer);
                    startModifyIndex = i;
                } else {
                    t1 = tokens.get(i - 1);
                    startModifyIndex = i - 1;
                }
                t2 = tokens.get(i + 1);
                t3 = null;
                followingOperator = null;
                if (i + 2 >= size || !tokens.get(i + 2).hasInterpretationType(new InterpretationType[]{InterpretationType.MATH_OPERATOR}) || (followingOperator = ((MathOperatorInterpretation)tokens.get(i + 2).getInterpretation(InterpretationType.MATH_OPERATOR)).getMathMLOperatorContent()) != "^" && followingOperator != "_") ** GOTO lbl-1000
                if (i + 3 >= size) {
                    tokens.set(i - 1, this.createError(subOrSuperToken, CoreErrorCode.TFEM01, new Object[0]));
                    tokens.subList(i, i + 3).clear();
                } else {
                    t3 = tokens.get(i + 3);
                    if (tokenOperator == "^" && followingOperator == "^" || tokenOperator == "_" && followingOperator == "_") {
                        tokens.set(i - 1, this.createError(subOrSuperToken, CoreErrorCode.TFEM02, new Object[0]));
                        tokens.subList(i, i + 3).clear();
                    } else lbl-1000:
                    // 2 sources

                    {
                        v1 = firstIsSuper = tokenOperator == "^";
                        if (t3 != null) {
                            replacementSlice = t1.getSlice().rightOuterSpan(t3.getSlice());
                            replacementCommand = CorePackageDefinitions.CMD_MSUBSUP_OR_MUNDEROVER;
                            replacement = new CommandToken(replacementSlice, LaTeXMode.MATH, replacementCommand, null, new ArgumentContainerToken[]{ArgumentContainerToken.createFromSingleToken(LaTeXMode.MATH, t1), firstIsSuper != false ? ArgumentContainerToken.createFromSingleToken(LaTeXMode.MATH, (FlowToken)t3) : ArgumentContainerToken.createFromSingleToken(LaTeXMode.MATH, t2), firstIsSuper != false ? ArgumentContainerToken.createFromSingleToken(LaTeXMode.MATH, t2) : ArgumentContainerToken.createFromSingleToken(LaTeXMode.MATH, (FlowToken)t3)});
                            tokens.set(startModifyIndex, replacement);
                            tokens.subList(startModifyIndex + 1, i + 4).clear();
                        } else {
                            replacementSlice = t1.getSlice().rightOuterSpan(t2.getSlice());
                            replacementCommand = firstIsSuper != false ? CorePackageDefinitions.CMD_MSUP_OR_MOVER : CorePackageDefinitions.CMD_MSUB_OR_MUNDER;
                            replacement = new CommandToken(replacementSlice, LaTeXMode.MATH, replacementCommand, null, new ArgumentContainerToken[]{ArgumentContainerToken.createFromSingleToken(LaTeXMode.MATH, t1), ArgumentContainerToken.createFromSingleToken(LaTeXMode.MATH, t2)});
                            tokens.set(startModifyIndex, replacement);
                            tokens.subList(startModifyIndex + 1, i + 2).clear();
                        }
                    }
                }
            }
            ++i;
        }
    }

    private void fencePairedParentheses(Token parentToken, List<FlowToken> tokens) throws SnuggleParseException {
        int i = 0;
        while (i < tokens.size()) {
            FlowToken token = tokens.get(i);
            if (token.isCommand(CorePackageDefinitions.CMD_RIGHT)) {
                tokens.set(i, this.createError(token, CoreErrorCode.TFEM03, new Object[0]));
            } else if (token.isCommand(CorePackageDefinitions.CMD_LEFT)) {
                ArrayList<FlowToken> innerTokens = new ArrayList<FlowToken>();
                CommandToken openBracketToken = (CommandToken)token;
                Token matchingCloseBracketToken = null;
                int matchingCloseBracketIndex = -1;
                int bracketLevel = 1;
                int j = i + 1;
                while (j < tokens.size()) {
                    FlowToken innerToken = tokens.get(j);
                    if (innerToken.isCommand(CorePackageDefinitions.CMD_LEFT)) {
                        ++bracketLevel;
                    } else if (innerToken.isCommand(CorePackageDefinitions.CMD_RIGHT) && --bracketLevel == 0) {
                        matchingCloseBracketToken = (CommandToken)innerToken;
                        matchingCloseBracketIndex = j;
                        break;
                    }
                    innerTokens.add(innerToken);
                    ++j;
                }
                if (matchingCloseBracketToken == null) {
                    tokens.set(i, this.createError(token, CoreErrorCode.TFEM04, new Object[0]));
                    tokens.subList(i + 1, tokens.size()).clear();
                    break;
                }
                FrozenSlice replacementSlice = openBracketToken.getSlice().rightOuterSpan(matchingCloseBracketToken.getSlice());
                EnvironmentToken replacementToken = new EnvironmentToken(replacementSlice, LaTeXMode.MATH, CorePackageDefinitions.ENV_BRACKETED, null, new ArgumentContainerToken[]{ArgumentContainerToken.createFromSingleToken(LaTeXMode.MATH, openBracketToken.getCombinerTarget()), ArgumentContainerToken.createFromSingleToken(LaTeXMode.MATH, ((CommandToken)matchingCloseBracketToken).getCombinerTarget())}, ArgumentContainerToken.createFromContiguousTokens(parentToken, LaTeXMode.MATH, innerTokens));
                tokens.set(i, replacementToken);
                tokens.subList(i + 1, matchingCloseBracketIndex + 1).clear();
            }
            ++i;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void inferParenthesisFences(Token parentToken, List<FlowToken> tokens) {
        int i = 0;
        while (i < tokens.size()) {
            MathBracketInterpretation interpretation;
            FlowToken token = tokens.get(i);
            if (token.hasInterpretationType(InterpretationType.MATH_BRACKET) && (interpretation = (MathBracketInterpretation)token.getInterpretation(InterpretationType.MATH_BRACKET)).isPairingInferencePossible()) {
                MathBracketInterpretation.BracketType bracketType = interpretation.getBracketType();
                if (bracketType == MathBracketInterpretation.BracketType.CLOSER) {
                    FrozenSlice replacementSlice = tokens.get(0).getSlice().rightOuterSpan(token.getSlice());
                    ArrayList<FlowToken> innerTokens = new ArrayList<FlowToken>(tokens.subList(0, i));
                    EnvironmentToken replacementToken = new EnvironmentToken(replacementSlice, LaTeXMode.MATH, CorePackageDefinitions.ENV_BRACKETED, null, new ArgumentContainerToken[]{ArgumentContainerToken.createEmptyContainer(parentToken, LaTeXMode.MATH), ArgumentContainerToken.createFromSingleToken(LaTeXMode.MATH, token)}, ArgumentContainerToken.createFromContiguousTokens(parentToken, LaTeXMode.MATH, innerTokens));
                    tokens.set(0, replacementToken);
                    tokens.subList(1, i + 1).clear();
                    i = 0;
                } else if (bracketType != MathBracketInterpretation.BracketType.OPENER_OR_CLOSER) {
                    EnvironmentToken replacementToken;
                    FrozenSlice replacementSlice;
                    ArrayList<FlowToken> innerTokens = new ArrayList<FlowToken>();
                    FlowToken openBracketToken = token;
                    Token matchingCloseBracketToken = null;
                    int matchingCloseBracketIndex = -1;
                    Stack<MathBracketInterpretation> openerStack = new Stack<MathBracketInterpretation>();
                    openerStack.add(interpretation);
                    int j = i + 1;
                    block6: while (j < tokens.size()) {
                        FlowToken afterToken = tokens.get(j);
                        if (afterToken.hasInterpretationType(InterpretationType.MATH_BRACKET)) {
                            MathBracketInterpretation afterInterpretation = (MathBracketInterpretation)afterToken.getInterpretation(InterpretationType.MATH_BRACKET);
                            MathBracketInterpretation.BracketType afterBracketType = afterInterpretation.getBracketType();
                            switch (afterBracketType) {
                                case OPENER: {
                                    openerStack.add(afterInterpretation);
                                    break;
                                }
                                case OPENER_OR_CLOSER: {
                                    break;
                                }
                                case CLOSER: {
                                    openerStack.pop();
                                    if (!openerStack.isEmpty()) break;
                                    matchingCloseBracketToken = afterToken;
                                    matchingCloseBracketIndex = j;
                                    break block6;
                                }
                            }
                        }
                        innerTokens.add(afterToken);
                        ++j;
                    }
                    if (matchingCloseBracketToken != null) {
                        replacementSlice = openBracketToken.getSlice().rightOuterSpan(matchingCloseBracketToken.getSlice());
                        replacementToken = new EnvironmentToken(replacementSlice, LaTeXMode.MATH, CorePackageDefinitions.ENV_BRACKETED, null, new ArgumentContainerToken[]{ArgumentContainerToken.createFromSingleToken(LaTeXMode.MATH, openBracketToken), ArgumentContainerToken.createFromSingleToken(LaTeXMode.MATH, (FlowToken)matchingCloseBracketToken)}, ArgumentContainerToken.createFromContiguousTokens(parentToken, LaTeXMode.MATH, innerTokens));
                        tokens.set(i, replacementToken);
                        tokens.subList(i + 1, matchingCloseBracketIndex + 1).clear();
                    } else {
                        replacementSlice = openBracketToken.getSlice().rightOuterSpan(tokens.get(tokens.size() - 1).getSlice());
                        replacementToken = new EnvironmentToken(replacementSlice, LaTeXMode.MATH, CorePackageDefinitions.ENV_BRACKETED, null, new ArgumentContainerToken[]{ArgumentContainerToken.createFromSingleToken(LaTeXMode.MATH, openBracketToken), ArgumentContainerToken.createEmptyContainer(parentToken, LaTeXMode.MATH)}, ArgumentContainerToken.createFromContiguousTokens(parentToken, LaTeXMode.MATH, innerTokens));
                        tokens.set(i, replacementToken);
                        tokens.subList(i + 1, tokens.size()).clear();
                    }
                }
            }
            ++i;
        }
    }

    private CommandToken buildGroupedCommandToken(Token parentToken, BuiltinCommand command, List<? extends FlowToken> itemBuilder) {
        ArgumentContainerToken contentToken = itemBuilder.isEmpty() ? ArgumentContainerToken.createEmptyContainer(parentToken, parentToken.getLatexMode()) : ArgumentContainerToken.createFromContiguousTokens(parentToken, itemBuilder.get(0).getLatexMode(), itemBuilder);
        CommandToken result = new CommandToken(contentToken.getSlice(), contentToken.getLatexMode(), command, null, new ArgumentContainerToken[]{contentToken});
        itemBuilder.clear();
        return result;
    }

    private ErrorToken createError(FlowToken token, CoreErrorCode errorCode, Object ... arguments) throws SnuggleParseException {
        FrozenSlice slice = token.getSlice();
        InputError error = new InputError(errorCode, slice, arguments);
        this.sessionContext.registerError(error);
        return new ErrorToken(error, token.getLatexMode());
    }
}

