/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.ph.snuggletex.dombuilding;

import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import uk.ac.ed.ph.snuggletex.definitions.CoreErrorCode;
import uk.ac.ed.ph.snuggletex.dombuilding.EnvironmentHandler;
import uk.ac.ed.ph.snuggletex.dombuilding.TabularHandler;
import uk.ac.ed.ph.snuggletex.internal.DOMBuilder;
import uk.ac.ed.ph.snuggletex.internal.SnuggleParseException;
import uk.ac.ed.ph.snuggletex.tokens.ArgumentContainerToken;
import uk.ac.ed.ph.snuggletex.tokens.CommandToken;
import uk.ac.ed.ph.snuggletex.tokens.EnvironmentToken;
import uk.ac.ed.ph.snuggletex.tokens.FlowToken;

public final class ArrayHandler
implements EnvironmentHandler {
    public void handleEnvironment(DOMBuilder builder, Element parentElement, EnvironmentToken token) throws SnuggleParseException {
        int[] geometry = TabularHandler.computeTableDimensions(token.getContent());
        int numColumns = geometry[1];
        ArgumentContainerToken alignSpecToken = token.getArguments()[0];
        CharSequence alignSpecData = token.getArguments()[0].getSlice().extract();
        if (alignSpecData.length() == 0) {
            builder.appendOrThrowError(parentElement, alignSpecToken, CoreErrorCode.TDEMA1, new Object[0]);
            return;
        }
        ArrayList<String> alignments = new ArrayList<String>(alignSpecData.length());
        int i = 0;
        while (i < alignSpecData.length()) {
            char c = alignSpecData.charAt(i);
            switch (c) {
                case 'c': {
                    alignments.add("center");
                    break;
                }
                case 'l': {
                    alignments.add("left");
                    break;
                }
                case 'r': {
                    alignments.add("right");
                    break;
                }
                default: {
                    builder.appendOrThrowError(parentElement, alignSpecToken, CoreErrorCode.TDEMA0, String.valueOf(c));
                    alignments.add("center");
                }
            }
            ++i;
        }
        int maxColumns = alignments.size();
        if (maxColumns < numColumns) {
            builder.appendOrThrowError(parentElement, alignSpecToken, CoreErrorCode.TDEMA2, alignSpecData.length(), numColumns);
        }
        Element mtableElement = builder.appendMathMLElement(parentElement, "mtable");
        for (FlowToken rowToken : token.getContent()) {
            Element mtrElement = builder.appendMathMLElement(mtableElement, "mtr");
            List<FlowToken> columns = ((CommandToken)rowToken).getArguments()[0].getContents();
            int rowColumns = columns.size();
            int i2 = 0;
            while (i2 < maxColumns && i2 < rowColumns) {
                FlowToken columnToken = columns.get(i2);
                Element mtdElement = builder.appendMathMLElement(mtrElement, "mtd");
                mtdElement.setAttribute("columnalign", (String)alignments.get(i2));
                builder.handleTokens(mtdElement, ((CommandToken)columnToken).getArguments()[0].getContents(), true);
                ++i2;
            }
            i2 = 0;
            while (i2 < maxColumns - rowColumns) {
                builder.appendMathMLElement(mtrElement, "mtd");
                ++i2;
            }
        }
    }
}

