/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.ph.snuggletex;

import java.util.Arrays;
import uk.ac.ed.ph.snuggletex.ErrorCode;
import uk.ac.ed.ph.snuggletex.internal.FrozenSlice;

public final class InputError {
    private final FrozenSlice slice;
    private final ErrorCode errorCode;
    private final Object[] arguments;
    private String stringRepresentation;

    public InputError(ErrorCode errorCode, FrozenSlice slice, Object ... arguments) {
        this.slice = slice;
        this.errorCode = errorCode;
        this.arguments = arguments;
    }

    public ErrorCode getErrorCode() {
        return this.errorCode;
    }

    public FrozenSlice getSlice() {
        return this.slice;
    }

    public Object[] getArguments() {
        return this.arguments;
    }

    public String toString() {
        if (this.stringRepresentation == null) {
            this.stringRepresentation = this.buildStringRepresentation();
        }
        return this.stringRepresentation;
    }

    private String buildStringRepresentation() {
        return String.valueOf(this.getClass().getSimpleName()) + "(errorCode=" + this.errorCode.toString() + ",slice=" + this.slice.toString() + ",arguments=" + Arrays.toString(this.arguments) + ")";
    }
}

