/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.mime.identifier.magic;

import java.util.ArrayList;
import org.semanticdesktop.aperture.mime.identifier.magic.MagicNumber;
import org.semanticdesktop.aperture.mime.identifier.magic.MagicString;

public class MimeTypeDescription {
    private String mimeType;
    private String parentType;
    private ArrayList extensions;
    private ArrayList magicStrings;
    private ArrayList magicNumbers;
    private boolean allowsLeadingWhiteSpace;
    private ArrayList requiringTypes;

    public MimeTypeDescription(String mimeType, String parentType, ArrayList extensions, ArrayList magicStrings, ArrayList magicNumbers, boolean allowsLeadingWhiteSpace) {
        this.mimeType = mimeType;
        this.parentType = parentType;
        this.extensions = extensions;
        this.magicStrings = magicStrings;
        this.magicNumbers = magicNumbers;
        this.allowsLeadingWhiteSpace = allowsLeadingWhiteSpace;
        this.requiringTypes = new ArrayList(0);
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public String getParentType() {
        return this.parentType;
    }

    public ArrayList getExtensions() {
        return this.extensions;
    }

    public ArrayList getMagicStrings() {
        return this.magicStrings;
    }

    public ArrayList getMagicNumbers() {
        return this.magicNumbers;
    }

    public boolean getAllowsLeadingWhiteSpace() {
        return this.allowsLeadingWhiteSpace;
    }

    public void addRequiringType(MimeTypeDescription description) {
        this.requiringTypes.add(description);
    }

    public ArrayList getRequiringTypes() {
        return this.requiringTypes;
    }

    public boolean matches(char[] chars) {
        if (chars != null && this.magicStrings != null && !this.magicStrings.isEmpty()) {
            int skippedChars = 0;
            if (this.allowsLeadingWhiteSpace) {
                char c;
                for (int i = 0; i < chars.length && Character.isWhitespace(c = chars[i]); ++i) {
                    ++skippedChars;
                }
            }
            int nrStrings = this.magicStrings.size();
            for (int i = 0; i < nrStrings; ++i) {
                MagicString magicString = (MagicString)this.magicStrings.get(i);
                if (!magicString.matches(chars, skippedChars)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean matches(byte[] bytes) {
        if (bytes != null && this.magicNumbers != null && !this.magicNumbers.isEmpty()) {
            int skippedBytes = 0;
            if (this.allowsLeadingWhiteSpace) {
                char c;
                for (int i = 0; i < bytes.length && (Character.isWhitespace(c = (char)bytes[i]) || c == '\u0000' || c == '\u00ff' || c == '\u00fe' || c == '\u00ef' || c == '\u00bb' || c == '\u00bf'); ++i) {
                    ++skippedBytes;
                }
            }
            int nrNumbers = this.magicNumbers.size();
            for (int i = 0; i < nrNumbers; ++i) {
                MagicNumber magicNumber = (MagicNumber)this.magicNumbers.get(i);
                if (!magicNumber.matches(bytes, skippedBytes)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean containsExtension(String extension) {
        return this.extensions.contains(extension);
    }
}

