/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.mime.identifier.magic;

public class MagicString {
    private char[] magicChars;
    private boolean caseSensitive;

    public MagicString(char[] magicChars, boolean caseSensitive) {
        if (magicChars == null) {
            throw new IllegalArgumentException("magicChars should not be null");
        }
        this.magicChars = magicChars;
        this.caseSensitive = caseSensitive;
        if (!caseSensitive) {
            for (int i = 0; i < magicChars.length; ++i) {
                magicChars[i] = Character.toLowerCase(magicChars[i]);
            }
        }
    }

    public char[] getMagicChars() {
        return this.magicChars;
    }

    public int getMinimumLength() {
        return this.magicChars.length;
    }

    public boolean matches(char[] chars, int skippedLeadingChars) {
        if (chars.length < this.magicChars.length + skippedLeadingChars) {
            return false;
        }
        for (int i = 0; i < this.magicChars.length; ++i) {
            char magicChar = this.magicChars[i];
            char testedChar = chars[i + skippedLeadingChars];
            if (!this.caseSensitive) {
                testedChar = Character.toLowerCase(testedChar);
            }
            if (magicChar == testedChar) continue;
            return false;
        }
        return true;
    }
}

