/*
 * Decompiled with CFR 0.152.
 */
package javax.media.opengl;

import com.jogamp.common.nio.Buffers;
import com.jogamp.opengl.FloatUtil;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import javax.media.opengl.GLException;

public class GLUniformData {
    private String name;
    private int location;
    private int rows;
    private int columns;
    private int count;
    private Object data;
    private boolean isMatrix;

    public GLUniformData(String string, int n) {
        this.init(string, 1, new Integer(n));
    }

    public GLUniformData(String string, float f) {
        this.init(string, 1, new Float(f));
    }

    public GLUniformData(String string, int n, IntBuffer intBuffer) {
        this.init(string, n, intBuffer);
    }

    public GLUniformData(String string, int n, FloatBuffer floatBuffer) {
        this.init(string, n, floatBuffer);
    }

    public GLUniformData(String string, int n, int n2, FloatBuffer floatBuffer) {
        this.init(string, n, n2, floatBuffer);
    }

    public GLUniformData setData(int n) {
        this.init(new Integer(n));
        return this;
    }

    public GLUniformData setData(float f) {
        this.init(new Float(f));
        return this;
    }

    public GLUniformData setData(IntBuffer intBuffer) {
        this.init(intBuffer);
        return this;
    }

    public GLUniformData setData(FloatBuffer floatBuffer) {
        this.init(floatBuffer);
        return this;
    }

    public int intValue() {
        return (Integer)this.data;
    }

    public float floatValue() {
        return ((Float)this.data).floatValue();
    }

    public IntBuffer intBufferValue() {
        return (IntBuffer)this.data;
    }

    public FloatBuffer floatBufferValue() {
        return (FloatBuffer)this.data;
    }

    public StringBuilder toString(StringBuilder stringBuilder) {
        if (null == stringBuilder) {
            stringBuilder = new StringBuilder();
        }
        stringBuilder.append("GLUniformData[name ").append(this.name).append(", location ").append(this.location).append(", size ").append(this.rows).append("x").append(this.columns).append(", count ").append(this.count).append(", data ");
        if (this.isMatrix() && this.data instanceof FloatBuffer) {
            stringBuilder.append("\n");
            FloatBuffer floatBuffer = (FloatBuffer)this.getBuffer();
            for (int i = 0; i < this.count; ++i) {
                FloatUtil.matrixToString(stringBuilder, i + ": ", "%10.5f", floatBuffer, i * this.rows * this.columns, this.rows, this.columns, false);
                stringBuilder.append(",\n");
            }
        } else if (this.isBuffer()) {
            Buffers.toString((StringBuilder)stringBuilder, null, (Buffer)this.getBuffer());
        } else {
            stringBuilder.append(this.data);
        }
        stringBuilder.append("]");
        return stringBuilder;
    }

    public String toString() {
        return this.toString(null).toString();
    }

    private void init(String string, int n, int n2, Object object) {
        if (2 > n || n > 4 || 2 > n2 || n2 > 4) {
            throw new GLException("rowsXcolumns must be within [2..4]X[2..4], is: " + n + "X" + n2);
        }
        this.name = string;
        this.rows = n;
        this.columns = n2;
        this.isMatrix = true;
        this.location = -1;
        this.init(object);
    }

    private void init(String string, int n, Object object) {
        if (1 > n || n > 4) {
            throw new GLException("components must be within [1..4], is: " + n);
        }
        this.name = string;
        this.columns = n;
        this.rows = 1;
        this.isMatrix = false;
        this.location = -1;
        this.init(object);
    }

    private void init(Object object) {
        if (object instanceof Buffer) {
            int n = this.rows * this.columns;
            Buffer buffer = (Buffer)object;
            if (buffer.remaining() < n || 0 != buffer.remaining() % n) {
                throw new GLException("remaining data buffer size invalid: buffer: " + buffer.toString() + "\n\t" + this);
            }
            this.count = buffer.remaining() / (this.rows * this.columns);
        } else {
            if (this.isMatrix) {
                throw new GLException("Atom type not allowed for matrix : " + this);
            }
            this.count = 1;
        }
        this.data = object;
    }

    public String getName() {
        return this.name;
    }

    public int getLocation() {
        return this.location;
    }

    public GLUniformData setLocation(int n) {
        this.location = n;
        return this;
    }

    public Object getObject() {
        return this.data;
    }

    public Buffer getBuffer() {
        return this.data instanceof Buffer ? (Buffer)this.data : null;
    }

    public boolean isBuffer() {
        return this.data instanceof Buffer;
    }

    public boolean isMatrix() {
        return this.isMatrix;
    }

    public int count() {
        return this.count;
    }

    public int components() {
        return this.rows * this.columns;
    }

    public int rows() {
        return this.rows;
    }

    public int columns() {
        return this.columns;
    }
}

