/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.annotation.evaluation.datasets;

import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.VFS;
import org.openimaj.citation.annotation.Reference;
import org.openimaj.citation.annotation.ReferenceType;
import org.openimaj.data.DataUtils;
import org.openimaj.data.dataset.Dataset;
import org.openimaj.data.dataset.GroupedDataset;
import org.openimaj.data.dataset.ListBackedDataset;
import org.openimaj.data.dataset.ListDataset;
import org.openimaj.data.dataset.MapBackedDataset;
import org.openimaj.experiment.annotations.DatasetDescription;
import org.openimaj.image.annotation.evaluation.datasets.CIFARDataset;
import org.openimaj.image.annotation.evaluation.datasets.cifar.BinaryReader;

@Reference(type=ReferenceType.Article, author={"Krizhevsky, A.", "Hinton, G."}, title="Learning multiple layers of features from tiny images", year="2009", journal="Master's thesis, Department of Computer Science, University of Toronto", publisher="Citeseer")
@DatasetDescription(name="CIFAR-100", description="This dataset is just like CIFAR-10, except it has 100 classes containing 600 images each. There are 500 training images and 100 testing images per class. The 100 classes in the CIFAR-100 are grouped into 20 superclasses. Each image comes with a \"fine\" label (the class to which it belongs) and a \"coarse\" label (the superclass to which it belongs).", creator="Alex Krizhevsky, Vinod Nair, and Geoffrey Hinton", url="http://www.cs.toronto.edu/~kriz/cifar.html", downloadUrls={"http://datasets.openimaj.org/cifar/cifar-100-binary.tar.gz"})
public class CIFAR100Dataset
extends CIFARDataset {
    private static final String DATA_TGZ = "cifar/cifar-100-binary.tar.gz";
    private static final String DOWNLOAD_URL = "http://datasets.openimaj.org/cifar/cifar-100-binary.tar.gz";
    private static final String TRAINING_FILE = "train.bin";
    private static final String TEST_FILE = "test.bin";
    private static final String FINE_CLASSES_FILE = "fine_label_names.txt";
    private static final String COARSE_CLASSES_FILE = "coarse_label_names.txt";

    private CIFAR100Dataset() {
    }

    private static String downloadAndGetPath() throws IOException {
        File dataset = DataUtils.getDataLocation((String)DATA_TGZ);
        if (!dataset.exists()) {
            dataset.getParentFile().mkdirs();
            FileUtils.copyURLToFile((URL)new URL(DOWNLOAD_URL), (File)dataset);
        }
        return "tgz:file:" + dataset.toString() + "!cifar-100-binary/";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <IMAGE> GroupedDataset<String, ListDataset<IMAGE>, IMAGE> getTrainingImages(BinaryReader<IMAGE> reader, boolean fineLabels) throws IOException {
        MapBackedDataset dataset = new MapBackedDataset();
        FileSystemManager fsManager = VFS.getManager();
        FileObject base = fsManager.resolveFile(CIFAR100Dataset.downloadAndGetPath());
        List<String> classList = CIFAR100Dataset.loadClasses(dataset, base, fineLabels);
        DataInputStream is = null;
        try {
            is = new DataInputStream(base.resolveFile(TRAINING_FILE).getContent().getInputStream());
            CIFAR100Dataset.loadData(is, dataset, classList, reader, 50000, fineLabels);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(is);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)is);
        return dataset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <IMAGE> List<String> loadClasses(MapBackedDataset<String, ListDataset<IMAGE>, IMAGE> dataset, FileObject base, boolean fine) throws FileSystemException, IOException {
        InputStream classStream = null;
        List classList = null;
        try {
            classStream = fine ? base.resolveFile(FINE_CLASSES_FILE).getContent().getInputStream() : base.resolveFile(COARSE_CLASSES_FILE).getContent().getInputStream();
            classList = IOUtils.readLines((InputStream)classStream);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(classStream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)classStream);
        for (String clz : classList) {
            dataset.put((Object)clz, (Dataset)new ListBackedDataset());
        }
        return classList;
    }

    private static <IMAGE> void loadData(DataInputStream is, MapBackedDataset<String, ListDataset<IMAGE>, IMAGE> dataset, List<String> classList, BinaryReader<IMAGE> reader, int num, boolean fine) throws IOException {
        for (int i = 0; i < num; ++i) {
            int coarseClz = is.read();
            int fineClz = is.read();
            int clz = fine ? fineClz : coarseClz;
            String clzStr = classList.get(clz);
            byte[] record = new byte[3072];
            is.readFully(record);
            ((ListDataset)dataset.get((Object)clzStr)).add(reader.read(record));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <IMAGE> GroupedDataset<String, ListDataset<IMAGE>, IMAGE> getTestImages(BinaryReader<IMAGE> reader, boolean fineLabels) throws IOException {
        MapBackedDataset dataset = new MapBackedDataset();
        FileSystemManager fsManager = VFS.getManager();
        FileObject base = fsManager.resolveFile(CIFAR100Dataset.downloadAndGetPath());
        List<String> classList = CIFAR100Dataset.loadClasses(dataset, base, fineLabels);
        DataInputStream is = null;
        try {
            is = new DataInputStream(base.resolveFile(TEST_FILE).getContent().getInputStream());
            CIFAR100Dataset.loadData(is, dataset, classList, reader, 10000, fineLabels);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(is);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)is);
        return dataset;
    }
}

