/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.math.signals;

import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.collection.FiniteCapacityBuffer;
import gov.sandia.cognition.evaluator.AbstractStatefulEvaluator;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.math.matrix.VectorFactory;
import gov.sandia.cognition.math.signals.DiscreteTimeFilter;

@PublicationReference(author={"Wikipedia"}, title="Finite impulse response", type=PublicationType.WebPage, year=2009, url="http://en.wikipedia.org/wiki/Finite_impulse_response")
public class MovingAverageFilter
extends AbstractStatefulEvaluator<Double, Double, FiniteCapacityBuffer<Double>>
implements DiscreteTimeFilter<FiniteCapacityBuffer<Double>> {
    private Vector movingAverageCoefficients;

    public MovingAverageFilter(int numCoefficients) {
        this(VectorFactory.getDefault().createVector(numCoefficients, 1.0 / (double)numCoefficients));
    }

    public MovingAverageFilter(double ... coefficients) {
        this(VectorFactory.getDefault().copyArray(coefficients));
    }

    public MovingAverageFilter(Vector movingAverageCoefficients) {
        this.setMovingAverageCoefficients(movingAverageCoefficients);
    }

    @Override
    public FiniteCapacityBuffer<Double> createDefaultState() {
        return new FiniteCapacityBuffer<Double>(this.getNumMovingAverageCoefficients());
    }

    @Override
    public Double evaluate(Double input) {
        double sum = 0.0;
        ((FiniteCapacityBuffer)this.getState()).addFirst(input);
        int n = 0;
        for (Double xn : (FiniteCapacityBuffer)this.getState()) {
            double an = this.getMovingAverageCoefficients().getElement(n);
            sum += an * xn;
            ++n;
        }
        return sum;
    }

    @Override
    public MovingAverageFilter clone() {
        MovingAverageFilter clone = (MovingAverageFilter)super.clone();
        clone.setMovingAverageCoefficients(this.getMovingAverageCoefficients().clone());
        return clone;
    }

    @Override
    public Vector convertToVector() {
        return this.getMovingAverageCoefficients();
    }

    @Override
    public void convertFromVector(Vector parameters) {
        if (this.getNumMovingAverageCoefficients() != parameters.getDimensionality()) {
            throw new IllegalArgumentException("Wrong number of parameters!");
        }
        this.setMovingAverageCoefficients(parameters);
    }

    public int getNumMovingAverageCoefficients() {
        return this.getMovingAverageCoefficients() == null ? 0 : this.getMovingAverageCoefficients().getDimensionality();
    }

    public Vector getMovingAverageCoefficients() {
        return this.movingAverageCoefficients;
    }

    public void setMovingAverageCoefficients(Vector movingAverageCoefficients) {
        this.movingAverageCoefficients = movingAverageCoefficients;
    }
}

