/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.math.matrix.mtj.decomposition;

import gov.sandia.cognition.annotation.CodeReview;
import gov.sandia.cognition.annotation.CodeReviewResponse;
import gov.sandia.cognition.math.OperationNotConvergedException;
import gov.sandia.cognition.math.matrix.Matrix;
import gov.sandia.cognition.math.matrix.decomposition.AbstractSingularValueDecomposition;
import gov.sandia.cognition.math.matrix.mtj.DenseMatrix;
import gov.sandia.cognition.math.matrix.mtj.DenseMatrixFactoryMTJ;
import no.uib.cipr.matrix.NotConvergedException;
import no.uib.cipr.matrix.SVD;

@CodeReview(reviewer={"Justin Basilico"}, date="2006-07-27", changesNeeded=true, comments={"The constructor should be changed to a static method because it involves significant computation."}, response={@CodeReviewResponse(respondent="Kevin R. Dixon", date="2007-11-25", moreChangesNeeded=false, comments={"Added static create() method, made constructor private"})})
public class SingularValueDecompositionMTJ
extends AbstractSingularValueDecomposition {
    public static SingularValueDecompositionMTJ create(Matrix matrix) throws OperationNotConvergedException {
        DenseMatrix denseMatrix = DenseMatrixFactoryMTJ.INSTANCE.copyMatrix(matrix);
        return new SingularValueDecompositionMTJ(denseMatrix);
    }

    private SingularValueDecompositionMTJ(DenseMatrix matrix) throws OperationNotConvergedException {
        int numRows = matrix.getNumRows();
        int numColumns = matrix.getNumColumns();
        SVD internalSVD = new SVD(numRows, numColumns);
        try {
            internalSVD.factor(new no.uib.cipr.matrix.DenseMatrix(matrix.getInternalMatrix()));
        }
        catch (NotConvergedException e) {
            throw new OperationNotConvergedException(e.getMessage());
        }
        DenseMatrixFactoryMTJ matrixFactory = DenseMatrixFactoryMTJ.INSTANCE;
        DenseMatrix U = matrixFactory.createWrapper(internalSVD.getU());
        double[] singularValues = internalSVD.getS();
        int numSingular = singularValues.length;
        DenseMatrix S = matrixFactory.createMatrix(numRows, numColumns);
        for (int i = 0; i < numSingular; ++i) {
            S.setElement(i, i, singularValues[i]);
        }
        DenseMatrix Vtranspose = matrixFactory.createWrapper(internalSVD.getVt());
        this.setU(U);
        this.setS(S);
        this.setVtranspose(Vtranspose);
    }
}

