/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.math.matrix.mtj;

import gov.sandia.cognition.math.matrix.TwoMatrixEntry;
import gov.sandia.cognition.math.matrix.mtj.AbstractMTJMatrix;

public class TwoMatrixEntryMTJ
implements TwoMatrixEntry {
    private AbstractMTJMatrix firstMatrix = null;
    private AbstractMTJMatrix secondMatrix = null;
    private int rowIndex;
    private int columnIndex;

    public TwoMatrixEntryMTJ(AbstractMTJMatrix firstMatrix, AbstractMTJMatrix secondMatrix) {
        this(firstMatrix, secondMatrix, 0, 0);
    }

    public TwoMatrixEntryMTJ(AbstractMTJMatrix firstMatrix, AbstractMTJMatrix secondMatrix, int rowIndex, int columnIndex) {
        this.setFirstMatrix(firstMatrix);
        this.setSecondMatrix(secondMatrix);
        this.setRowIndex(rowIndex);
        this.setColumnIndex(columnIndex);
    }

    @Override
    public int getColumnIndex() {
        return this.columnIndex;
    }

    @Override
    public void setColumnIndex(int columnIndex) {
        this.columnIndex = columnIndex;
    }

    @Override
    public int getRowIndex() {
        return this.rowIndex;
    }

    @Override
    public void setRowIndex(int rowIndex) {
        this.rowIndex = rowIndex;
    }

    public AbstractMTJMatrix getFirstMatrix() {
        return this.firstMatrix;
    }

    public void setFirstMatrix(AbstractMTJMatrix firstMatrix) {
        this.firstMatrix = firstMatrix;
    }

    public AbstractMTJMatrix getSecondMatrix() {
        return this.secondMatrix;
    }

    public void setSecondMatrix(AbstractMTJMatrix secondMatrix) {
        this.secondMatrix = secondMatrix;
    }

    @Override
    public double getFirstValue() {
        return this.getFirstMatrix().getElement(this.getRowIndex(), this.getColumnIndex());
    }

    @Override
    public void setFirstValue(double value) {
        this.getFirstMatrix().setElement(this.getRowIndex(), this.getColumnIndex(), value);
    }

    @Override
    public double getSecondValue() {
        return this.getSecondMatrix().getElement(this.getRowIndex(), this.getColumnIndex());
    }

    @Override
    public void setSecondValue(double value) {
        this.getSecondMatrix().setElement(this.getRowIndex(), this.getColumnIndex(), value);
    }
}

