/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.math.matrix.mtj;

import gov.sandia.cognition.annotation.CodeReview;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.math.matrix.VectorEntry;
import gov.sandia.cognition.math.matrix.mtj.AbstractMTJVector;
import gov.sandia.cognition.math.matrix.mtj.SparseRowMatrix;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

@CodeReview(reviewer={"Justin Basilico"}, date="2006-07-27", changesNeeded=false, comments={"Looks good."})
public class SparseVector
extends AbstractMTJVector {
    protected SparseVector(int numDimensions) {
        this(numDimensions, 0);
    }

    protected SparseVector(int numDimensions, int initialNonZeros) {
        this(new no.uib.cipr.matrix.sparse.SparseVector(numDimensions, initialNonZeros));
    }

    protected SparseVector(no.uib.cipr.matrix.sparse.SparseVector internalVector) {
        super((no.uib.cipr.matrix.Vector)internalVector);
    }

    protected SparseVector(Vector vector) {
        this(vector.getDimensionality());
        for (VectorEntry e : vector) {
            double value = e.getValue();
            if (value == 0.0) continue;
            this.setElement(e.getIndex(), value);
        }
    }

    public int getNumElementsUsed() {
        return this.getInternalVector().getUsed();
    }

    @Override
    public void setElement(int index, double value) {
        double existing = this.getElement(index);
        if (existing != value) {
            super.setElement(index, value);
        }
    }

    protected no.uib.cipr.matrix.sparse.SparseVector getInternalVector() {
        return (no.uib.cipr.matrix.sparse.SparseVector)super.getInternalVector();
    }

    protected void setInternalVector(no.uib.cipr.matrix.sparse.SparseVector internalVector) {
        super.setInternalVector((no.uib.cipr.matrix.Vector)internalVector);
    }

    @Override
    public SparseRowMatrix outerProduct(AbstractMTJVector other) {
        int numRows = this.getDimensionality();
        int numColumns = other.getDimensionality();
        SparseRowMatrix result = new SparseRowMatrix(numRows, numColumns);
        for (VectorEntry e : this) {
            int i = e.getIndex();
            for (VectorEntry o : other) {
                int j = o.getIndex();
                result.setElement(i, j, e.getValue() * o.getValue());
            }
        }
        return result;
    }

    @Override
    public String toString() {
        StringBuffer result = new StringBuffer();
        for (VectorEntry e : this) {
            result.append("(" + e.getIndex() + "): " + e.getValue() + "\n");
        }
        return result.toString();
    }

    public void compact() {
        this.getInternalVector().compact();
    }

    @Override
    public SparseVector stack(Vector other) {
        int d1 = this.getDimensionality();
        int d2 = other.getDimensionality();
        SparseVector stacked = new SparseVector(d1 + d2);
        for (VectorEntry e : this) {
            stacked.setElement(e.getIndex(), e.getValue());
        }
        for (VectorEntry e : other) {
            stacked.setElement(d1 + e.getIndex(), e.getValue());
        }
        return stacked;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.compact();
        out.defaultWriteObject();
        int dimensionality = this.getDimensionality();
        int[] index = this.getInternalVector().getIndex();
        double[] data = this.getInternalVector().getData();
        out.writeObject(dimensionality);
        out.writeObject(index);
        out.writeObject(data);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        int dimensionality = (Integer)in.readObject();
        int[] index = (int[])in.readObject();
        double[] data = (double[])in.readObject();
        boolean deepCopy = false;
        this.setInternalVector(new no.uib.cipr.matrix.sparse.SparseVector(dimensionality, index, data, deepCopy));
        this.compact();
    }

    @Override
    public SparseVector subVector(int minIndex, int maxIndex) {
        int M = maxIndex - minIndex + 1;
        SparseVector subvector = new SparseVector(M);
        for (int i = 0; i < M; ++i) {
            double value = this.getElement(i + minIndex);
            if (value == 0.0) continue;
            subvector.setElement(i, value);
        }
        return subvector;
    }
}

