/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.math.matrix.mtj;

import gov.sandia.cognition.annotation.CodeReview;
import gov.sandia.cognition.math.matrix.Matrix;
import gov.sandia.cognition.math.matrix.MatrixEntry;
import gov.sandia.cognition.math.matrix.mtj.AbstractMTJMatrix;
import gov.sandia.cognition.math.matrix.mtj.AbstractSparseMatrix;
import gov.sandia.cognition.math.matrix.mtj.SparseRowMatrix;
import gov.sandia.cognition.math.matrix.mtj.SparseVector;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import no.uib.cipr.matrix.sparse.FlexCompColMatrix;

@CodeReview(reviewer={"Justin Basilico"}, date="2006-07-27", changesNeeded=false, comments={"Looks good."})
public class SparseColumnMatrix
extends AbstractSparseMatrix {
    protected SparseColumnMatrix(int numRows, int numColumns) {
        this(new FlexCompColMatrix(numRows, numColumns));
        if (numRows < 0) {
            throw new IllegalArgumentException("Num rows must be >= 0");
        }
        if (numColumns < 0) {
            throw new IllegalArgumentException("Num columns must be >= 0");
        }
    }

    protected SparseColumnMatrix(SparseColumnMatrix matrix) {
        this(matrix.getInternalMatrix().copy());
    }

    protected SparseColumnMatrix(Matrix matrix) {
        this(matrix.getNumRows(), matrix.getNumColumns());
        for (MatrixEntry e : matrix) {
            double value = e.getValue();
            if (value == 0.0) continue;
            this.setElement(e.getRowIndex(), e.getColumnIndex(), value);
        }
    }

    protected SparseColumnMatrix(FlexCompColMatrix internalMatrix) {
        super((no.uib.cipr.matrix.Matrix)internalMatrix);
    }

    public FlexCompColMatrix getInternalMatrix() {
        return (FlexCompColMatrix)super.getInternalMatrix();
    }

    @Override
    public SparseColumnMatrix times(AbstractMTJMatrix matrix) {
        int returnRows = this.getNumRows();
        int returnColumns = matrix.getNumColumns();
        SparseColumnMatrix result = new SparseColumnMatrix(returnRows, returnColumns);
        this.getInternalMatrix().mult(matrix.getInternalMatrix(), (no.uib.cipr.matrix.Matrix)result.getInternalMatrix());
        return result;
    }

    @Override
    public SparseColumnMatrix getSubMatrix(int minRow, int maxRow, int minColumn, int maxColumn) {
        if (minRow > maxRow) {
            throw new IllegalArgumentException("minRow > maxRow");
        }
        if (minColumn > maxColumn) {
            throw new IllegalArgumentException("minColumn > maxColumn");
        }
        int numRows = maxRow - minRow + 1;
        int numColumns = maxColumn - minColumn + 1;
        SparseColumnMatrix submatrix = new SparseColumnMatrix(numRows, numColumns);
        this.getSubMatrixInto(minRow, maxRow, minColumn, maxColumn, submatrix);
        return submatrix;
    }

    @Override
    public SparseVector getColumn(int columnIndex) {
        return new SparseVector(this.getInternalMatrix().getColumn(columnIndex));
    }

    public void setColumn(int columnIndex, SparseVector columnVector) {
        this.getInternalMatrix().setColumn(columnIndex, columnVector.getInternalVector());
    }

    @Override
    public SparseRowMatrix transpose() {
        SparseRowMatrix result = new SparseRowMatrix(this.getNumColumns(), this.getNumRows());
        this.transposeInto(result);
        return result;
    }

    @Override
    public void compact() {
        this.getInternalMatrix().compact();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        int numRows = in.readInt();
        int numCols = in.readInt();
        this.setInternalMatrix((no.uib.cipr.matrix.Matrix)new FlexCompColMatrix(numRows, numCols));
        for (int i = 0; i < numCols; ++i) {
            SparseVector col = (SparseVector)in.readObject();
            this.setColumn(i, col);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        int numRows = this.getNumRows();
        int numCols = this.getNumColumns();
        out.writeInt(numRows);
        out.writeInt(numCols);
        for (int i = 0; i < numCols; ++i) {
            out.writeObject(this.getColumn(i));
        }
    }
}

