/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.math.matrix.mtj;

import gov.sandia.cognition.annotation.CodeReview;
import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.annotation.SoftwareLicenseType;
import gov.sandia.cognition.annotation.SoftwareReference;
import gov.sandia.cognition.math.matrix.AbstractVector;
import gov.sandia.cognition.math.matrix.Matrix;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.math.matrix.VectorEntry;
import gov.sandia.cognition.math.matrix.mtj.AbstractMTJMatrix;
import gov.sandia.cognition.math.matrix.mtj.DenseVector;
import gov.sandia.cognition.util.AbstractCloneableSerializable;
import java.io.Serializable;
import java.util.Iterator;
import no.uib.cipr.matrix.Vector;

@CodeReview(reviewer={"Jonathan McClain"}, date="2006-05-19", changesNeeded=false, comments={"Comments marked throughout the file with / / / on first column."})
@PublicationReference(author={"Bjorn-Ove Heimsund"}, title="Matrix Toolkits for Java (MTJ)", type=PublicationType.WebPage, year=2006, url="http://ressim.berlios.de/", notes={"All subclasses essentially wrap one of MTJ's vector classes."})
@SoftwareReference(name="Matrix Toolkits for Java (MTJ)", version="0.9.6", url="http://ressim.berlios.de/", license=SoftwareLicenseType.LGPL, licenseVersion="2.1", licenseURL="http://ressim.berlios.de/")
public abstract class AbstractMTJVector
extends AbstractVector
implements Serializable {
    private transient no.uib.cipr.matrix.Vector internalVector;

    protected AbstractMTJVector(no.uib.cipr.matrix.Vector internalVector) {
        this.internalVector = internalVector;
    }

    @Override
    public AbstractMTJVector clone() {
        AbstractMTJVector clone = (AbstractMTJVector)super.clone();
        clone.setInternalVector(this.getInternalVector().copy());
        return clone;
    }

    @Override
    public int getDimensionality() {
        return this.internalVector.size();
    }

    @Override
    public double getElement(int index) {
        return this.internalVector.get(index);
    }

    @Override
    public void setElement(int index, double value) {
        this.internalVector.set(index, value);
    }

    @Override
    public Vector times(Matrix matrix) {
        return this.times((AbstractMTJMatrix)matrix);
    }

    public Vector times(AbstractMTJMatrix matrix) {
        int N = matrix.getNumColumns();
        DenseVector retval = new DenseVector(N);
        matrix.getInternalMatrix().transMult(this.getInternalVector(), retval.getInternalVector());
        return retval;
    }

    protected no.uib.cipr.matrix.Vector getInternalVector() {
        return this.internalVector;
    }

    protected void setInternalVector(no.uib.cipr.matrix.Vector internalVector) {
        this.internalVector = internalVector;
    }

    @Override
    public double norm2() {
        return this.internalVector.norm(Vector.Norm.Two);
    }

    @Override
    public double norm2Squared() {
        double norm = this.norm2();
        return norm * norm;
    }

    @Override
    public void plusEquals(Vector other) {
        this.plusEquals((AbstractMTJVector)other);
    }

    @Override
    public void plusEquals(AbstractMTJVector other) {
        this.internalVector.add(other.internalVector);
    }

    @Override
    public void minusEquals(Vector other) {
        this.minusEquals((AbstractMTJVector)other);
    }

    @Override
    public void minusEquals(AbstractMTJVector other) {
        this.internalVector.add(-1.0, other.internalVector);
    }

    @Override
    public double dotProduct(Vector other) {
        return this.dotProduct((AbstractMTJVector)other);
    }

    public double dotProduct(AbstractMTJVector other) {
        this.assertSameDimensionality(other);
        return this.internalVector.dot(other.internalVector);
    }

    @Override
    public void dotTimesEquals(Vector other) {
        for (VectorEntry entry : this) {
            entry.setValue(entry.getValue() * other.getElement(entry.getIndex()));
        }
    }

    @Override
    public void scaleEquals(double scaleFactor) {
        this.internalVector.scale(scaleFactor);
    }

    @Override
    public Iterator<VectorEntry> iterator() {
        return new AbstractMTJVectorIterator();
    }

    @Override
    public void zero() {
        this.internalVector.zero();
    }

    @Override
    public AbstractMTJMatrix outerProduct(Vector other) {
        return this.outerProduct((AbstractMTJVector)other);
    }

    public abstract AbstractMTJMatrix outerProduct(AbstractMTJVector var1);

    class AbstractMTJVectorEntry
    extends AbstractCloneableSerializable
    implements VectorEntry {
        private int index;

        public AbstractMTJVectorEntry() {
            this(0);
        }

        public AbstractMTJVectorEntry(int index) {
            this.setIndex(index);
        }

        @Override
        public double getValue() {
            return AbstractMTJVector.this.getElement(this.getIndex());
        }

        @Override
        public void setValue(double value) {
            AbstractMTJVector.this.setElement(this.getIndex(), value);
        }

        @Override
        public int getIndex() {
            return this.index;
        }

        @Override
        public void setIndex(int index) {
            this.index = index;
        }
    }

    class AbstractMTJVectorIterator
    extends AbstractCloneableSerializable
    implements Iterator<VectorEntry> {
        private Iterator<no.uib.cipr.matrix.VectorEntry> internalIterator;
        private VectorEntry entry;

        public AbstractMTJVectorIterator() {
            this.setInternalIterator(AbstractMTJVector.this.internalVector.iterator());
            this.setEntry(new AbstractMTJVectorEntry());
        }

        protected Iterator<no.uib.cipr.matrix.VectorEntry> getInternalIterator() {
            return this.internalIterator;
        }

        protected void setInternalIterator(Iterator<no.uib.cipr.matrix.VectorEntry> internalIterator) {
            this.internalIterator = internalIterator;
        }

        @Override
        public boolean hasNext() {
            return this.getInternalIterator().hasNext();
        }

        @Override
        public VectorEntry next() {
            no.uib.cipr.matrix.VectorEntry internalNext = this.getInternalIterator().next();
            this.getEntry().setIndex(internalNext.index());
            return this.getEntry();
        }

        @Override
        public void remove() {
            this.getInternalIterator().remove();
        }

        public VectorEntry getEntry() {
            return this.entry;
        }

        public void setEntry(VectorEntry entry) {
            this.entry = entry;
        }
    }
}

