/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.math.matrix;

import gov.sandia.cognition.math.matrix.SparseVectorFactory;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.math.matrix.Vector1D;
import gov.sandia.cognition.math.matrix.Vector2D;
import gov.sandia.cognition.math.matrix.Vector3D;
import gov.sandia.cognition.math.matrix.mtj.DenseVectorFactoryMTJ;
import gov.sandia.cognition.math.matrix.mtj.SparseVectorFactoryMTJ;
import java.io.Serializable;
import java.util.Collection;
import java.util.Random;

public abstract class VectorFactory<VectorType extends Vector>
implements Serializable {
    protected static final VectorFactory<? extends Vector> DEFAULT_DENSE_INSTANCE = new DenseVectorFactoryMTJ();
    protected static final SparseVectorFactory<? extends Vector> DEFAULT_SPARSE_INSTANCE = new SparseVectorFactoryMTJ();

    protected VectorFactory() {
    }

    public static VectorFactory<? extends Vector> getDefault() {
        return DEFAULT_DENSE_INSTANCE;
    }

    public static VectorFactory<? extends Vector> getDenseDefault() {
        return DEFAULT_DENSE_INSTANCE;
    }

    public static SparseVectorFactory<? extends Vector> getSparseDefault() {
        return DEFAULT_SPARSE_INSTANCE;
    }

    public abstract VectorType copyVector(Vector var1);

    public VectorType copyArray(double[] values) {
        VectorType v = this.createVector(values.length);
        for (int i = 0; i < v.getDimensionality(); ++i) {
            double value = values[i];
            if (value == 0.0) continue;
            v.setElement(i, value);
        }
        return v;
    }

    public VectorType copyValues(double ... values) {
        return this.copyArray(values);
    }

    public VectorType copyValues(Collection<? extends Number> values) {
        VectorType v = this.createVector(values.size());
        int index = 0;
        for (Number number : values) {
            v.setElement(index, number.doubleValue());
            ++index;
        }
        return v;
    }

    public abstract VectorType createVector(int var1);

    public Vector1D createVector1D() {
        return this.createVector1D(0.0);
    }

    public abstract Vector1D createVector1D(double var1);

    public Vector2D createVector2D() {
        return this.createVector2D(0.0, 0.0);
    }

    public abstract Vector2D createVector2D(double var1, double var3);

    public Vector3D createVector3D() {
        return this.createVector3D(0.0, 0.0, 0.0);
    }

    public abstract Vector3D createVector3D(double var1, double var3, double var5);

    public VectorType createUniformRandom(int dim, double min, double max, Random random) {
        VectorType v = this.createVector(dim);
        for (int i = 0; i < v.getDimensionality(); ++i) {
            double uniform = random.nextDouble();
            double value = (max - min) * uniform + min;
            v.setElement(i, value);
        }
        return v;
    }

    public VectorType createVector(int dimensionality, double initialValue) {
        VectorType vector = this.createVector(dimensionality);
        if (initialValue != 0.0) {
            for (int i = 0; i < dimensionality; ++i) {
                vector.setElement(i, initialValue);
            }
        }
        return vector;
    }

    public VectorType copyArray(int dimensionality, int[] indices, double[] values) {
        int length = indices.length;
        if (length != values.length) {
            throw new IllegalArgumentException("indices and values must have the same length");
        }
        VectorType result = this.createVector(dimensionality);
        for (int i = 0; i < length; ++i) {
            double value = values[i];
            if (value == 0.0) continue;
            result.setElement(indices[i], value);
        }
        return result;
    }
}

