/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.math.matrix;

import gov.sandia.cognition.annotation.CodeReview;
import gov.sandia.cognition.annotation.CodeReviewResponse;
import gov.sandia.cognition.annotation.CodeReviews;
import gov.sandia.cognition.math.AbstractRing;
import gov.sandia.cognition.math.RingAccumulator;
import gov.sandia.cognition.math.matrix.DimensionalityMismatchException;
import gov.sandia.cognition.math.matrix.Matrix;
import gov.sandia.cognition.math.matrix.MatrixEntry;
import gov.sandia.cognition.math.matrix.Vector;

@CodeReviews(reviews={@CodeReview(reviewer={"Kevin R. Dixon"}, date="2008-02-26", changesNeeded=false, comments={"Minor changes to formatting and documentation for equals().", "Otherwise, looks good."}), @CodeReview(reviewer={"Jonathan McClain"}, date="2006-05-16", changesNeeded=true, comments={"A few minor changes."}, response={@CodeReviewResponse(respondent="Justin Basilico", date="2006-05-16", moreChangesNeeded=false, comments={"Added a line to the class documentation that says that setElement is used extensively in the abstract implementation."})})})
public abstract class AbstractMatrix
extends AbstractRing<Matrix>
implements Matrix {
    @Override
    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (other instanceof Matrix) {
            return this.equals((Matrix)other, 0.0);
        }
        return false;
    }

    @Override
    public boolean equals(Matrix other, double effectiveZero) {
        int M = this.getNumRows();
        int N = this.getNumColumns();
        for (int i = 0; i < M; ++i) {
            for (int j = 0; j < N; ++j) {
                double difference = this.getElement(i, j) - other.getElement(i, j);
                if (!(Math.abs(difference) > effectiveZero)) continue;
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int numRows = this.getNumRows();
        int numColumns = this.getNumColumns();
        int result = 7 + numRows * numColumns;
        for (int i = 0; i < numRows; ++i) {
            for (int j = 0; j < numColumns; ++j) {
                double value = this.getElement(i, j);
                if (value == 0.0) continue;
                long bits = Double.doubleToLongBits(value);
                result = 47 * result + i ^ j ^ (int)(bits ^ bits >>> 32);
            }
        }
        return result;
    }

    @Override
    public boolean isSymmetric() {
        return this.isSymmetric(0.0);
    }

    @Override
    public boolean checkSameDimensions(Matrix otherMatrix) {
        return this.getNumRows() == otherMatrix.getNumRows() && this.getNumColumns() == otherMatrix.getNumColumns();
    }

    @Override
    public void assertSameDimensions(Matrix other) {
        if (!this.checkSameDimensions(other)) {
            throw new DimensionalityMismatchException("Matrices must have same dimensions: (" + this.getNumRows() + "x" + this.getNumColumns() + ") !=" + "(" + other.getNumRows() + "x" + other.getNumColumns() + ")");
        }
    }

    @Override
    public boolean checkMultiplicationDimensions(Matrix postMultiplicationMatrix) {
        return this.getNumColumns() == postMultiplicationMatrix.getNumRows();
    }

    @Override
    public double trace() {
        int N;
        if (!this.isSquare()) {
            throw new DimensionalityMismatchException("Matrix must be square for trace()");
        }
        int M = this.getNumRows();
        int D = M < (N = this.getNumColumns()) ? M : N;
        double diagonal_sum = 0.0;
        for (int i = 0; i < D; ++i) {
            diagonal_sum += this.getElement(i, i);
        }
        return diagonal_sum;
    }

    @Override
    public void setSubMatrix(int minRow, int minColumn, Matrix submatrix) {
        int M = submatrix.getNumRows();
        int N = submatrix.getNumColumns();
        for (int i = 0; i < M; ++i) {
            int setRow = minRow + i;
            for (int j = 0; j < N; ++j) {
                double v = submatrix.getElement(i, j);
                if (v == 0.0) continue;
                this.setElement(setRow, minColumn + j, v);
            }
        }
    }

    @Override
    public int rank() {
        return this.rank(0.0);
    }

    @Override
    public Matrix pseudoInverse() {
        return this.pseudoInverse(0.0);
    }

    @Override
    public void setColumn(int columnIndex, Vector columnVector) {
        int M = this.getNumRows();
        if (M != columnVector.getDimensionality()) {
            throw new DimensionalityMismatchException(M, columnVector.getDimensionality());
        }
        for (int i = 0; i < M; ++i) {
            this.setElement(i, columnIndex, columnVector.getElement(i));
        }
    }

    @Override
    public void setRow(int rowIndex, Vector rowVector) {
        int N = this.getNumColumns();
        if (N != rowVector.getDimensionality()) {
            throw new DimensionalityMismatchException(N, rowVector.getDimensionality());
        }
        for (int j = 0; j < N; ++j) {
            this.setElement(rowIndex, j, rowVector.getElement(j));
        }
    }

    protected void getColumnInto(int columnIndex, Vector destinationVector) {
        int M = this.getNumRows();
        if (M != destinationVector.getDimensionality()) {
            throw new DimensionalityMismatchException(M, destinationVector.getDimensionality());
        }
        for (int i = 0; i < M; ++i) {
            destinationVector.setElement(i, this.getElement(i, columnIndex));
        }
    }

    protected void getRowInto(int rowIndex, Vector destinationVector) {
        int N = this.getNumColumns();
        if (N != destinationVector.getDimensionality()) {
            throw new DimensionalityMismatchException(N, destinationVector.getDimensionality());
        }
        for (int j = 0; j < N; ++j) {
            destinationVector.setElement(j, this.getElement(rowIndex, j));
        }
    }

    @Override
    public Vector sumOfRows() {
        RingAccumulator<Vector> accumulator = new RingAccumulator<Vector>();
        int numRows = this.getNumRows();
        for (int i = 0; i < numRows; ++i) {
            accumulator.accumulate(this.getRow(i));
        }
        return (Vector)accumulator.getSum();
    }

    @Override
    public Vector sumOfColumns() {
        RingAccumulator<Vector> accumulator = new RingAccumulator<Vector>();
        int numColumns = this.getNumColumns();
        for (int j = 0; j < numColumns; ++j) {
            accumulator.accumulate(this.getColumn(j));
        }
        return (Vector)accumulator.getSum();
    }

    @Override
    public boolean isZero(double effectiveZero) {
        for (MatrixEntry e : this) {
            if (!(Math.abs(e.getValue()) > effectiveZero)) continue;
            return false;
        }
        return true;
    }
}

