/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.math.geometry;

import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationReferences;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.collection.CollectionUtil;
import gov.sandia.cognition.math.Metric;
import gov.sandia.cognition.math.matrix.Vectorizable;
import gov.sandia.cognition.math.matrix.VectorizableIndexComparator;
import gov.sandia.cognition.util.AbstractCloneableSerializable;
import gov.sandia.cognition.util.CloneableSerializable;
import gov.sandia.cognition.util.ObjectUtil;
import gov.sandia.cognition.util.Pair;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.PriorityQueue;

@PublicationReferences(references={@PublicationReference(author={"Andrew W. Moore"}, title="An intoductory tutorial on kd-trees", type=PublicationType.TechnicalReport, publication="University of Cambridge Computer Laboratory Technical Report No. 209", year=1991, url="http://www.autonlab.org/autonweb/14665.html?branch=1&language=2"), @PublicationReference(author={"Wikipedia"}, title="kd-tree", type=PublicationType.WebPage, year=2009, url="http://en.wikipedia.org/wiki/Kd-tree")})
public class KDTree<VectorType extends Vectorizable, DataType, PairType extends Pair<? extends VectorType, DataType>>
extends AbstractCollection<PairType>
implements CloneableSerializable {
    protected int num;
    protected PairType value;
    protected KDTree<VectorType, DataType, PairType> parent;
    protected KDTree<VectorType, DataType, PairType> leftChild;
    protected KDTree<VectorType, DataType, PairType> rightChild;
    protected PairFirstVectorizableIndexComparator comparator;

    public KDTree() {
        this(null, null, null);
        this.num = 0;
    }

    public KDTree(Collection<? extends PairType> points) {
        this(CollectionUtil.asArrayList(points), new PairFirstVectorizableIndexComparator(0), ((Vectorizable)((Pair)CollectionUtil.getFirst(points)).getFirst()).convertToVector().getDimensionality(), null);
    }

    protected KDTree(PairType value, PairFirstVectorizableIndexComparator comparator, KDTree<VectorType, DataType, PairType> parent) {
        this.num = 1;
        this.value = value;
        this.comparator = comparator;
        this.parent = parent;
        this.leftChild = null;
        this.rightChild = null;
    }

    protected KDTree(ArrayList<? extends PairType> points, PairFirstVectorizableIndexComparator comparator, int dimensionality, KDTree<VectorType, DataType, PairType> parent) {
        this.parent = parent;
        this.comparator = comparator;
        this.num = points.size();
        if (this.num <= 0) {
            throw new IllegalArgumentException("No points!");
        }
        if (this.num == 1) {
            this.value = (Pair)points.get(0);
        } else {
            int rightNum;
            int medianIndex = this.num / 2;
            int[] indices = CollectionUtil.findKthLargest(medianIndex, points, comparator);
            this.value = (Pair)points.get(indices[medianIndex]);
            int childAxis = (this.comparator.comparator.getIndex() + 1) % dimensionality;
            PairFirstVectorizableIndexComparator childComparator = new PairFirstVectorizableIndexComparator(childAxis);
            int leftNum = medianIndex;
            if (leftNum > 0) {
                ArrayList<PairType> leftPoints = new ArrayList<PairType>(leftNum);
                for (int i = 0; i < leftNum; ++i) {
                    leftPoints.add(points.get(indices[i]));
                }
                this.leftChild = new KDTree(leftPoints, childComparator, dimensionality, this);
            }
            if ((rightNum = this.num - medianIndex - 1) > 0) {
                ArrayList<PairType> rightPoints = new ArrayList<PairType>(rightNum);
                for (int i = medianIndex + 1; i < this.num; ++i) {
                    rightPoints.add(points.get(indices[i]));
                }
                this.rightChild = new KDTree(rightPoints, childComparator, dimensionality, this);
            }
        }
    }

    @Override
    public KDTree<VectorType, DataType, PairType> clone() {
        KDTree clone;
        try {
            clone = (KDTree)super.clone();
            clone.leftChild = ObjectUtil.cloneSafe(this.leftChild);
            clone.rightChild = ObjectUtil.cloneSafe(this.rightChild);
            clone.value = (Pair)ObjectUtil.cloneSmart(this.value);
            clone.parent = this.parent;
            clone.comparator = this.comparator;
        }
        catch (CloneNotSupportedException ex) {
            clone = null;
        }
        return clone;
    }

    public static <VectorType extends Vectorizable, DataType, PairType extends Pair<? extends VectorType, DataType>> KDTree<VectorType, DataType, PairType> createBalanced(Collection<? extends PairType> points) {
        return new KDTree<VectorType, DataType, PairType>(points);
    }

    public KDTree<VectorType, DataType, PairType> reblanace() {
        return KDTree.createBalanced(this);
    }

    @Override
    public boolean add(PairType point) {
        if (this.value == null) {
            this.num = 1;
            this.value = point;
            this.comparator = new PairFirstVectorizableIndexComparator(0);
        } else {
            ++this.num;
            int comparison = this.comparator.compare((Pair<? extends Vectorizable, ?>)point, (Pair<? extends Vectorizable, ?>)this.value);
            if (comparison <= 0) {
                if (this.leftChild == null) {
                    int dimension = ((Vectorizable)point.getFirst()).convertToVector().getDimensionality();
                    int childAxis = (this.comparator.comparator.getIndex() + 1) % dimension;
                    PairFirstVectorizableIndexComparator childComparator = new PairFirstVectorizableIndexComparator(childAxis);
                    this.leftChild = new KDTree<VectorType, DataType, PairType>(point, childComparator, this);
                } else {
                    this.leftChild.add(point);
                }
            } else if (this.rightChild == null) {
                int dimension = ((Vectorizable)point.getFirst()).convertToVector().getDimensionality();
                int childAxis = (this.comparator.comparator.getIndex() + 1) % dimension;
                PairFirstVectorizableIndexComparator childComparator = new PairFirstVectorizableIndexComparator(childAxis);
                this.rightChild = new KDTree<VectorType, DataType, PairType>(point, childComparator, this);
            } else {
                this.rightChild.add(point);
            }
        }
        return true;
    }

    @Override
    public int size() {
        return this.num;
    }

    @Override
    @PublicationReference(author={"Wikipedia"}, title="Tree traversal", type=PublicationType.WebPage, year=2009, url="http://en.wikipedia.org/wiki/Tree_traversal#Traversal")
    public Iterator<PairType> iterator() {
        return new InOrderKDTreeIterator(this);
    }

    @Override
    public String toString() {
        return this.toString("Head->");
    }

    protected String toString(String prefix) {
        String retval = prefix + " (" + this.value.getFirst() + " -> " + this.value.getSecond() + ")\n";
        if (this.leftChild != null) {
            retval = retval + this.leftChild.toString(prefix + "L");
        }
        if (this.rightChild != null) {
            retval = retval + this.rightChild.toString(prefix + "R");
        }
        return retval;
    }

    public Collection<PairType> findNearest(VectorType key, int k, Metric<? super VectorType> metric) {
        if (k < this.size()) {
            Neighborhood neighborhood = new Neighborhood(k);
            this.findNearest(key, k, neighborhood, metric);
            return neighborhood;
        }
        return this;
    }

    protected void findNearest(VectorType key, int k, Neighborhood<VectorType, DataType, PairType> neighborhood, Metric<? super VectorType> metric) {
        KDTree<? super VectorType, DataType, PairType> closer = null;
        KDTree<Object, DataType, PairType> further = null;
        if (this.leftChild != null || this.rightChild != null) {
            int comparison = this.comparator.comparator.compare((Vectorizable)key, (Vectorizable)this.value.getFirst());
            if (comparison <= 0) {
                closer = this.leftChild;
                further = this.rightChild;
            } else {
                closer = this.rightChild;
                further = this.leftChild;
            }
            if (closer != null) {
                closer.findNearest((VectorType)key, k, (Neighborhood<? super VectorType, DataType, PairType>)neighborhood, (Metric<? super VectorType>)metric);
            }
        }
        if (!neighborhood.isFull()) {
            double distance = metric.evaluate(this.value.getFirst(), key);
            neighborhood.add(this.value, distance);
            if (further != null) {
                further.findNearest(key, k, neighborhood, metric);
            }
        } else {
            double minimumDistance = this.computeMinimumDifference(key);
            if (minimumDistance < neighborhood.getFurthestNeighborDistance()) {
                double distance = metric.evaluate(this.value.getFirst(), key);
                neighborhood.offer(this.value, distance);
                if (further != null) {
                    further.findNearest(key, this.num, neighborhood, metric);
                }
            }
        }
    }

    protected double computeMinimumDifference(VectorType key) {
        int index = this.comparator.comparator.getIndex();
        double delta = key.convertToVector().getElement(index) - ((Vectorizable)this.value.getFirst()).convertToVector().getElement(index);
        return Math.abs(delta);
    }

    protected static class Neighborhood<VectorType extends Vectorizable, DataType, PairType extends Pair<? extends VectorType, DataType>>
    extends AbstractCollection<PairType> {
        private int k;
        PriorityQueue<Neighbor<VectorType, DataType, PairType>> priorityQueue;

        public Neighborhood(int k) {
            this.priorityQueue = new PriorityQueue(k);
            this.k = k;
        }

        public boolean isFull() {
            return this.size() >= this.k;
        }

        public double getFurthestNeighborDistance() {
            return ((Neighbor)this.priorityQueue.peek()).distance;
        }

        public void add(PairType value, double distance) {
            while (this.isFull()) {
                this.priorityQueue.remove();
            }
            this.priorityQueue.add(new Neighbor(this, value, distance));
        }

        public boolean offer(PairType value, double distance) {
            if (this.isFull() && distance < this.getFurthestNeighborDistance()) {
                this.priorityQueue.remove();
            }
            if (!this.isFull()) {
                this.add(value, distance);
                return true;
            }
            return false;
        }

        @Override
        public Iterator<PairType> iterator() {
            return new NeighborhoodIterator();
        }

        @Override
        public int size() {
            return this.priorityQueue.size();
        }

        protected class NeighborhoodIterator
        implements Iterator<PairType> {
            Iterator<Neighbor<VectorType, DataType, PairType>> priorityQueueIterator;

            public NeighborhoodIterator() {
                this.priorityQueueIterator = Neighborhood.this.priorityQueue.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.priorityQueueIterator.hasNext();
            }

            @Override
            public PairType next() {
                Neighbor next = this.priorityQueueIterator.next();
                return next.pair;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Not supported yet.");
            }
        }

        protected class Neighbor<VectorType extends Vectorizable, DataType, PairType extends Pair<? extends VectorType, DataType>>
        extends AbstractCloneableSerializable
        implements Comparable<Neighbor> {
            PairType pair;
            private double distance;
            final /* synthetic */ Neighborhood this$0;

            /*
             * WARNING - Possible parameter corruption
             * WARNING - void declaration
             */
            public Neighbor(PairType distance, double d2) {
                void value;
                this.this$0 = (Neighborhood)d;
                this.pair = value;
                this.distance = (double)distance;
            }

            @Override
            public int compareTo(Neighbor other) {
                return -Double.compare(this.distance, other.distance);
            }

            public boolean equals(Object obj) {
                if (obj == null) {
                    return false;
                }
                if (obj instanceof Neighbor) {
                    return ((Vectorizable)((Neighbor)obj).pair.getFirst()).convertToVector().equals(((Vectorizable)this.pair.getFirst()).convertToVector());
                }
                return false;
            }
        }
    }

    @PublicationReference(author={"Wikipedia"}, title="Tree traversal", type=PublicationType.WebPage, year=2009, url="http://en.wikipedia.org/wiki/Tree_traversal#Traversal")
    protected static class InOrderKDTreeIterator<VectorType extends Vectorizable, DataType, PairType extends Pair<? extends VectorType, DataType>>
    implements Iterator<PairType> {
        public PairType nodeValue;
        public InOrderKDTreeIterator<VectorType, DataType, PairType> leftIterator;
        public InOrderKDTreeIterator<VectorType, DataType, PairType> rightIterator;

        public InOrderKDTreeIterator(KDTree<VectorType, DataType, PairType> node) {
            if (node.leftChild != null) {
                this.leftIterator = new InOrderKDTreeIterator(node.leftChild);
            }
            if (node.rightChild != null) {
                this.rightIterator = new InOrderKDTreeIterator(node.rightChild);
            }
            this.nodeValue = node.value;
        }

        @Override
        public boolean hasNext() {
            return this.nodeValue != null || this.rightIterator != null && this.rightIterator.hasNext() || this.leftIterator != null && this.leftIterator.hasNext();
        }

        @Override
        public PairType next() {
            Object retval = null;
            if (this.leftIterator != null && this.leftIterator.hasNext()) {
                retval = this.leftIterator.next();
            } else {
                this.leftIterator = null;
                if (this.nodeValue != null) {
                    retval = this.nodeValue;
                    this.nodeValue = null;
                } else if (this.rightIterator != null) {
                    if (this.rightIterator.hasNext()) {
                        retval = this.rightIterator.next();
                    } else {
                        this.rightIterator = null;
                    }
                }
            }
            if (retval == null) {
                throw new IllegalArgumentException("Should not have called null since we have no values to iterate!");
            }
            return (PairType)retval;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    protected static class PairFirstVectorizableIndexComparator
    extends AbstractCloneableSerializable
    implements Comparator<Pair<? extends Vectorizable, ?>> {
        public VectorizableIndexComparator comparator;

        public PairFirstVectorizableIndexComparator(int index) {
            this.comparator = new VectorizableIndexComparator(index);
        }

        @Override
        public int compare(Pair<? extends Vectorizable, ?> o1, Pair<? extends Vectorizable, ?> o2) {
            return this.comparator.compare(o1.getFirst(), o2.getFirst());
        }
    }
}

