/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.io;

import gov.sandia.cognition.annotation.CodeReview;
import gov.sandia.cognition.annotation.CodeReviewResponse;
import gov.sandia.cognition.annotation.CodeReviews;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

@CodeReviews(reviews={@CodeReview(reviewer={"Kevin R. Dixon"}, date="2008-02-08", changesNeeded=false, comments={"Added some calls to close() after Streams were done.", "Minor cosmetic changes.", "Otherwise, looks fine."}), @CodeReview(reviewer={"Jonathan McClain"}, date="2006-05-11", changesNeeded=true, comments={"A few undocumented behaviors, and one bug."}, response={@CodeReviewResponse(respondent="Justin Basilico", date="2006-05-16", comments={"Bug fixed."}, moreChangesNeeded=false)})})
public class ObjectSerializationHandler {
    public static byte[] convertToBytes(Serializable object) throws IOException {
        byte[] byteArray = null;
        if (object != null) {
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(byteStream);
            out.writeObject(object);
            out.flush();
            out.close();
            byteArray = byteStream.toByteArray();
        }
        return byteArray;
    }

    public static Object convertFromBytes(byte[] serialized) throws IOException, ClassNotFoundException {
        if (serialized == null) {
            return null;
        }
        ByteArrayInputStream byteStream = new ByteArrayInputStream(serialized);
        ObjectInputStream in = new ObjectInputStream(byteStream);
        Object read = in.readObject();
        if (byteStream.available() > 0) {
            throw new IOException("There was more than the object in the given byte array.");
        }
        in.close();
        byteStream.close();
        return read;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object readFromFile(File file) throws ClassNotFoundException, IOException {
        Object read = null;
        if (file != null) {
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
            try {
                read = ObjectSerializationHandler.readFromStream(in);
            }
            finally {
                in.close();
            }
        }
        return read;
    }

    public static Object readFromStream(BufferedInputStream stream) throws ClassNotFoundException, IOException {
        Object read = null;
        if (stream != null) {
            ObjectInputStream in = new ObjectInputStream(stream);
            read = in.readObject();
            in.close();
        }
        return read;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeObjectToFile(File file, Serializable object) throws IOException {
        if (file == null) {
            throw new IOException("File is null!");
        }
        if (object != null) {
            ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(file));
            try {
                out.writeObject(object);
                out.flush();
            }
            finally {
                out.close();
            }
        }
    }
}

