/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.evaluator;

import gov.sandia.cognition.evaluator.Evaluator;
import gov.sandia.cognition.util.AbstractCloneableSerializable;
import gov.sandia.cognition.util.ObjectUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

public class CompositeEvaluatorList<InputType, OutputType>
extends AbstractCloneableSerializable
implements Evaluator<InputType, OutputType> {
    private ArrayList<Evaluator> evaluators;

    public CompositeEvaluatorList() {
        this(new ArrayList());
    }

    public CompositeEvaluatorList(Evaluator ... evaluatorsArray) {
        this(Arrays.asList(evaluatorsArray));
    }

    public CompositeEvaluatorList(Collection<? extends Evaluator> evaluators) {
        this.setEvaluators(evaluators);
    }

    @Override
    public CompositeEvaluatorList<InputType, OutputType> clone() {
        CompositeEvaluatorList result = (CompositeEvaluatorList)super.clone();
        result.evaluators = ObjectUtil.cloneSmartElementsAsArrayList(this.evaluators);
        return result;
    }

    @Override
    public OutputType evaluate(InputType input) {
        Object value = input;
        for (Evaluator evaluator : this.evaluators) {
            value = evaluator.evaluate(value);
        }
        return (OutputType)value;
    }

    public ArrayList<Evaluator> getEvaluators() {
        return this.evaluators;
    }

    public void setEvaluators(Collection<? extends Evaluator> evaluators) {
        this.evaluators = new ArrayList<Evaluator>(evaluators);
    }

    public void setEvaluators(Evaluator ... evaluatorsArray) {
        this.setEvaluators(Arrays.asList(evaluatorsArray));
    }
}

