/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.collection;

import gov.sandia.cognition.annotation.CodeReview;
import gov.sandia.cognition.annotation.CodeReviewResponse;
import gov.sandia.cognition.annotation.CodeReviews;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;

@CodeReviews(reviews={@CodeReview(reviewer={"Kevin R. Dixon"}, date="2008-02-08", changesNeeded=false, comments={"Interface looks fine."}), @CodeReview(reviewer={"Kevin R. Dixon"}, date="2006-07-18", changesNeeded=true, comments={"Non-standard use of direct-member access, instead of getters and setters. Please review."}, response={@CodeReviewResponse(respondent="Justin Basilico", date="2006-08-17", moreChangesNeeded=false, comments={"Updated comments to indicate that it does not use getters"})})})
public class MultiIterator<EntryType>
implements Iterator<EntryType>,
Serializable {
    private Iterator<EntryType> currentIterator;
    private LinkedList<Iterator<EntryType>> remainingIterators;

    public MultiIterator(Collection<? extends Iterable<EntryType>> iterables) {
        LinkedList<Iterator<EntryType>> iterators = new LinkedList<Iterator<EntryType>>();
        for (Iterable<EntryType> iterable : iterables) {
            iterators.add(iterable.iterator());
        }
        Iterator iterator = null;
        if (!iterators.isEmpty()) {
            iterator = (Iterator)iterators.removeFirst();
        }
        this.setCurrentIterator(iterator);
        this.setRemainingIterators(iterators);
        this.findNextValidIterator();
    }

    @Override
    public boolean hasNext() {
        return this.currentIterator != null;
    }

    @Override
    public EntryType next() {
        if (this.currentIterator == null) {
            throw new NoSuchElementException();
        }
        EntryType result = this.currentIterator.next();
        this.findNextValidIterator();
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private void findNextValidIterator() {
        while (this.currentIterator != null && !this.currentIterator.hasNext()) {
            if (this.remainingIterators.isEmpty()) {
                this.setCurrentIterator(null);
                continue;
            }
            this.setCurrentIterator(this.remainingIterators.removeFirst());
        }
    }

    private void setCurrentIterator(Iterator<EntryType> currentIterator) {
        this.currentIterator = currentIterator;
    }

    private void setRemainingIterators(LinkedList<Iterator<EntryType>> remainingIterators) {
        if (remainingIterators == null) {
            throw new NullPointerException("The remainingIterators cannot be null.");
        }
        this.remainingIterators = remainingIterators;
    }
}

