/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.algorithm;

import gov.sandia.cognition.algorithm.AbstractIterativeAlgorithm;
import gov.sandia.cognition.algorithm.AnytimeAlgorithm;
import gov.sandia.cognition.annotation.CodeReview;

@CodeReview(reviewer={"Justin Basilico"}, date="2008-07-17", changesNeeded=false, comments={"Abstract class looks fine."})
public abstract class AbstractAnytimeAlgorithm<ResultType>
extends AbstractIterativeAlgorithm
implements AnytimeAlgorithm<ResultType> {
    protected int maxIterations;

    public AbstractAnytimeAlgorithm(int maxIterations) {
        this.setMaxIterations(maxIterations);
    }

    @Override
    public boolean isResultValid() {
        return this.getResult() != null;
    }

    @Override
    public int getMaxIterations() {
        return this.maxIterations;
    }

    @Override
    public void setMaxIterations(int maxIterations) {
        if (maxIterations <= 0) {
            throw new IllegalArgumentException("maxIterations must be greater than zero.");
        }
        this.maxIterations = maxIterations;
    }
}

