/*
 * Decompiled with CFR 0.152.
 */
package com.caffeineowl.graphics.samples;

import com.caffeineowl.graphics.bezier.BezierUtils;
import com.caffeineowl.graphics.bezier.CubicFlatnessAlgorithm;
import com.caffeineowl.graphics.bezier.CubicSegmentConsumer;
import com.caffeineowl.graphics.bezier.CubicSubdivisionCriterion;
import com.caffeineowl.graphics.bezier.QuadSegmentConsumer;
import com.caffeineowl.graphics.bezier.QuadSubdivisionCriterion;
import com.caffeineowl.graphics.bezier.flatnessalgos.ConvexHullSubdivCriterion;
import com.caffeineowl.graphics.bezier.flatnessalgos.LineDefectSubdivCriterion;
import com.caffeineowl.graphics.bezier.flatnessalgos.SimpleConvexHullSubdivCriterion;
import com.caffeineowl.graphics.samples.BezierPanel;
import com.caffeineowl.graphics.samples.BezierPanelListener;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.font.LineMetrics;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.QuadCurve2D;

public class BezierFlatteningPanel
extends BezierPanel {
    static Font numSegsFont = new Font("monospaced", 0, 12);
    FlatnessAlgoType flatnessAlgoType = FlatnessAlgoType.ROBUST_CONVEX_HULL;
    DistanceType distanceType = DistanceType.EUCLID;
    double tolerance = 50.0;
    Color linePaint;
    Stroke lineStroke;
    QuadOrCubicSegsFormatter segsFormatter;
    FlattenerByAdaptiveHalving flattener;

    BezierFlatteningPanel(boolean representingCubic) {
        this.setRepresentingCubic(representingCubic);
        this.linePaint = Color.magenta;
        this.lineStroke = new BasicStroke(1.0f, 1, 1, 10.0f, new float[]{5.0f, 5.0f}, 0.0f);
        this.segsFormatter = new QuadOrCubicSegsFormatter();
        this.flattener = new FlattenerByAdaptiveHalving(this);
        this.addCurveChangeListener(this.flattener);
        this.flattener.curveChanged(this);
    }

    protected final CubicSubdivisionCriterion createCubicSubdivCriterion() {
        CubicFlatnessAlgorithm toRet = null;
        block0 : switch (this.flatnessAlgoType) {
            case LINE_DEFECT: {
                switch (this.distanceType) {
                    case CHEBYSHEV: {
                        toRet = new LineDefectSubdivCriterion(2, this.tolerance);
                        break block0;
                    }
                    case MANHATTAN: {
                        toRet = new LineDefectSubdivCriterion(1, this.tolerance);
                        break block0;
                    }
                }
                toRet = new LineDefectSubdivCriterion(0, this.tolerance);
                break;
            }
            case SIMPLE_CONVEX_HULL: {
                toRet = new SimpleConvexHullSubdivCriterion(this.tolerance);
                break;
            }
            default: {
                toRet = new ConvexHullSubdivCriterion(this.tolerance);
            }
        }
        return toRet;
    }

    protected final QuadSubdivisionCriterion createQuadSubdivCriterion() {
        CubicFlatnessAlgorithm toRet = null;
        switch (this.flatnessAlgoType) {
            case LINE_DEFECT: {
                toRet = new LineDefectSubdivCriterion(this.tolerance);
                break;
            }
            case SIMPLE_CONVEX_HULL: {
                toRet = new SimpleConvexHullSubdivCriterion(this.tolerance);
                break;
            }
            default: {
                toRet = new ConvexHullSubdivCriterion(this.tolerance);
            }
        }
        return toRet;
    }

    public QuadOrCubicSegsFormatter getSegsFormatter() {
        return this.segsFormatter;
    }

    public double getTolerance() {
        return this.tolerance;
    }

    public FlatnessAlgoType getFlatnessAlgoType() {
        return this.flatnessAlgoType;
    }

    public void setFlatnessAlgoType(FlatnessAlgoType flatnessAlgoType) {
        this.flatnessAlgoType = flatnessAlgoType;
        this.flattener.curveChanged(this);
    }

    public DistanceType getDistanceType() {
        return this.distanceType;
    }

    public void setDistanceType(DistanceType distanceType) {
        this.distanceType = distanceType;
        this.flattener.curveChanged(this);
    }

    public void setTolerance(double tolerance) {
        this.tolerance = tolerance;
        this.flattener.curveChanged(this);
    }

    public Color getLinePaint() {
        return this.linePaint;
    }

    public void setLinePaint(Color linePaint) {
        this.linePaint = linePaint;
        this.repaint(50L);
    }

    public Stroke getLineStroke() {
        return this.lineStroke;
    }

    public void setLineStroke(Stroke lineStroke) {
        this.lineStroke = lineStroke;
        this.repaint(50L);
    }

    public GeneralPath getSegsChain() {
        return this.segsFormatter.getSegsChain();
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.setPaint(this.getLinePaint());
        g2.setStroke(this.getLineStroke());
        g2.draw(this.getSegsChain());
        StringBuffer numTxt = new StringBuffer("Num segs: ");
        numTxt.append(this.segsFormatter.getNumSegs());
        g2.setFont(numSegsFont);
        LineMetrics lm = numSegsFont.getLineMetrics(numTxt.toString(), g2.getFontRenderContext());
        g2.setPaint(this.getDotPaint());
        g2.drawString(numTxt.toString(), 10.0f, (float)(this.getHeight() - 10) - lm.getAscent());
    }

    public void setBounds(int x, int y, int w, int h) {
        super.setBounds(x, y, w, h);
        if (null != this.flattener) {
            this.flattener.curveChanged(this);
        }
    }

    public void setRepresentingCubic(boolean b) {
        super.setRepresentingCubic(b);
        if (null != this.flattener) {
            this.flattener.curveChanged(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DistanceType {
        EUCLID,
        MANHATTAN,
        CHEBYSHEV;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FlatnessAlgoType {
        SIMPLE_CONVEX_HULL,
        ROBUST_CONVEX_HULL,
        LINE_DEFECT;

    }

    static class FlattenerByAdaptiveHalving
    implements BezierPanelListener {
        BezierFlatteningPanel served;

        FlattenerByAdaptiveHalving(BezierFlatteningPanel parent) {
            this.served = parent;
        }

        public void curveChanged(BezierPanel panel) {
            if (this.served == panel) {
                if (this.served.isRepresentingCubic()) {
                    CubicSubdivisionCriterion crit = this.served.createCubicSubdivCriterion();
                    CubicCurve2D c = this.served.getRepresentedCubic();
                    BezierUtils.adaptiveHalving(c, crit, this.served.getSegsFormatter());
                } else {
                    QuadSubdivisionCriterion crit = this.served.createQuadSubdivCriterion();
                    QuadCurve2D c = this.served.getRepresentedQuad();
                    BezierUtils.adaptiveHalving(c, crit, this.served.getSegsFormatter());
                }
                if (this.served.isDisplayable()) {
                    this.served.repaint(33L);
                }
            }
        }
    }

    static class QuadOrCubicSegsFormatter
    implements CubicSegmentConsumer,
    QuadSegmentConsumer {
        GeneralPath segsChain = new GeneralPath();
        int numSegs;

        public int getNumSegs() {
            return this.numSegs;
        }

        public void processSegment(CubicCurve2D segment, double startT, double endT) {
            if (0.0 == startT) {
                this.segsChain.reset();
                this.segsChain.moveTo(segment.getX1(), segment.getY1());
                this.numSegs = 0;
            }
            this.segsChain.lineTo(segment.getX2(), segment.getY2());
            ++this.numSegs;
        }

        public void processSegment(QuadCurve2D segment, double startT, double endT) {
            if (0.0 == startT) {
                this.segsChain.reset();
                this.segsChain.moveTo(segment.getX1(), segment.getY1());
                this.numSegs = 0;
            }
            this.segsChain.lineTo(segment.getX2(), segment.getY2());
            ++this.numSegs;
        }

        public GeneralPath getSegsChain() {
            return this.segsChain;
        }
    }
}

