/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.ext;

import java.io.PrintWriter;
import java.io.Writer;
import java.util.Map;
import org.jgrapht.DirectedGraph;
import org.jgrapht.Graph;
import org.jgrapht.ext.ComponentAttributeProvider;
import org.jgrapht.ext.EdgeNameProvider;
import org.jgrapht.ext.IntegerNameProvider;
import org.jgrapht.ext.VertexNameProvider;

public class DOTExporter<V, E> {
    private VertexNameProvider<V> vertexIDProvider;
    private VertexNameProvider<V> vertexLabelProvider;
    private EdgeNameProvider<E> edgeLabelProvider;
    private ComponentAttributeProvider<V> vertexAttributeProvider;
    private ComponentAttributeProvider<E> edgeAttributeProvider;

    public DOTExporter() {
        this(new IntegerNameProvider(), null, null);
    }

    public DOTExporter(VertexNameProvider<V> vertexNameProvider, VertexNameProvider<V> vertexNameProvider2, EdgeNameProvider<E> edgeNameProvider) {
        this(vertexNameProvider, vertexNameProvider2, edgeNameProvider, null, null);
    }

    public DOTExporter(VertexNameProvider<V> vertexNameProvider, VertexNameProvider<V> vertexNameProvider2, EdgeNameProvider<E> edgeNameProvider, ComponentAttributeProvider<V> componentAttributeProvider, ComponentAttributeProvider<E> componentAttributeProvider2) {
        this.vertexIDProvider = vertexNameProvider;
        this.vertexLabelProvider = vertexNameProvider2;
        this.edgeLabelProvider = edgeNameProvider;
        this.vertexAttributeProvider = componentAttributeProvider;
        this.edgeAttributeProvider = componentAttributeProvider2;
    }

    public void export(Writer writer, Graph<V, E> graph) {
        Object object;
        String string;
        String string2;
        PrintWriter printWriter = new PrintWriter(writer);
        String string3 = "  ";
        if (graph instanceof DirectedGraph) {
            printWriter.println("digraph G {");
            string2 = " -> ";
        } else {
            printWriter.println("graph G {");
            string2 = " -- ";
        }
        for (Object object2 : graph.vertexSet()) {
            printWriter.print(string3 + this.getVertexID(object2));
            string = null;
            if (this.vertexLabelProvider != null) {
                string = this.vertexLabelProvider.getVertexName(object2);
            }
            object = null;
            if (this.vertexAttributeProvider != null) {
                object = this.vertexAttributeProvider.getComponentAttributes(object2);
            }
            this.renderAttributes(printWriter, string, (Map<String, String>)object);
            printWriter.println(";");
        }
        for (Object object2 : graph.edgeSet()) {
            string = this.getVertexID(graph.getEdgeSource(object2));
            object = this.getVertexID(graph.getEdgeTarget(object2));
            printWriter.print(string3 + string + string2 + (String)object);
            String string4 = null;
            if (this.edgeLabelProvider != null) {
                string4 = this.edgeLabelProvider.getEdgeName(object2);
            }
            Map<String, String> map = null;
            if (this.edgeAttributeProvider != null) {
                map = this.edgeAttributeProvider.getComponentAttributes(object2);
            }
            this.renderAttributes(printWriter, string4, map);
            printWriter.println(";");
        }
        printWriter.println("}");
        printWriter.flush();
    }

    private void renderAttributes(PrintWriter printWriter, String string, Map<String, String> map) {
        if (string == null && map == null) {
            return;
        }
        printWriter.print(" [ ");
        if (string == null) {
            string = map.get("label");
        }
        if (string != null) {
            printWriter.print("label=\"" + string + "\" ");
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String string2 = entry.getKey();
            if (string2.equals("label")) continue;
            printWriter.print(string2 + "=\"" + entry.getValue() + "\" ");
        }
        printWriter.print("]");
    }

    private String getVertexID(V v) {
        String string = this.vertexIDProvider.getVertexName(v);
        boolean bl = string.matches("[a-zA-Z]+([\\w_]*)?");
        boolean bl2 = string.matches("\".*\"");
        boolean bl3 = string.matches("[-]?([.][0-9]+|[0-9]+([.][0-9]*)?)");
        boolean bl4 = string.matches("<.*>");
        if (bl || bl3 || bl2 || bl4) {
            return string;
        }
        throw new RuntimeException("Generated id '" + string + "'for vertex '" + v + "' is not valid with respect to the .dot language");
    }
}

