/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.alg;

import java.util.HashSet;
import java.util.Set;
import org.jgrapht.UndirectedGraph;
import org.jgrapht.alg.BlockCutpointGraph;

public class BiconnectivityInspector<V, E> {
    private BlockCutpointGraph<V, E> blockCutpointGraph;

    public BiconnectivityInspector(UndirectedGraph<V, E> undirectedGraph) {
        this.blockCutpointGraph = new BlockCutpointGraph<V, E>(undirectedGraph);
    }

    public Set<Set<V>> getBiconnectedVertexComponents() {
        HashSet<Set<V>> hashSet = new HashSet<Set<V>>();
        for (UndirectedGraph undirectedGraph : this.blockCutpointGraph.vertexSet()) {
            if (undirectedGraph.edgeSet().isEmpty()) continue;
            hashSet.add(undirectedGraph.vertexSet());
        }
        return hashSet;
    }

    public Set<Set<V>> getBiconnectedVertexComponents(V v) {
        HashSet<Set<V>> hashSet = new HashSet<Set<V>>();
        for (Set<V> set : this.getBiconnectedVertexComponents()) {
            if (!set.contains(v)) continue;
            hashSet.add(set);
        }
        return hashSet;
    }

    public Set<V> getCutpoints() {
        return this.blockCutpointGraph.getCutpoints();
    }

    public boolean isBiconnected() {
        return this.blockCutpointGraph.vertexSet().size() == 1;
    }
}

