/*
 * Decompiled with CFR 0.152.
 */
package eu.larkc.csparql.sparql.jena;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.TypeMapper;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.Syntax;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.rdf.model.impl.PropertyImpl;
import com.hp.hpl.jena.rdf.model.impl.ResourceImpl;
import com.hp.hpl.jena.rdf.model.impl.StatementImpl;
import com.hp.hpl.jena.sparql.function.FunctionRegistry;
import eu.larkc.csparql.common.RDFTable;
import eu.larkc.csparql.common.RDFTuple;
import eu.larkc.csparql.sparql.api.SparqlEngine;
import eu.larkc.csparql.sparql.api.SparqlQuery;
import eu.larkc.csparql.sparql.jena.ext.timestamp;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class JenaEngine
implements SparqlEngine {
    private Model model = null;
    Map<String, Model> graphs = new HashMap<String, Model>();
    Map<String, Long> timestamps = new HashMap<String, Long>();
    List<String> ambiguousResources = new LinkedList<String>();

    public JenaEngine() {
        FunctionRegistry.get().put("http://larkc.eu/csparql/sparql/jena/ext#timestamp", timestamp.class);
        timestamp.timestamps = this.timestamps;
    }

    @Override
    public void addStatement(String subject, String predicate, String object) {
        this.addStatement(subject, predicate, object, 0L);
    }

    @Override
    public void addStatement(String subject, String predicate, String object, long timestamp2) {
        StatementImpl s;
        String[] objectParts;
        if (timestamp2 != 0L) {
            if (this.timestamps.containsKey(subject)) {
                this.ambiguousResources.add(subject);
            } else {
                this.timestamps.put(subject, new Long(timestamp2));
            }
            if (this.timestamps.containsKey(predicate)) {
                this.ambiguousResources.add(predicate);
            } else {
                this.timestamps.put(predicate, new Long(timestamp2));
            }
            if (this.timestamps.containsKey(object)) {
                this.ambiguousResources.add(object);
            } else {
                this.timestamps.put(object, new Long(timestamp2));
            }
        }
        if ((objectParts = object.split("\\^\\^")).length > 1) {
            TypeMapper tm = TypeMapper.getInstance();
            RDFDatatype d = tm.getTypeByName(objectParts[1]);
            Model m = ModelFactory.createDefaultModel();
            Literal lObject = this.model.createTypedLiteral(objectParts[0].replaceAll("\"", ""), d);
            s = new StatementImpl(new ResourceImpl(subject), new PropertyImpl(predicate), lObject);
        } else {
            s = new StatementImpl(new ResourceImpl(subject), new PropertyImpl(predicate), new ResourceImpl(object));
        }
        this.model.add(s);
    }

    @Override
    public void clean() {
        this.model.remove(this.model);
        this.timestamps.clear();
    }

    @Override
    public void destroy() {
        this.model.close();
        this.timestamps.clear();
    }

    @Override
    public RDFTable evaluateQuery(SparqlQuery query) {
        RDFTable table;
        block8: {
            QueryExecution qexec;
            Model m;
            Query q;
            block9: {
                block7: {
                    for (String s : this.ambiguousResources) {
                        this.timestamps.remove(s);
                    }
                    this.ambiguousResources.clear();
                    q = QueryFactory.create(query.getQueryCommand(), Syntax.syntaxARQ);
                    for (String s : q.getGraphURIs()) {
                        if (!this.graphs.containsKey(s)) {
                            m = ModelFactory.createDefaultModel();
                            m.read(s);
                            this.graphs.put(s, m);
                        }
                        this.model.add(this.graphs.get(s));
                    }
                    qexec = QueryExecutionFactory.create(q, this.model);
                    table = null;
                    if (!q.isSelectType()) break block7;
                    ResultSet resultSet = qexec.execSelect();
                    table = new RDFTable(resultSet.getResultVars());
                    while (resultSet.hasNext()) {
                        RDFTuple tuple = new RDFTuple();
                        QuerySolution soln = resultSet.nextSolution();
                        for (String s : table.getNames()) {
                            RDFNode n = soln.get(s);
                            if (n == null) {
                                tuple.addFields("");
                                continue;
                            }
                            tuple.addFields(this.format(n));
                        }
                        table.add(tuple);
                    }
                    break block8;
                }
                if (!q.isAskType()) break block9;
                table = new RDFTable("Answer");
                RDFTuple tuple = new RDFTuple();
                tuple.addFields("" + qexec.execAsk());
                table.add(tuple);
                break block8;
            }
            if (!q.isDescribeType() && !q.isConstructType()) break block8;
            m = null;
            m = q.isDescribeType() ? qexec.execDescribe() : qexec.execConstruct();
            table = new RDFTable("Subject", "Predicate", "Object", "Timestamp");
            StmtIterator it = m.listStatements();
            while (it.hasNext()) {
                RDFTuple tuple = new RDFTuple();
                Statement stm = (Statement)it.next();
                tuple.addFields(this.formatSubject(stm.getSubject()), this.formatPredicate(stm.getPredicate()), this.format(stm.getObject()));
                table.add(tuple);
            }
        }
        return table;
    }

    private String format(RDFNode n) {
        if (n.isLiteral()) {
            return "\"" + n.asLiteral().getLexicalForm() + "\"^^" + n.asLiteral().getDatatypeURI();
        }
        return n.toString();
    }

    private String formatPredicate(Property predicate) {
        return predicate.toString();
    }

    private String formatSubject(Resource subject) {
        return subject.toString();
    }

    @Override
    public void initialize() {
        this.model = ModelFactory.createDefaultModel();
    }
}

