/*
 * Decompiled with CFR 0.152.
 */
package eu.larkc.csparql.cep.esper;

import com.espertech.esper.client.Configuration;
import com.espertech.esper.client.EPServiceProvider;
import com.espertech.esper.client.EPServiceProviderManager;
import com.espertech.esper.client.EPStatement;
import com.espertech.esper.client.EPStatementState;
import com.espertech.esper.client.UpdateListener;
import eu.larkc.csparql.cep.api.CepEngine;
import eu.larkc.csparql.cep.api.CepQuery;
import eu.larkc.csparql.cep.api.RdfQuadruple;
import eu.larkc.csparql.cep.api.RdfSnapshot;
import eu.larkc.csparql.cep.api.RdfStream;
import eu.larkc.csparql.cep.esper.EsperQuery;
import eu.larkc.csparql.cep.esper.QueryListener;
import eu.larkc.csparql.common.streams.format.GenericObservable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class EsperEngine
implements CepEngine {
    private EPServiceProvider epService = null;
    private Map<String, CepQuery> queries = null;
    private Collection<RdfStream> streams = null;
    private Map<String, EPStatement> statements = null;
    private final Configuration configuration = new Configuration();

    @Override
    public Collection<CepQuery> getAllQueries() {
        return this.queries.values();
    }

    @Override
    public Collection<RdfStream> getAllRegisteredStreams() {
        return this.streams;
    }

    @Override
    public void initialize() {
        this.epService = EPServiceProviderManager.getDefaultProvider((Configuration)this.configuration);
        this.epService.initialize();
        this.queries = new HashMap<String, CepQuery>();
        this.streams = new ArrayList<RdfStream>();
        this.statements = new HashMap<String, EPStatement>();
    }

    @Override
    public void registerStream(RdfStream p) {
        String un = p.uniqueName();
        this.epService.getEPAdministrator().getConfiguration().addImport(RdfQuadruple.class);
        this.epService.getEPAdministrator().getConfiguration().addEventType(un, RdfQuadruple.class);
        p.addObserver(this);
        this.streams.add(p);
    }

    @Override
    public void unregisterQuery(String id) {
        this.queries.remove(id);
    }

    @Override
    public RdfSnapshot registerQuery(String query, String id) {
        EsperQuery qry = new EsperQuery(query);
        this.queries.put(id, qry);
        EPStatement stmt = this.epService.getEPAdministrator().createEPL(query);
        this.statements.put(id, stmt);
        QueryListener l = new QueryListener(id);
        stmt.addListener((UpdateListener)l);
        return l;
    }

    @Override
    public void destroy() {
        this.epService.destroy();
    }

    @Override
    public void update(GenericObservable<RdfQuadruple> observed, RdfQuadruple q) {
        RdfStream s = (RdfStream)observed;
        q.setStreamName(s.getIRI());
        this.epService.getEPRuntime().sendEvent((Object)q);
    }

    @Override
    public void startQuery(String id) {
        EPStatement s = this.getStatementById(id);
        if (s != null) {
            s.start();
        }
    }

    @Override
    public void stopQuery(String id) {
        EPStatementState state;
        EPStatement s = this.getStatementById(id);
        if (s != null && (state = s.getState()).compareTo((Enum)EPStatementState.STOPPED) != 0) {
            s.stop();
        }
    }

    private EPStatement getStatementById(String id) {
        if (this.statements.containsKey(id)) {
            return this.statements.get(id);
        }
        return null;
    }

    @Override
    public void unregisterStream(RdfStream stream) {
        this.streams.remove(stream);
    }
}

