/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.video.processing.pixels;

import org.openimaj.image.FImage;
import org.openimaj.image.MBFImage;
import org.openimaj.video.analyser.VideoAnalyser;

public class MBFMeanVarianceField
extends VideoAnalyser<MBFImage> {
    private MBFImage mean;
    private MBFImage m2;
    private int n;

    public void analyseFrame(MBFImage frame) {
        int width = frame.getWidth();
        int height = frame.getHeight();
        int nBands = frame.numBands();
        if (this.mean == null || this.mean.getWidth() != width || this.mean.getHeight() != height || this.mean.numBands() != nBands) {
            this.n = 0;
            this.mean = new MBFImage(width, height, nBands);
            this.m2 = new MBFImage(width, height, nBands);
        }
        for (int b = 0; b < nBands; ++b) {
            float[][] mp = ((FImage)this.mean.getBand((int)b)).pixels;
            float[][] m2p = ((FImage)this.m2.getBand((int)b)).pixels;
            float[][] fp = ((FImage)frame.getBand((int)b)).pixels;
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    float v = fp[y][x];
                    float delta = v - mp[y][x];
                    ++this.n;
                    mp[y][x] = mp[y][x] + delta / (float)this.n;
                    m2p[y][x] = m2p[y][x] + delta * (v - mp[y][x]);
                }
            }
        }
    }

    public void reset() {
        this.mean = null;
        this.m2 = null;
    }

    public MBFImage getMean() {
        return this.mean;
    }

    public MBFImage getVariance() {
        if (this.m2 == null) {
            return null;
        }
        return (MBFImage)this.m2.divide((Comparable)Float.valueOf(this.n - 1));
    }
}

