/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.video.processing.motion;

import edu.emory.mathcs.jtransforms.fft.FloatFFT_2D;
import org.apache.commons.math.FieldElement;
import org.apache.commons.math.complex.Complex;
import org.apache.commons.math.linear.Array2DRowFieldMatrix;
import org.apache.commons.math.linear.FieldLUDecompositionImpl;
import org.apache.commons.math.linear.FieldMatrix;
import org.openimaj.image.FImage;
import org.openimaj.image.analysis.algorithm.TemplateMatcher;
import org.openimaj.image.pixel.FValuePixel;
import org.openimaj.image.processing.algorithm.FourierTransform;
import org.openimaj.math.geometry.point.Point2d;
import org.openimaj.math.geometry.point.Point2dImpl;
import org.openimaj.math.geometry.shape.Rectangle;
import org.openimaj.video.VideoFrame;
import org.openimaj.video.VideoSubFrame;

public abstract class MotionEstimatorAlgorithm {
    abstract Point2d estimateMotion(VideoSubFrame<FImage> var1, VideoSubFrame<FImage> ... var2);

    protected int requiredNumberOfFrames() {
        return 1;
    }

    public static class PHASE_CORRELATION
    extends MotionEstimatorAlgorithm {
        @Override
        public Point2d estimateMotion(VideoSubFrame<FImage> img2sub, VideoSubFrame<FImage> ... imagesSub) {
            FImage img1 = (FImage)imagesSub[0].extract().frame;
            VideoFrame img2 = img2sub.extract();
            if (img1 == null) {
                return new Point2dImpl(0.0f, 0.0f);
            }
            if (img1.getRows() != ((FImage)img2.frame).getRows() || img1.getCols() != ((FImage)img2.frame).getCols() || img1.getCols() != ((FImage)img2.frame).getRows()) {
                return new Point2dImpl(0.0f, 0.0f);
            }
            int h = img1.getRows();
            int w = img1.getCols();
            try {
                FloatFFT_2D fft1 = new FloatFFT_2D(h, w);
                FloatFFT_2D fft2 = new FloatFFT_2D(h, w);
                float[][] data1 = FourierTransform.prepareData((FImage)img1, (int)h, (int)w, (boolean)false);
                float[][] data2 = FourierTransform.prepareData((FImage)((FImage)img2.frame), (int)h, (int)w, (boolean)false);
                fft1.complexForward(data1);
                fft2.complexForward(data2);
                Complex[][] cfft = new Complex[h][w];
                for (int y = 0; y < h; ++y) {
                    for (int x = 0; x < w; ++x) {
                        float re1 = data1[y][x * 2];
                        float im1 = data1[y][1 + x * 2];
                        float re2 = data2[y][x * 2];
                        float im2 = data2[y][1 + x * 2];
                        Complex c1 = new Complex((double)re1, (double)im1);
                        Complex c2 = new Complex((double)re2, (double)(-im2));
                        cfft[y][x] = c1.multiply(c2);
                    }
                }
                Array2DRowFieldMatrix cmat = new Array2DRowFieldMatrix((FieldElement[][])cfft);
                FieldLUDecompositionImpl luDecomp = new FieldLUDecompositionImpl((FieldMatrix)cmat);
                Complex det = (Complex)luDecomp.getDeterminant();
                cmat.scalarMultiply((FieldElement)new Complex(1.0 / det.abs(), 0.0));
                cfft = (Complex[][])cmat.getData();
                for (int y = 0; y < h; ++y) {
                    for (int x = 0; x < w; ++x) {
                        data1[y][x * 2] = (float)cfft[y][x].getReal();
                        data1[y][1 + x * 2] = (float)cfft[y][x].getImaginary();
                    }
                }
                fft1.complexInverse(data1, false);
                FourierTransform.unprepareData((float[][])data1, (FImage)img1, (boolean)false);
                FValuePixel p = img1.maxPixel();
                return new Point2dImpl((float)(-(p.x > w / 2 ? p.x - w : p.x)), (float)(-(p.y > w / 2 ? p.y - w : p.y)));
            }
            catch (Exception e) {
                return new Point2dImpl(0.0f, 0.0f);
            }
        }
    }

    public static class TEMPLATE_MATCH
    extends MotionEstimatorAlgorithm {
        private float searchProp;
        private TemplateMatcher.Mode mode;

        public TEMPLATE_MATCH() {
            this.searchProp = 0.5f;
            this.mode = TemplateMatcher.Mode.NORM_SUM_SQUARED_DIFFERENCE;
        }

        public TEMPLATE_MATCH(float searchWindowBorderProp, TemplateMatcher.Mode mode) {
            this.searchProp = searchWindowBorderProp;
            this.mode = mode;
        }

        @Override
        Point2d estimateMotion(VideoSubFrame<FImage> img1sub, VideoSubFrame<FImage> ... imagesSub) {
            VideoFrame current = img1sub.extract();
            VideoSubFrame<FImage> prev = imagesSub[0];
            Rectangle prevSearchRect = imagesSub[0].roi;
            int sw = (int)(prevSearchRect.width * this.searchProp);
            int sh = (int)(prevSearchRect.height * this.searchProp);
            int sx = (int)(prevSearchRect.x + (prevSearchRect.width - (float)sw) / 2.0f);
            int sy = (int)(prevSearchRect.y + (prevSearchRect.height - (float)sh) / 2.0f);
            Rectangle searchRect = new Rectangle((float)sx, (float)sy, (float)sw, (float)sh);
            TemplateMatcher matcher = new TemplateMatcher((FImage)current.frame, this.mode, searchRect);
            matcher.analyseImage((FImage)prev.frame);
            FValuePixel[] responses = matcher.getBestResponses(1);
            FValuePixel firstBest = responses[0];
            Point2d centerOfGrid = img1sub.roi.calculateCentroid();
            if (firstBest == null || Float.isNaN(firstBest.value)) {
                return new Point2dImpl(0.0f, 0.0f);
            }
            return centerOfGrid.minus((Point2d)firstBest);
        }
    }
}

