/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.processing.transform;

import Jama.Matrix;
import java.util.ArrayList;
import java.util.List;
import org.openimaj.image.Image;
import org.openimaj.image.pixel.Pixel;
import org.openimaj.image.processor.ImageProcessor;
import org.openimaj.image.renderer.ScanRasteriser;
import org.openimaj.math.geometry.point.Point2d;
import org.openimaj.math.geometry.shape.Polygon;
import org.openimaj.math.geometry.shape.Rectangle;
import org.openimaj.math.geometry.shape.Shape;
import org.openimaj.math.geometry.transforms.TransformUtilities;
import org.openimaj.util.pair.Pair;

public class PiecewiseMeshWarp<T, I extends Image<T, I>>
implements ImageProcessor<I> {
    List<Pair<Shape>> matchingRegions;
    List<Matrix> transforms = new ArrayList<Matrix>();
    Rectangle bounds;

    public PiecewiseMeshWarp(List<Pair<Shape>> matchingRegions) {
        this.matchingRegions = matchingRegions;
        this.initTransforms();
    }

    protected final Matrix getTransform(Point2d p) {
        int sz = this.matchingRegions.size();
        for (int i = 0; i < sz; ++i) {
            if (!((Shape)this.matchingRegions.get(i).secondObject()).isInside(p)) continue;
            return this.transforms.get(i);
        }
        return null;
    }

    public Shape getMatchingShape(Point2d p) {
        for (int i = 0; i < this.matchingRegions.size(); ++i) {
            Pair<Shape> matching = this.matchingRegions.get(i);
            if (!((Shape)matching.secondObject()).isInside(p)) continue;
            return (Shape)matching.firstObject();
        }
        return null;
    }

    public int getMatchingShapeIndex(Point2d p) {
        for (int i = 0; i < this.matchingRegions.size(); ++i) {
            Pair<Shape> matching = this.matchingRegions.get(i);
            if (!((Shape)matching.secondObject()).isInside(p)) continue;
            return i;
        }
        return -1;
    }

    protected void initTransforms() {
        this.bounds = new Rectangle(Float.MAX_VALUE, Float.MAX_VALUE, 0.0f, 0.0f);
        for (Pair<Shape> shape : this.matchingRegions) {
            Polygon p1 = ((Shape)shape.firstObject()).asPolygon();
            Polygon p2 = ((Shape)shape.secondObject()).asPolygon();
            this.bounds.x = (float)Math.min((double)this.bounds.x, p2.minX());
            this.bounds.y = (float)Math.min((double)this.bounds.y, p2.minY());
            this.bounds.width = (float)Math.max((double)this.bounds.width, p2.maxX());
            this.bounds.height = (float)Math.max((double)this.bounds.height, p2.maxY());
            if (p1.nVertices() == 3) {
                this.transforms.add(this.getTransform3(this.polyMatchToPointsMatch(p2, p1)));
                continue;
            }
            if (p1.nVertices() == 4) {
                this.transforms.add(this.getTransform4(this.polyMatchToPointsMatch(p2, p1)));
                continue;
            }
            throw new RuntimeException("Only polygons with 3 or 4 vertices are supported!");
        }
        this.bounds.width -= this.bounds.x;
        this.bounds.height -= this.bounds.y;
    }

    protected List<Pair<Point2d>> polyMatchToPointsMatch(Polygon pa, Polygon pb) {
        ArrayList<Pair<Point2d>> pts = new ArrayList<Pair<Point2d>>();
        for (int i = 0; i < pa.nVertices(); ++i) {
            Point2d pta = (Point2d)pa.getVertices().get(i);
            Point2d ptb = (Point2d)pb.getVertices().get(i);
            pts.add((Pair<Point2d>)new Pair((Object)pta, (Object)ptb));
        }
        return pts;
    }

    protected Matrix getTransform4(List<Pair<Point2d>> pts) {
        return TransformUtilities.homographyMatrixNorm(pts);
    }

    protected Matrix getTransform3(List<Pair<Point2d>> pts) {
        return TransformUtilities.affineMatrix(pts);
    }

    public void processImage(I image) {
        int width = image.getWidth();
        int height = image.getHeight();
        Image ret = image.newInstance(width, height);
        Scan scan = new Scan(this, width, height, image, ret);
        for (int i = 0; i < this.matchingRegions.size(); ++i) {
            Polygon from = ((Shape)this.matchingRegions.get(i).secondObject()).asPolygon();
            scan.tf = this.transforms.get(i);
            ScanRasteriser.scanFill((List)from.points, (ScanRasteriser.ScanLineListener)scan);
        }
        image.internalAssign(ret);
    }

    public I transform(I image, int width, int height) {
        Image ret = image.newInstance(width, height);
        Scan scan = new Scan(this, width, height, image, ret);
        for (int i = 0; i < this.matchingRegions.size(); ++i) {
            Polygon from = ((Shape)this.matchingRegions.get(i).secondObject()).asPolygon();
            scan.tf = this.transforms.get(i);
            ScanRasteriser.scanFill((List)from.points, (ScanRasteriser.ScanLineListener)scan);
        }
        return (I)ret;
    }

    private static class Scan
    implements ScanRasteriser.ScanLineListener {
        private final Pixel p = new Pixel();
        private final int xmin;
        private final int ymin;
        private final int xmax;
        private final int ymax;
        private final I image;
        private final I ret;
        Matrix tf;
        final /* synthetic */ PiecewiseMeshWarp this$0;

        Scan(int width, int height, I image, I ret) {
            this.this$0 = var1_1;
            this.xmin = (int)Math.max(0.0f, this.this$0.bounds.x);
            this.ymin = (int)Math.max(0.0f, this.this$0.bounds.y);
            this.xmax = (int)Math.min((float)width, var1_1.bounds.x + var1_1.bounds.width);
            this.ymax = (int)Math.min((float)height, var1_1.bounds.y + var1_1.bounds.height);
            this.image = image;
            this.ret = ret;
        }

        public void process(int x1, int x2, int y) {
            if (y < this.ymin || y > this.ymax) {
                return;
            }
            int startx = Math.max(this.xmin, Math.min(x1, x2));
            int stopx = Math.min(this.xmax, Math.max(x1, x2));
            for (int x = startx; x <= stopx; ++x) {
                this.p.x = x;
                this.p.y = y;
                this.p.transformInplace(this.tf);
                this.ret.setPixel(x, y, this.image.getPixelInterp((double)this.p.x, (double)this.p.y));
            }
        }
    }
}

