/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.feature.local.engine.asift;

import java.util.Map;
import org.openimaj.feature.local.list.LocalFeatureList;
import org.openimaj.feature.local.list.MemoryLocalFeatureList;
import org.openimaj.image.MBFImage;
import org.openimaj.image.feature.local.affine.AffineSimulationExtractor;
import org.openimaj.image.feature.local.affine.AffineSimulationKeypoint;
import org.openimaj.image.feature.local.affine.ColourASIFT;
import org.openimaj.image.feature.local.engine.DoGSIFTEngineOptions;
import org.openimaj.image.feature.local.engine.Engine;
import org.openimaj.image.feature.local.keypoints.Keypoint;
import org.openimaj.image.processing.transform.AffineParams;

public class ColourASIFTEngine
implements Engine<AffineSimulationKeypoint, MBFImage> {
    protected AffineSimulationExtractor<LocalFeatureList<Keypoint>, Keypoint, MBFImage, Float[]> asift;
    protected int nTilts = 5;

    public ColourASIFTEngine() {
        this(false);
    }

    public ColourASIFTEngine(boolean hires) {
        this.asift = new ColourASIFT(hires);
    }

    public ColourASIFTEngine(boolean hires, int nTilts) {
        this.asift = new ColourASIFT(hires);
        this.nTilts = nTilts;
    }

    public ColourASIFTEngine(DoGSIFTEngineOptions<MBFImage> opts) {
        this.asift = new ColourASIFT(opts);
    }

    public ColourASIFTEngine(DoGSIFTEngineOptions<MBFImage> opts, int nTilts) {
        this.asift = new ColourASIFT(opts);
        this.nTilts = nTilts;
    }

    public LocalFeatureList<Keypoint> findKeypoints(MBFImage image) {
        this.asift.detectFeatures(image, this.nTilts);
        return this.asift.getFeatures();
    }

    public LocalFeatureList<Keypoint> findKeypoints(MBFImage image, AffineParams params) {
        return this.asift.detectFeatures(image, params);
    }

    public Map<AffineParams, LocalFeatureList<Keypoint>> findKeypointsMapped(MBFImage image) {
        this.asift.detectFeatures(image, this.nTilts);
        return this.asift.getKeypointsMap();
    }

    @Override
    public LocalFeatureList<AffineSimulationKeypoint> findFeatures(MBFImage image) {
        this.asift.detectFeatures(image, this.nTilts);
        Map<AffineParams, LocalFeatureList<Keypoint>> keypointMap = this.asift.getKeypointsMap();
        MemoryLocalFeatureList affineSimulationList = new MemoryLocalFeatureList();
        for (AffineParams params : this.asift.simulationOrder) {
            for (Keypoint k : keypointMap.get(params)) {
                affineSimulationList.add((Object)new AffineSimulationKeypoint(k, params, this.asift.simulationOrder.indexOf(params)));
            }
        }
        return affineSimulationList;
    }
}

